/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.datetime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.EmptyRestrictedDatatype;
import openllet.core.datatypes.Facet;
import openllet.core.datatypes.OWLRealUtils;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidConstrainingFacetException;
import openllet.core.datatypes.types.real.ContinuousRealInterval;
import openllet.core.exceptions.InternalReasonerException;
import openllet.shared.tools.Log;

public class RestrictedTimelineDatatype
implements RestrictedDatatype<XMLGregorianCalendar> {
    private static final DatatypeFactory dtFactory;
    private static final Logger _logger;
    private static final BigInteger SEC_PER_DAY;
    private static final BigInteger SEC_PER_YEAR;
    private static final int TZ_SHIFT = 50400;
    protected final Datatype<? extends XMLGregorianCalendar> _datatype;
    protected final RestrictedDatatype<XMLGregorianCalendar> _empty;
    protected final boolean _enumerable;
    protected final boolean _finite;
    protected final List<ContinuousRealInterval> _nzIntervals;
    protected final QName _schemaType;
    protected final List<ContinuousRealInterval> _wzIntervals;

    private static Number calendarToReal(XMLGregorianCalendar c) {
        BigInteger y;
        BigInteger yrPlusOne = c.getEonAndYear();
        BigInteger bigInteger = y = yrPlusOne == null ? BigInteger.valueOf(1971L) : yrPlusOne.subtract(BigInteger.ONE);
        if (yrPlusOne == null) {
            yrPlusOne = BigInteger.valueOf(1972L);
        }
        int month = c.getMonth() == Integer.MIN_VALUE ? 12 : c.getMonth();
        int day = c.getDay() == Integer.MIN_VALUE ? RestrictedTimelineDatatype.daysInMonth(yrPlusOne, month) - 1 : c.getDay() - 1;
        int hour = c.getHour() == Integer.MIN_VALUE ? 0 : c.getHour();
        int minute = c.getMinute() == Integer.MIN_VALUE ? 0 : c.getMinute();
        int second = c.getSecond() == Integer.MIN_VALUE ? 0 : c.getSecond();
        BigDecimal fractionalSecond = c.getFractionalSecond();
        int tz = c.getTimezone();
        if (tz != Integer.MIN_VALUE) {
            minute -= tz;
        }
        BigInteger toTi = SEC_PER_YEAR.multiply(y);
        toTi = toTi.add(SEC_PER_DAY.multiply(y.divide(BigInteger.valueOf(400L)).subtract(y.divide(BigInteger.valueOf(100L))).add(y.divide(BigInteger.valueOf(4L)))));
        int daySum = day;
        for (int m = 1; m < month; ++m) {
            daySum += RestrictedTimelineDatatype.daysInMonth(yrPlusOne, m);
        }
        toTi = toTi.add(BigInteger.valueOf(86400L * (long)daySum));
        toTi = toTi.add(BigInteger.valueOf(3600L * (long)hour + 60L * (long)minute + (long)second));
        if (fractionalSecond == null || BigDecimal.ZERO.equals(fractionalSecond)) {
            return OWLRealUtils.getCanonicalObject(toTi);
        }
        return new BigDecimal(toTi).add(fractionalSecond);
    }

    private static int daysInMonth(BigInteger year, int month) {
        if (month == 2) {
            if (year.remainder(BigInteger.valueOf(4L)).equals(BigInteger.ZERO)) {
                if (year.remainder(BigInteger.valueOf(100L)).equals(BigInteger.ZERO)) {
                    if (year.remainder(BigInteger.valueOf(400L)).equals(BigInteger.ZERO)) {
                        return 29;
                    }
                    return 28;
                }
                return 29;
            }
            return 28;
        }
        switch (month) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException();
    }

    public static DatatypeFactory getDatatypeFactory() {
        return dtFactory;
    }

    private static ContinuousRealInterval zoneShrink(ContinuousRealInterval i) {
        Number upper;
        Number lower = i.boundLower() ? (Number)OWLRealUtils.sum(i.getLower(), 50400) : (Number)null;
        Number number = upper = i.boundUpper() ? (Number)OWLRealUtils.sum(i.getUpper(), -50400) : (Number)null;
        if (lower != null && upper != null) {
            int cmp = OWLRealUtils.compare(lower, upper);
            if (cmp > 0) {
                return null;
            }
            if (cmp == 0) {
                if (!i.inclusiveLower() && !i.inclusiveUpper()) {
                    return null;
                }
                return new ContinuousRealInterval(lower);
            }
        }
        return new ContinuousRealInterval(lower, upper, i.inclusiveLower(), i.inclusiveUpper());
    }

    public RestrictedTimelineDatatype(Datatype<? extends XMLGregorianCalendar> datatype, QName schemaType, boolean requireTz) {
        this._datatype = datatype;
        this._schemaType = schemaType;
        this._empty = new EmptyRestrictedDatatype<XMLGregorianCalendar>(datatype);
        this._wzIntervals = Collections.singletonList(ContinuousRealInterval.allReals());
        this._nzIntervals = requireTz ? Collections.emptyList() : Collections.singletonList(ContinuousRealInterval.allReals());
        this._finite = false;
        this._enumerable = false;
    }

    private RestrictedTimelineDatatype(RestrictedTimelineDatatype other, List<ContinuousRealInterval> wzIntervals, List<ContinuousRealInterval> nzIntervals) {
        this._datatype = other._datatype;
        this._empty = other._empty;
        this._schemaType = other._schemaType;
        this._wzIntervals = Collections.unmodifiableList(wzIntervals);
        this._nzIntervals = Collections.unmodifiableList(nzIntervals);
        if (other._finite) {
            this._finite = true;
        } else {
            boolean allFinite = true;
            for (ContinuousRealInterval i : wzIntervals) {
                if (i.isPoint()) continue;
                allFinite = false;
                break;
            }
            if (allFinite) {
                for (ContinuousRealInterval i : wzIntervals) {
                    if (i.isPoint()) continue;
                    allFinite = false;
                    break;
                }
            }
            this._finite = allFinite;
        }
        if (other._enumerable) {
            this._enumerable = true;
        } else {
            boolean allEnumerable = nzIntervals.isEmpty();
            if (allEnumerable) {
                for (ContinuousRealInterval i : wzIntervals) {
                    if (i.isPoint()) continue;
                    allEnumerable = false;
                    break;
                }
            }
            this._enumerable = allEnumerable;
        }
    }

    @Override
    public RestrictedDatatype<XMLGregorianCalendar> applyConstrainingFacet(ATermAppl facet, Object value) throws InvalidConstrainingFacetException {
        ContinuousRealInterval wzRestriction;
        ContinuousRealInterval nzRestriction;
        boolean inclusiveUpper;
        Number upper;
        boolean inclusiveLower;
        Number lower;
        Facet f = Facet.Registry.get(facet);
        if (f == null) {
            String msg = String.format("Attempt to constrain datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), facet, value);
            _logger.severe(msg);
            throw new InvalidConstrainingFacetException(msg, facet, value);
        }
        XMLGregorianCalendar c = null;
        if (value instanceof XMLGregorianCalendar) {
            c = (XMLGregorianCalendar)value;
        }
        if (c == null || !this.isValidValue(c)) {
            String msg = String.format("Attempt to constrain datatype (%s) using constraining facet ('%s') with an unsupported value ('%s')", this.getDatatype(), f, value);
            _logger.severe(msg);
            throw new InvalidConstrainingFacetException(msg, facet, value);
        }
        if (Facet.XSD.MAX_EXCLUSIVE.equals(f)) {
            lower = null;
            inclusiveLower = false;
            upper = RestrictedTimelineDatatype.calendarToReal(c);
            inclusiveUpper = false;
        } else if (Facet.XSD.MAX_INCLUSIVE.equals(f)) {
            lower = null;
            inclusiveLower = false;
            upper = RestrictedTimelineDatatype.calendarToReal(c);
            inclusiveUpper = true;
        } else if (Facet.XSD.MIN_EXCLUSIVE.equals(f)) {
            lower = RestrictedTimelineDatatype.calendarToReal(c);
            inclusiveLower = false;
            upper = null;
            inclusiveUpper = false;
        } else if (Facet.XSD.MIN_INCLUSIVE.equals(f)) {
            lower = RestrictedTimelineDatatype.calendarToReal(c);
            inclusiveLower = true;
            upper = null;
            inclusiveUpper = false;
        } else {
            throw new IllegalStateException();
        }
        ContinuousRealInterval restriction = new ContinuousRealInterval(lower, upper, inclusiveLower, inclusiveUpper);
        if (c.getTimezone() == Integer.MIN_VALUE) {
            nzRestriction = restriction;
            wzRestriction = RestrictedTimelineDatatype.zoneShrink(nzRestriction);
        } else {
            wzRestriction = restriction;
            nzRestriction = RestrictedTimelineDatatype.zoneShrink(wzRestriction);
        }
        boolean changes = false;
        ArrayList<ContinuousRealInterval> revisedWz = new ArrayList<ContinuousRealInterval>();
        if (wzRestriction == null) {
            changes = this._wzIntervals.isEmpty();
        } else {
            for (ContinuousRealInterval i : this._wzIntervals) {
                ContinuousRealInterval j = i.intersection(wzRestriction);
                if (j != null) {
                    revisedWz.add(j);
                    if (i == j) continue;
                    changes = true;
                    continue;
                }
                changes = true;
            }
        }
        ArrayList<ContinuousRealInterval> revisedNz = new ArrayList<ContinuousRealInterval>();
        if (nzRestriction == null) {
            changes |= this._nzIntervals.isEmpty();
        } else {
            for (ContinuousRealInterval i : this._nzIntervals) {
                ContinuousRealInterval j = i.intersection(nzRestriction);
                if (j != null) {
                    revisedNz.add(j);
                    if (i == j) continue;
                    changes = true;
                    continue;
                }
                changes = true;
            }
        }
        if (changes) {
            if (revisedWz.isEmpty() && revisedNz.isEmpty()) {
                return this._empty;
            }
            return RestrictedTimelineDatatype.create(this, revisedWz, revisedNz);
        }
        return this;
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar c = (XMLGregorianCalendar)value;
            if (this.isValidValue(c)) {
                Number n = RestrictedTimelineDatatype.calendarToReal(c);
                for (ContinuousRealInterval i : c.getTimezone() == Integer.MIN_VALUE ? this._nzIntervals : this._wzIntervals) {
                    if (!i.contains(n)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (!this._finite || n <= 0) {
            return true;
        }
        Number sum = 0;
        for (int i = 0; i < this._wzIntervals.size(); ++i) {
            sum = OWLRealUtils.integerSum(sum, 1681);
            if (OWLRealUtils.compare(n, sum) > 0) continue;
            return true;
        }
        return false;
    }

    protected static RestrictedTimelineDatatype create(RestrictedTimelineDatatype other, List<ContinuousRealInterval> wzIntervals, List<ContinuousRealInterval> nzIntervals) {
        return new RestrictedTimelineDatatype(other, wzIntervals, nzIntervals);
    }

    @Override
    public RestrictedDatatype<XMLGregorianCalendar> exclude(Collection<?> values) {
        boolean changes = false;
        ArrayList<ContinuousRealInterval> revisedNz = new ArrayList<ContinuousRealInterval>(this._nzIntervals);
        block0: for (Object o : values) {
            if (!(o instanceof XMLGregorianCalendar)) continue;
            XMLGregorianCalendar c = (XMLGregorianCalendar)o;
            if (c.getTimezone() == Integer.MIN_VALUE) {
                Number n = RestrictedTimelineDatatype.calendarToReal(c);
                Iterator it = revisedNz.iterator();
                while (it.hasNext()) {
                    ContinuousRealInterval greater;
                    ContinuousRealInterval i = (ContinuousRealInterval)it.next();
                    if (!i.contains(n)) continue;
                    changes = true;
                    it.remove();
                    ContinuousRealInterval less = i.less(n);
                    if (less != null) {
                        revisedNz.add(less);
                    }
                    if ((greater = i.greater(n)) == null) continue block0;
                    revisedNz.add(greater);
                    continue block0;
                }
                continue;
            }
            _logger.warning("Exclusion of time zoned constants is not supported");
        }
        if (changes) {
            if (revisedNz.isEmpty() && this._wzIntervals.isEmpty()) {
                return this._empty;
            }
            return RestrictedTimelineDatatype.create(this, this._wzIntervals, revisedNz);
        }
        return this;
    }

    @Override
    public Datatype<? extends XMLGregorianCalendar> getDatatype() {
        return this._datatype;
    }

    @Override
    public RestrictedDatatype<XMLGregorianCalendar> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedTimelineDatatype) {
            List<ContinuousRealInterval> intersectWithNz;
            List<ContinuousRealInterval> intersectWithWz;
            RestrictedTimelineDatatype otherRRD = (RestrictedTimelineDatatype)other;
            ArrayList<ContinuousRealInterval> revisedWz = new ArrayList<ContinuousRealInterval>();
            if (negated) {
                intersectWithWz = new ArrayList<ContinuousRealInterval>(Arrays.asList(ContinuousRealInterval.allReals()));
                for (ContinuousRealInterval i : otherRRD._wzIntervals) {
                    ArrayList<ContinuousRealInterval> tmp = new ArrayList<ContinuousRealInterval>();
                    for (ContinuousRealInterval j : intersectWithWz) {
                        tmp.addAll(j.remove(i));
                    }
                    intersectWithWz = tmp;
                }
            } else {
                intersectWithWz = otherRRD._wzIntervals;
            }
            for (ContinuousRealInterval i : this._wzIntervals) {
                for (ContinuousRealInterval j : intersectWithWz) {
                    ContinuousRealInterval k = i.intersection(j);
                    if (k == null) continue;
                    revisedWz.add(k);
                }
            }
            ArrayList<ContinuousRealInterval> revisedNz = new ArrayList<ContinuousRealInterval>();
            if (negated) {
                intersectWithNz = new ArrayList<ContinuousRealInterval>(Arrays.asList(ContinuousRealInterval.allReals()));
                for (ContinuousRealInterval i : otherRRD._nzIntervals) {
                    ArrayList<ContinuousRealInterval> tmp = new ArrayList<ContinuousRealInterval>();
                    for (ContinuousRealInterval j : intersectWithNz) {
                        tmp.addAll(j.remove(i));
                    }
                    intersectWithNz = tmp;
                }
            } else {
                intersectWithNz = otherRRD._nzIntervals;
            }
            for (ContinuousRealInterval i : this._nzIntervals) {
                for (ContinuousRealInterval j : intersectWithNz) {
                    ContinuousRealInterval k = i.intersection(j);
                    if (k == null) continue;
                    revisedNz.add(k);
                }
            }
            if (revisedWz.equals(this._wzIntervals) && revisedNz.equals(this._nzIntervals)) {
                return this;
            }
            if (revisedWz.isEmpty() && revisedNz.isEmpty()) {
                return this._empty;
            }
            return RestrictedTimelineDatatype.create(this, revisedWz, revisedNz);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return this._enumerable;
    }

    @Override
    public boolean isFinite() {
        return this._finite;
    }

    protected boolean isValidValue(XMLGregorianCalendar c) {
        return this._schemaType.equals(c.getXMLSchemaType());
    }

    @Override
    @Deprecated
    public int size() {
        if (!this._finite) {
            throw new IllegalStateException();
        }
        Number sum = 0;
        for (int i = 0; i < this._wzIntervals.size(); ++i) {
            sum = OWLRealUtils.integerSum(sum, 1681);
            if (OWLRealUtils.compare(Integer.MAX_VALUE, sum) > 0) continue;
            return Integer.MAX_VALUE;
        }
        return sum;
    }

    public String toString() {
        return String.format("{%s,%s,%s}", this._datatype, this._wzIntervals, this._nzIntervals);
    }

    @Override
    public RestrictedDatatype<XMLGregorianCalendar> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedTimelineDatatype) {
            RestrictedTimelineDatatype otherRRD = (RestrictedTimelineDatatype)other;
            ArrayList<ContinuousRealInterval> revisedWz = new ArrayList<ContinuousRealInterval>(this._wzIntervals);
            for (ContinuousRealInterval i : otherRRD._wzIntervals) {
                ArrayList<Object> unionWith = new ArrayList<Object>();
                Iterator jt = revisedWz.iterator();
                while (jt.hasNext()) {
                    ContinuousRealInterval j = (ContinuousRealInterval)jt.next();
                    if (!i.canUnionWith(j)) continue;
                    jt.remove();
                    unionWith.add(j);
                }
                if (unionWith.isEmpty()) {
                    revisedWz.add(i);
                    continue;
                }
                HashSet<ContinuousRealInterval> tmp = new HashSet<ContinuousRealInterval>();
                for (ContinuousRealInterval continuousRealInterval : unionWith) {
                    tmp.addAll(i.union(continuousRealInterval));
                }
                revisedWz.addAll(tmp);
            }
            ArrayList<ContinuousRealInterval> revisedNz = new ArrayList<ContinuousRealInterval>(this._nzIntervals);
            for (ContinuousRealInterval i : otherRRD._nzIntervals) {
                ArrayList<ContinuousRealInterval> unionWith = new ArrayList<ContinuousRealInterval>();
                Iterator jt = revisedNz.iterator();
                while (jt.hasNext()) {
                    ContinuousRealInterval continuousRealInterval = (ContinuousRealInterval)jt.next();
                    if (!i.canUnionWith(continuousRealInterval)) continue;
                    jt.remove();
                    unionWith.add(continuousRealInterval);
                }
                if (unionWith.isEmpty()) {
                    revisedNz.add(i);
                    continue;
                }
                HashSet<ContinuousRealInterval> tmp = new HashSet<ContinuousRealInterval>();
                for (ContinuousRealInterval j : unionWith) {
                    tmp.addAll(i.union(j));
                }
                revisedNz.addAll(tmp);
            }
            return RestrictedTimelineDatatype.create(this, revisedWz, revisedNz);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<XMLGregorianCalendar> valueIterator() {
        throw new UnsupportedOperationException();
    }

    static {
        _logger = Log.getLogger(RestrictedTimelineDatatype.class);
        SEC_PER_DAY = BigInteger.valueOf(86400L);
        SEC_PER_YEAR = BigInteger.valueOf(31536000L);
        try {
            dtFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            String msg = "Failure initializing restricted timeline datatype support.";
            _logger.severe("Failure initializing restricted timeline datatype support.");
            throw new InternalReasonerException("Failure initializing restricted timeline datatype support.", e);
        }
    }
}

