/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import openllet.core.datatypes.IntervalRelations;
import openllet.core.datatypes.OWLRealUtils;
import openllet.shared.tools.Log;

public class ContinuousRealInterval {
    private static final Logger _logger = Log.getLogger(ContinuousRealInterval.class);
    private static ContinuousRealInterval _unconstrained = new ContinuousRealInterval(null, null, true, true);
    private final boolean _inclusiveLower;
    private final boolean _inclusiveUpper;
    private final Number _lower;
    private final boolean _point;
    private final Number _upper;

    public static ContinuousRealInterval allReals() {
        return _unconstrained;
    }

    private static IntervalRelations compare(ContinuousRealInterval a, ContinuousRealInterval b) {
        int ll = ContinuousRealInterval.compareLowerLower(a, b);
        if (ll < 0) {
            int ul = ContinuousRealInterval.compareUpperLower(a, b);
            if (ul < 0) {
                return IntervalRelations.PRECEDES;
            }
            if (ul == 0) {
                if (a.inclusiveUpper()) {
                    if (b.inclusiveLower()) {
                        return IntervalRelations.OVERLAPS;
                    }
                    return IntervalRelations.MEETS;
                }
                if (b.inclusiveLower()) {
                    return IntervalRelations.MEETS;
                }
                return IntervalRelations.PRECEDES;
            }
            int uu = ContinuousRealInterval.compareUpperUpper(a, b);
            if (uu < 0) {
                return IntervalRelations.OVERLAPS;
            }
            if (uu == 0) {
                return IntervalRelations.FINISHED_BY;
            }
            return IntervalRelations.CONTAINS;
        }
        if (ll == 0) {
            int uu = ContinuousRealInterval.compareUpperUpper(a, b);
            if (uu < 0) {
                return IntervalRelations.STARTS;
            }
            if (uu == 0) {
                return IntervalRelations.EQUALS;
            }
            return IntervalRelations.STARTED_BY;
        }
        int lu = -ContinuousRealInterval.compareUpperLower(b, a);
        if (lu < 0) {
            int uu = ContinuousRealInterval.compareUpperUpper(a, b);
            if (uu < 0) {
                return IntervalRelations.DURING;
            }
            if (uu == 0) {
                return IntervalRelations.FINISHES;
            }
            return IntervalRelations.OVERLAPPED_BY;
        }
        if (lu == 0) {
            if (b.inclusiveUpper()) {
                if (a.inclusiveLower()) {
                    return IntervalRelations.OVERLAPPED_BY;
                }
                return IntervalRelations.MET_BY;
            }
            if (a.inclusiveLower()) {
                return IntervalRelations.MET_BY;
            }
            return IntervalRelations.PRECEDED_BY;
        }
        return IntervalRelations.PRECEDED_BY;
    }

    private static int compareLowerLower(ContinuousRealInterval a, ContinuousRealInterval other) {
        int ll;
        if (!a.boundLower()) {
            ll = !other.boundLower() ? 0 : -1;
        } else if (!other.boundLower()) {
            ll = 1;
        } else {
            ll = OWLRealUtils.compare(a.getLower(), other.getLower());
            if (ll == 0) {
                if (a.inclusiveLower()) {
                    if (!other.inclusiveLower()) {
                        ll = -1;
                    }
                } else if (other.inclusiveLower()) {
                    ll = 1;
                }
            }
        }
        return ll;
    }

    private static int compareUpperLower(ContinuousRealInterval a, ContinuousRealInterval b) {
        int ul = !a.boundUpper() ? 1 : (!b.boundLower() ? 1 : OWLRealUtils.compare(a.getUpper(), b.getLower()));
        return ul;
    }

    private static int compareUpperUpper(ContinuousRealInterval a, ContinuousRealInterval b) {
        int uu;
        if (!a.boundUpper()) {
            uu = !b.boundUpper() ? 0 : 1;
        } else if (!b.boundUpper()) {
            uu = -1;
        } else {
            uu = OWLRealUtils.compare(a.getUpper(), b.getUpper());
            if (uu == 0) {
                if (a.inclusiveUpper()) {
                    if (!b.inclusiveUpper()) {
                        uu = 1;
                    }
                } else if (b.inclusiveUpper()) {
                    uu = -1;
                }
            }
        }
        return uu;
    }

    public ContinuousRealInterval(Number point) {
        this._lower = point;
        this._upper = point;
        this._point = true;
        this._inclusiveLower = true;
        this._inclusiveUpper = true;
    }

    public ContinuousRealInterval(Number lower, Number upper, boolean inclusiveLower, boolean inclusiveUpper) {
        if (lower != null && upper != null) {
            int cmp = OWLRealUtils.compare(lower, upper);
            if (cmp > 0) {
                String msg = String.format("Lower bound of interval (%s) should not be greater than _upper bound of interval (%s)", lower, upper);
                _logger.severe(msg);
                throw new IllegalArgumentException(msg);
            }
            if (!(cmp != 0 || inclusiveLower && inclusiveUpper)) {
                String msg = "Point intervals must be inclusive";
                _logger.severe("Point intervals must be inclusive");
                throw new IllegalArgumentException("Point intervals must be inclusive");
            }
        }
        this._lower = lower;
        this._upper = upper;
        this._inclusiveLower = lower == null ? false : inclusiveLower;
        this._inclusiveUpper = upper == null ? false : inclusiveUpper;
        this._point = lower != null && upper != null && lower.equals(upper);
    }

    public boolean boundLower() {
        return this._lower != null;
    }

    public boolean boundUpper() {
        return this._upper != null;
    }

    public boolean canUnionWith(ContinuousRealInterval other) {
        return EnumSet.complementOf(EnumSet.of(IntervalRelations.PRECEDES, IntervalRelations.PRECEDED_BY)).contains((Object)this.compare(other));
    }

    public IntervalRelations compare(ContinuousRealInterval other) {
        return ContinuousRealInterval.compare(this, other);
    }

    public boolean contains(Number n) {
        int comp;
        if (this.boundLower()) {
            comp = OWLRealUtils.compare(this.getLower(), n);
            if (comp > 0) {
                return false;
            }
            if (comp == 0 && !this.inclusiveLower()) {
                return false;
            }
        }
        if (this.boundUpper()) {
            comp = OWLRealUtils.compare(this.getUpper(), n);
            if (comp < 0) {
                return false;
            }
            if (comp == 0 && !this.inclusiveUpper()) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContinuousRealInterval other = (ContinuousRealInterval)obj;
        if (this._inclusiveLower != other._inclusiveLower) {
            return false;
        }
        if (this._inclusiveUpper != other._inclusiveUpper) {
            return false;
        }
        if (this._lower == null) {
            if (other._lower != null) {
                return false;
            }
        } else {
            if (other._lower == null) {
                return false;
            }
            if (OWLRealUtils.compare(this._lower, other._lower) != 0) {
                return false;
            }
        }
        if (this._upper == null) {
            if (other._upper != null) {
                return false;
            }
        } else {
            if (other._upper == null) {
                return false;
            }
            if (OWLRealUtils.compare(this._upper, other._upper) != 0) {
                return false;
            }
        }
        return true;
    }

    public Number getLower() {
        return this._lower;
    }

    public Number getUpper() {
        return this._upper;
    }

    public ContinuousRealInterval greater(Number n) {
        if (this.boundLower() && OWLRealUtils.compare(n, this.getLower()) < 0) {
            return this;
        }
        if (this.boundUpper() && OWLRealUtils.compare(n, this.getUpper()) >= 0) {
            return null;
        }
        return new ContinuousRealInterval(n, this.getUpper(), false, this.inclusiveUpper());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._inclusiveLower ? 1231 : 1237);
        result = 31 * result + (this._inclusiveUpper ? 1231 : 1237);
        result = 31 * result + (this._lower == null ? 0 : this._lower.hashCode());
        result = 31 * result + (this._upper == null ? 0 : this._upper.hashCode());
        return result;
    }

    public boolean inclusiveLower() {
        return this._inclusiveLower;
    }

    public boolean inclusiveUpper() {
        return this._inclusiveUpper;
    }

    public ContinuousRealInterval intersection(ContinuousRealInterval that) {
        boolean inclusiveUpper;
        Number upper;
        boolean inclusiveLower;
        Number lower;
        switch (this.compare(that)) {
            case CONTAINS: 
            case STARTED_BY: {
                lower = that.getLower();
                inclusiveLower = that.inclusiveLower();
                upper = that.getUpper();
                inclusiveUpper = that.inclusiveUpper();
                break;
            }
            case EQUALS: {
                lower = this.getLower();
                inclusiveLower = this.inclusiveLower();
                upper = this.getUpper();
                inclusiveUpper = this.inclusiveUpper();
                break;
            }
            case DURING: 
            case STARTS: {
                lower = this.getLower();
                inclusiveLower = this.inclusiveLower();
                upper = this.getUpper();
                inclusiveUpper = this.inclusiveUpper();
                break;
            }
            case FINISHED_BY: {
                lower = that.getLower();
                inclusiveLower = that.inclusiveLower();
                upper = that.getUpper();
                inclusiveUpper = this.inclusiveUpper() && that.inclusiveUpper();
                break;
            }
            case FINISHES: {
                lower = this.getLower();
                inclusiveLower = this.inclusiveLower();
                upper = this.getUpper();
                inclusiveUpper = this.inclusiveUpper() && that.inclusiveUpper();
                break;
            }
            case MEETS: 
            case MET_BY: {
                return null;
            }
            case OVERLAPPED_BY: {
                lower = this.getLower();
                inclusiveLower = this.inclusiveLower();
                upper = that.getUpper();
                inclusiveUpper = that.inclusiveUpper();
                break;
            }
            case OVERLAPS: {
                lower = that.getLower();
                inclusiveLower = that.inclusiveLower();
                upper = this.getUpper();
                inclusiveUpper = this.inclusiveUpper();
                break;
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return null;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new ContinuousRealInterval(lower, upper, inclusiveLower, inclusiveUpper);
    }

    public boolean isPoint() {
        return this._point;
    }

    public ContinuousRealInterval less(Number n) {
        if (this.boundUpper() && OWLRealUtils.compare(n, this.getUpper()) > 0) {
            return this;
        }
        if (this.boundLower() && OWLRealUtils.compare(n, this.getLower()) <= 0) {
            return null;
        }
        return new ContinuousRealInterval(this.getLower(), n, this.inclusiveLower(), false);
    }

    public List<ContinuousRealInterval> remove(ContinuousRealInterval other) {
        ContinuousRealInterval after;
        ContinuousRealInterval before;
        switch (this.compare(other)) {
            case CONTAINS: {
                before = new ContinuousRealInterval(this.getLower(), other.getLower(), this.inclusiveLower(), !other.inclusiveLower());
                after = new ContinuousRealInterval(other.getUpper(), this.getUpper(), !other.inclusiveUpper(), this.inclusiveUpper());
                break;
            }
            case EQUALS: 
            case DURING: 
            case STARTS: 
            case FINISHES: {
                return Collections.emptyList();
            }
            case MEETS: {
                before = new ContinuousRealInterval(this.getLower(), this.getUpper(), this.inclusiveLower(), false);
                after = null;
                break;
            }
            case MET_BY: {
                before = null;
                after = new ContinuousRealInterval(this.getLower(), this.getUpper(), false, this.inclusiveUpper());
                break;
            }
            case STARTED_BY: 
            case OVERLAPPED_BY: {
                before = null;
                after = new ContinuousRealInterval(other.getUpper(), this.getUpper(), !other.inclusiveUpper(), this.inclusiveUpper());
                break;
            }
            case FINISHED_BY: 
            case OVERLAPS: {
                before = new ContinuousRealInterval(this.getLower(), other.getLower(), this.inclusiveLower(), !other.inclusiveLower());
                after = null;
                break;
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return Collections.singletonList(this);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ArrayList<ContinuousRealInterval> ret = new ArrayList<ContinuousRealInterval>();
        if (before != null) {
            ret.add(before);
        }
        if (after != null) {
            ret.add(after);
        }
        return ret;
    }

    public Number size() {
        if (!this._point) {
            throw new IllegalStateException();
        }
        return 1;
    }

    public String toString() {
        return String.format("%s%s,%s%s", this.inclusiveLower() ? "[" : "(", this.boundLower() ? this.getLower() : "-Inf", this.boundUpper() ? this.getUpper() : "+Inf", this.inclusiveUpper() ? "]" : ")");
    }

    public List<ContinuousRealInterval> union(ContinuousRealInterval other) {
        switch (this.compare(other)) {
            case CONTAINS: 
            case STARTED_BY: 
            case EQUALS: 
            case FINISHED_BY: {
                return Collections.singletonList(this);
            }
            case DURING: 
            case STARTS: 
            case FINISHES: {
                return Collections.singletonList(other);
            }
            case MEETS: {
                return Collections.singletonList(new ContinuousRealInterval(this.getLower(), other.getUpper(), this.inclusiveLower(), other.inclusiveUpper()));
            }
            case MET_BY: {
                return Collections.singletonList(new ContinuousRealInterval(other.getLower(), this.getUpper(), other.inclusiveLower(), this.inclusiveUpper()));
            }
            case OVERLAPPED_BY: {
                return Collections.singletonList(new ContinuousRealInterval(other.getLower(), this.getUpper(), other.inclusiveLower(), this.inclusiveUpper()));
            }
            case OVERLAPS: {
                return Collections.singletonList(new ContinuousRealInterval(this.getLower(), other.getUpper(), this.inclusiveLower(), other.inclusiveUpper()));
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return Arrays.asList(this, other);
            }
        }
        throw new IllegalStateException();
    }

    public Iterator<Number> valueIterator() {
        if (this.isPoint()) {
            return Collections.singletonList(this.getUpper()).iterator();
        }
        throw new IllegalStateException();
    }
}

