/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import javax.xml.bind.DatatypeConverter;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.AbstractDerivedIntegerType;
import openllet.core.utils.ATermUtils;

public class XSDUnsignedInt
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedInt instance = new XSDUnsignedInt();
    private static final long MAX_VALUE = 0xFFFFFFFFL;

    public static XSDUnsignedInt getInstance() {
        return instance;
    }

    private XSDUnsignedInt() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#unsignedInt"), 0, 0xFFFFFFFFL);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            long l = DatatypeConverter.parseLong((String)lexicalForm);
            if (l < 0L) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            if (l > 0xFFFFFFFFL) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return l;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e);
        }
    }
}

