/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.el;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.el.ConceptInfo;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyImpl;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.utils.ATermUtils;

class ELTaxonomyBuilder {
    private Taxonomy<ATermAppl> _taxonomyImpl;

    ELTaxonomyBuilder() {
    }

    public Taxonomy<ATermAppl> build(Map<ATermAppl, ConceptInfo> concepts) {
        this._taxonomyImpl = new TaxonomyImpl<ATermAppl>(null, ATermUtils.TOP, ATermUtils.BOTTOM);
        for (ConceptInfo ci : concepts.get(ATermUtils.TOP).getSuperClasses()) {
            ATermAppl eq = ci.getConcept();
            if (!ATermUtils.isPrimitive(eq)) continue;
            this._taxonomyImpl.addEquivalentNode(eq, this._taxonomyImpl.getTop());
        }
        ConceptInfo BOTTOM = concepts.get(ATermUtils.BOTTOM);
        for (ConceptInfo ci : concepts.values()) {
            ATermAppl c = ci.getConcept();
            if (!ATermUtils.isPrimitive(c)) continue;
            if (ci.getSuperClasses().contains(BOTTOM)) {
                this._taxonomyImpl.addEquivalentNode(c, this._taxonomyImpl.getBottomNode());
                continue;
            }
            this.classify(ci);
        }
        return this._taxonomyImpl;
    }

    private TaxonomyNode<ATermAppl> classify(ConceptInfo ci) {
        ATermAppl c = ci.getConcept();
        TaxonomyNode<ATermAppl> node = this._taxonomyImpl.getNode(c);
        if (node == null) {
            HashSet<ConceptInfo> equivalents = new HashSet<ConceptInfo>();
            HashSet<TaxonomyNode<ATermAppl>> subsumers = new HashSet<TaxonomyNode<ATermAppl>>();
            for (ConceptInfo subsumer : ci.getSuperClasses()) {
                if (!ATermUtils.isPrimitive(subsumer.getConcept()) || ci.equals(subsumer)) continue;
                if (subsumer.hasSuperClass(ci)) {
                    equivalents.add(subsumer);
                    continue;
                }
                TaxonomyNode<ATermAppl> supNode = this.classify(subsumer);
                if (supNode == null) continue;
                subsumers.add(supNode);
            }
            node = this.add(ci, subsumers);
            for (ConceptInfo eqInfo : equivalents) {
                ATermAppl eq = eqInfo.getConcept();
                this._taxonomyImpl.addEquivalentNode(eq, node);
            }
        }
        return node;
    }

    private TaxonomyNode<ATermAppl> add(ConceptInfo ci, Set<TaxonomyNode<ATermAppl>> subsumers) {
        ATermAppl c = ci.getConcept();
        HashSet<TaxonomyNode<ATermAppl>> parents = new HashSet<TaxonomyNode<ATermAppl>>(subsumers);
        HashSet<ATermAppl> supers = new HashSet<ATermAppl>();
        Set<ATermAppl> subs = Collections.singleton(ATermUtils.BOTTOM);
        for (TaxonomyNode<ATermAppl> taxonomyNode : subsumers) {
            parents.removeAll(taxonomyNode.getSupers());
        }
        for (TaxonomyNode<Object> taxonomyNode : parents) {
            supers.add((ATermAppl)taxonomyNode.getName());
            taxonomyNode.removeSub(this._taxonomyImpl.getBottomNode());
        }
        return this._taxonomyImpl.addNode(Collections.singleton(c), supers, subs, false);
    }
}

