/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.el;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.rbox.Role;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.MultiValueMap;

public class RoleChainCache {
    private static final String ANON_ROLE = "anonRole";
    private int _anonRoleCount = 0;
    private final Map<ATermAppl, MultiValueMap<ATermAppl, ATermAppl>> _binaryRoleInclusions = CollectionUtils.makeMap();

    public RoleChainCache(KnowledgeBase kb) {
        for (Role supRole : kb.getRBox().getRoles().values()) {
            if (supRole.isAnon()) continue;
            for (ATermList chain : supRole.getSubRoleChains()) {
                int chainLength = chain.getLength();
                if (chainLength <= 1) continue;
                ATermAppl r1 = (ATermAppl)chain.getFirst();
                chain = chain.getNext();
                ATermAppl r2 = (ATermAppl)chain.getFirst();
                ATermAppl superRole = this.createSuperRoleFor(r1, r2);
                for (int i = 1; i < chainLength - 1; ++i) {
                    this.add(kb, r1, r2, superRole);
                    r1 = superRole;
                    chain = chain.getNext();
                    r2 = (ATermAppl)chain.getFirst();
                    superRole = this.createSuperRoleFor(r1, r2);
                }
                this.add(kb, r1, r2, supRole.getName());
            }
        }
    }

    public static boolean isAnon(ATermAppl r) {
        return r.getName().startsWith(ANON_ROLE);
    }

    public Set<ATermAppl> getAllSuperRoles(ATermAppl r1, ATermAppl r2) {
        MultiValueMap<ATermAppl, ATermAppl> innerMap = this._binaryRoleInclusions.get(r1);
        if (innerMap == null) {
            return Collections.emptySet();
        }
        Set superRoles = (Set)innerMap.get(r2);
        if (superRoles == null) {
            return Collections.emptySet();
        }
        return superRoles;
    }

    private ATermAppl createSuperRoleFor(ATermAppl r1, ATermAppl r2) {
        Set<ATermAppl> superRoles = this.getAllSuperRoles(r1, r2);
        return superRoles.isEmpty() ? ATermUtils.makeTermAppl(ANON_ROLE + this._anonRoleCount++) : superRoles.iterator().next();
    }

    private void add(KnowledgeBase kb, ATermAppl r1, ATermAppl r2, ATermAppl superRole) {
        Role role1 = kb.getRole((ATerm)r1);
        Role role2 = kb.getRole((ATerm)r2);
        if (role1 == null) {
            if (role2 == null) {
                this.add(r1, r2, superRole);
            } else {
                for (Role sub2 : role2.getSubRoles()) {
                    this.add(r1, sub2.getName(), superRole);
                }
            }
        } else if (role2 == null) {
            for (Role sub1 : role1.getSubRoles()) {
                this.add(sub1.getName(), r2, superRole);
            }
        } else {
            for (Role sub1 : role1.getSubRoles()) {
                for (Role sub2 : role2.getSubRoles()) {
                    this.add(sub1.getName(), sub2.getName(), superRole);
                }
            }
        }
    }

    private boolean add(ATermAppl r1, ATermAppl r2, ATermAppl superRole) {
        MultiValueMap<Object, Object> innerMap = this._binaryRoleInclusions.get(r1);
        if (innerMap == null) {
            innerMap = new MultiValueMap();
            this._binaryRoleInclusions.put(r1, innerMap);
        }
        return innerMap.add(r2, superRole);
    }

    public void print() {
        System.out.println("Role Chains:");
        System.out.println(this._binaryRoleInclusions);
    }
}

