/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.el;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.rbox.Role;
import openllet.core.el.ConceptInfo;
import openllet.core.el.ELSyntaxUtils;
import openllet.core.el.ELTaxonomyBuilder;
import openllet.core.el.RoleChainCache;
import openllet.core.el.RoleRestrictionCache;
import openllet.core.taxonomy.CDOptimizedTaxonomyBuilder;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyImpl;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.MultiValueMap;
import openllet.core.utils.TermFactory;
import openllet.core.utils.Timers;
import openllet.shared.tools.Log;

public class SimplifiedELClassifier
extends CDOptimizedTaxonomyBuilder {
    public static final Logger _logger = Log.getLogger(SimplifiedELClassifier.class);
    public final Timers timers = new Timers();
    private static final boolean PREPROCESS_DOMAINS = false;
    private static final boolean MATERIALIZE_SUPER_PROPERTIES = false;
    private final Queue<QueueElement> _primaryQueue = new LinkedList<QueueElement>();
    private final Map<ATermAppl, ConceptInfo> _concepts = CollectionUtils.makeMap();
    private final MultiValueMap<ATermAppl, ConceptInfo> _existentials = new MultiValueMap();
    private final MultiValueMap<ConceptInfo, ConceptInfo> _conjunctions = new MultiValueMap();
    private ConceptInfo TOP;
    private ConceptInfo BOTTOM;
    private boolean _hasComplexRoles;
    private RoleChainCache _roleChains;
    private RoleRestrictionCache _roleRestrictions;

    public SimplifiedELClassifier(KnowledgeBase kb) {
        super(kb);
    }

    @Override
    protected void reset() {
        super.reset();
        this._hasComplexRoles = this._kb.getExpressivity().hasTransitivity() || this._kb.getExpressivity().hasComplexSubRoles();
        this._primaryQueue.clear();
        this._concepts.clear();
        this._existentials.clear();
        this._conjunctions.clear();
        this._roleChains = new RoleChainCache(this._kb);
        this._roleRestrictions = new RoleRestrictionCache(this._kb.getRBox());
    }

    @Override
    public synchronized boolean classify() {
        _logger.fine("Reset");
        this.reset();
        this.timers.execute("createConcepts", t -> this.createConcepts());
        int queueSize = this._primaryQueue.size();
        this._monitor.setProgressTitle("Classifiying");
        this._monitor.setProgressLength(queueSize);
        this._monitor.taskStarted();
        this.timers.execute("processQueue", t -> this.processQueue());
        if (_logger.isLoggable(Level.FINER)) {
            this.print();
        }
        this._monitor.setProgress(queueSize);
        this._taxonomyImpl = this.timers.execute("buildHierarchy", () -> new ELTaxonomyBuilder().build(this._concepts));
        this._monitor.taskFinished();
        return true;
    }

    private void addSuccessor(ConceptInfo pred, ATermAppl p, ConceptInfo succ) {
        ATermAppl propDomain;
        Role pRole;
        if (!pred.addSuccessor(p, succ)) {
            return;
        }
        _logger.finer(() -> "Adding " + pred + " -> " + ATermUtils.toString(p) + " -> " + succ);
        if (succ == this.BOTTOM) {
            this.addToQueue(pred, this.BOTTOM);
            return;
        }
        for (ConceptInfo conceptInfo : succ.getSuperClasses()) {
            this.addSuccessor(pred, p, conceptInfo);
        }
        if (!RoleChainCache.isAnon(p) && null != (pRole = this._kb.getRole((ATerm)p))) {
            Set<Role> set = pRole.getSuperRoles();
            for (Role superRole : set) {
                if (!this._existentials.contains(superRole.getName(), succ)) continue;
                ATermAppl some = ATermUtils.makeSomeValues((ATerm)superRole.getName(), (ATerm)succ.getConcept());
                this.addToQueue(pred, this._concepts.get(some));
            }
        }
        if ((propDomain = this._roleRestrictions.getDomain(p)) != null) {
            this.addToQueue(pred, this._concepts.get(propDomain));
        }
        if (this._hasComplexRoles) {
            for (Map.Entry entry : CollectionUtils.makeList(pred.getPredecessors().entrySet())) {
                ATermAppl predProp = (ATermAppl)entry.getKey();
                for (ATermAppl supProp : this._roleChains.getAllSuperRoles(predProp, p)) {
                    for (ConceptInfo predOfPred : CollectionUtils.makeList((Collection)entry.getValue())) {
                        this.addSuccessor(predOfPred, supProp, succ);
                    }
                }
            }
            for (Map.Entry entry : CollectionUtils.makeList(succ.getSuccessors().entrySet())) {
                ATermAppl succProp = (ATermAppl)entry.getKey();
                for (ATermAppl supProp : this._roleChains.getAllSuperRoles(p, succProp)) {
                    for (ConceptInfo succOfSucc : CollectionUtils.makeList((Collection)entry.getValue())) {
                        this.addSuccessor(pred, supProp, succOfSucc);
                    }
                }
            }
        }
    }

    private void addToQueue(ConceptInfo sub, ConceptInfo sup) {
        if (sub.addSuperClass(sup)) {
            this._primaryQueue.add(new QueueElement(sub, sup));
            _logger.finer(() -> "Queue " + sub + " " + sup);
        }
    }

    private void addSuperClass(ConceptInfo sub, ConceptInfo sup) {
        _logger.finer(() -> "Adding " + sub + " < " + sup);
        if (sup == this.BOTTOM) {
            Iterator<ConceptInfo> preds = sub.getPredecessors().flattenedValues();
            while (preds.hasNext()) {
                this.addToQueue(preds.next(), sup);
            }
            return;
        }
        for (ConceptInfo supOfSup : sup.getSuperClasses()) {
            if (supOfSup.equals(sup)) continue;
            this.addToQueue(sub, supOfSup);
        }
        ATermAppl c = sup.getConcept();
        if (ATermUtils.isAnd(c)) {
            ATermList list = (ATermList)c.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                this.addToQueue(sub, this._concepts.get(conj));
                list = list.getNext();
            }
        } else if (ATermUtils.isSomeValues(c)) {
            ATermAppl p = (ATermAppl)c.getArgument(0);
            ATermAppl qualification = (ATermAppl)c.getArgument(1);
            this.addSuccessor(sub, p, this._concepts.get(qualification));
        } else assert (ATermUtils.isPrimitive(c));
        Set referredConjunctions = (Set)this._conjunctions.get(sup);
        if (referredConjunctions != null) {
            for (ConceptInfo conceptInfo : referredConjunctions) {
                ATermAppl conj;
                ATermList list = (ATermList)conceptInfo.getConcept().getArgument(0);
                while (!list.isEmpty() && sub.hasSuperClass(this._concepts.get(conj = (ATermAppl)list.getFirst()))) {
                    list = list.getNext();
                }
                if (!list.isEmpty()) continue;
                this.addToQueue(sub, conceptInfo);
            }
        }
        for (Map.Entry entry : sub.getPredecessors().entrySet()) {
            ATermAppl prop = (ATermAppl)entry.getKey();
            Role role = this._kb.getRole((ATerm)prop);
            if (role == null) continue;
            Set<Role> superRoles = role.getSuperRoles();
            for (Role superRole : superRoles) {
                if (!this._existentials.contains(superRole.getName(), sup)) continue;
                ATermAppl some = ATermUtils.makeSomeValues((ATerm)superRole.getName(), (ATerm)c);
                for (ConceptInfo pred : (Set)entry.getValue()) {
                    this.addToQueue(pred, this._concepts.get(some));
                }
            }
        }
    }

    private ConceptInfo createConcept(ATermAppl cParam) {
        ATermAppl c = cParam;
        ConceptInfo concept = this._concepts.get(c);
        if (concept == null) {
            concept = new ConceptInfo(c, this._hasComplexRoles, false);
            if (ATermUtils.isAnd(c)) {
                ATermList list = (ATermList)c.getArgument(0);
                while (!list.isEmpty()) {
                    ATermAppl conj = (ATermAppl)list.getFirst();
                    ConceptInfo conjConcept = this.createConcept(conj);
                    this.addToQueue(concept, conjConcept);
                    this._conjunctions.add(conjConcept, concept);
                    list = list.getNext();
                }
            } else if (ATermUtils.isSomeValues(c)) {
                ATermAppl newQ;
                ATermAppl p = (ATermAppl)c.getArgument(0);
                ATermAppl q = (ATermAppl)c.getArgument(1);
                if (ATermUtils.isInv(p)) {
                    throw new UnsupportedOperationException("Anonmyous inverse found in restriction: " + ATermUtils.toString(c));
                }
                ATermAppl range = this._roleRestrictions.getRange(p);
                if (range != null && !(newQ = ATermUtils.makeSimplifiedAnd(Arrays.asList(range, q))).equals(q)) {
                    ATermAppl newC = ATermUtils.makeSomeValues((ATerm)p, (ATerm)newQ);
                    concept = this.createConcept(newC);
                    this._concepts.put(c, concept);
                    c = newC;
                }
                ConceptInfo succ = this.createConcept(q);
                this._existentials.add(p, succ);
                this.addToQueue(concept, concept);
            }
            this._concepts.put(c, concept);
            concept.addSuperClass(concept);
            if (this.TOP != null) {
                this.addToQueue(concept, this.TOP);
            }
        }
        return concept;
    }

    private void createConceptsFromAxiom(ATermAppl sub, ATermAppl sup) {
        this.addToQueue(this.createConcept(sub), this.createConcept(sup));
    }

    private void createDisjointAxiom(ATermAppl c1, ATermAppl c2) {
        this.createConcept(c1);
        this.createConcept(c2);
        ATermAppl and = ATermUtils.makeSimplifiedAnd(Arrays.asList(c1, c2));
        this.createConceptsFromAxiom(and, ATermUtils.BOTTOM);
    }

    private void processAxiom(ATermAppl axiom) {
        AFun fun = axiom.getAFun();
        if (fun.equals(ATermUtils.DISJOINTSFUN)) {
            ATermList concepts = (ATermList)axiom.getArgument(0);
            int n = concepts.getLength();
            ATermAppl[] simplified = new ATermAppl[n];
            int i = 0;
            while (!concepts.isEmpty()) {
                simplified[i] = ELSyntaxUtils.simplify((ATermAppl)concepts.getFirst());
                concepts = concepts.getNext();
                ++i;
            }
            for (i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    this.createDisjointAxiom(simplified[i], simplified[j]);
                }
            }
        } else {
            ATermAppl sub = (ATermAppl)axiom.getArgument(0);
            ATermAppl sup = (ATermAppl)axiom.getArgument(1);
            sub = ELSyntaxUtils.simplify(sub);
            sup = ELSyntaxUtils.simplify(sup);
            if (fun.equals(ATermUtils.SUBFUN)) {
                this.createConceptsFromAxiom(sub, sup);
            } else if (fun.equals(ATermUtils.EQCLASSFUN)) {
                this.createConceptsFromAxiom(sub, sup);
                this.createConceptsFromAxiom(sup, sub);
            } else if (fun.equals(ATermUtils.DISJOINTFUN)) {
                this.createDisjointAxiom(sub, sup);
            } else {
                throw new IllegalArgumentException("Axiom " + axiom + " is not EL.");
            }
        }
    }

    private void processAxioms() {
        Collection<ATermAppl> assertedAxioms = this._kb.getTBox().getAssertedAxioms();
        for (ATermAppl assertedAxiom : assertedAxioms) {
            this.processAxiom(assertedAxiom);
        }
        for (Role role : this._kb.getRBox().getRoles().values()) {
            ATermAppl range;
            if (!role.isReflexive() || (range = this._roleRestrictions.getRange(role.getName())) == null) continue;
            this.createConceptsFromAxiom(ATermUtils.TOP, range);
        }
    }

    private void createConcepts() {
        this.TOP = this.createConcept(ATermUtils.TOP);
        this.BOTTOM = this.createConcept(ATermUtils.BOTTOM);
        for (ATermAppl c : this._kb.getClasses()) {
            this.createConcept(c);
        }
        this.processAxioms();
        _logger.fine("Process domain and ranges");
        for (ATermAppl c : this._roleRestrictions.getRanges().values()) {
            this.createConcept(c);
        }
        for (ATermAppl c : this._roleRestrictions.getDomains().values()) {
            this.createConcept(c);
        }
    }

    public void print() {
        for (ATermAppl c : this._concepts.keySet()) {
            _logger.finer(c + " " + this._concepts.get(c).getSuperClasses());
        }
        _logger.finer("");
        this._roleChains.print();
    }

    private void processQueue() {
        int startingSize = this._primaryQueue.size();
        while (!this._primaryQueue.isEmpty()) {
            int processed = startingSize - this._primaryQueue.size();
            if (this._monitor.getProgress() < processed) {
                this._monitor.setProgress(processed);
            }
            QueueElement qe = this._primaryQueue.remove();
            this.addSuperClass(qe._sub, qe._sup);
        }
    }

    @Override
    public Map<ATermAppl, Set<ATermAppl>> getToldDisjoints() {
        return Collections.emptyMap();
    }

    @Override
    public Taxonomy<ATermAppl> getToldTaxonomy() {
        return new TaxonomyImpl<ATermAppl>(this._kb.getTBox().getClasses(), TermFactory.TOP, TermFactory.BOTTOM);
    }

    private static class QueueElement {
        public final ConceptInfo _sub;
        public final ConceptInfo _sup;

        public QueueElement(ConceptInfo sub, ConceptInfo sup) {
            this._sub = sub;
            this._sup = sup;
        }
    }
}

