/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.expressivity;

import java.util.HashSet;
import java.util.Set;
import openllet.aterm.ATermAppl;

public class Expressivity {
    private boolean _hasNegation = false;
    private boolean _hasAllValues = false;
    private boolean _hasDisjointClasses = false;
    private boolean _hasInverse = false;
    private boolean _hasFunctionality = false;
    private boolean _hasCardinality = false;
    private boolean _hasCardinalityQ = false;
    private boolean _hasFunctionalityD = false;
    private boolean _hasCardinalityD = false;
    private boolean _hasTransitivity = false;
    private boolean _hasRoleHierarchy = false;
    private boolean _hasReflexivity = false;
    private boolean _hasIrreflexivity = false;
    private boolean _hasDisjointRoles = false;
    private boolean _hasAsymmetry = false;
    private boolean _hasComplexSubRoles = false;
    private boolean _hasDatatype = false;
    private boolean _hasUserDefinedDatatype = false;
    private boolean _hasKeys = false;
    private boolean _hasDomain = false;
    private boolean _hasRange = false;
    private boolean _hasIndividual = false;
    private Set<ATermAppl> _nominals = new HashSet<ATermAppl>();
    private Set<ATermAppl> _anonInverses = new HashSet<ATermAppl>();

    public Expressivity() {
    }

    public Expressivity(Expressivity other) {
        this._hasNegation = other._hasNegation;
        this._hasAllValues = other._hasAllValues;
        this._hasDisjointClasses = other._hasDisjointClasses;
        this._hasInverse = other._hasInverse;
        this._hasFunctionality = other._hasFunctionality;
        this._hasCardinality = other._hasCardinality;
        this._hasCardinalityQ = other._hasCardinalityQ;
        this._hasFunctionalityD = other._hasFunctionalityD;
        this._hasCardinalityD = other._hasCardinalityD;
        this._hasTransitivity = other._hasTransitivity;
        this._hasRoleHierarchy = other._hasRoleHierarchy;
        this._hasReflexivity = other._hasReflexivity;
        this._hasIrreflexivity = other._hasIrreflexivity;
        this._hasDisjointRoles = other._hasDisjointRoles;
        this._hasAsymmetry = other._hasAsymmetry;
        this._hasComplexSubRoles = other._hasComplexSubRoles;
        this._hasDatatype = other._hasDatatype;
        this._hasKeys = other._hasKeys;
        this._hasDomain = other._hasDomain;
        this._hasRange = other._hasRange;
        this._hasIndividual = other._hasIndividual;
        this._nominals = new HashSet<ATermAppl>(other._nominals);
        this._anonInverses = new HashSet<ATermAppl>(other._anonInverses);
    }

    public boolean isEL() {
        return !this._hasNegation && !this._hasAllValues && !this._hasInverse && !this._hasFunctionality && !this._hasCardinality && !this._hasCardinalityQ && !this._hasFunctionalityD && !this._hasCardinalityD && !this._hasIrreflexivity && !this._hasDisjointRoles && !this._hasAsymmetry && !this._hasDatatype && !this._hasKeys && !this._hasIndividual && this._nominals.isEmpty();
    }

    public String toString() {
        Object dl = "";
        if (this.isEL()) {
            dl = "EL";
            if (this._hasComplexSubRoles || this._hasReflexivity || this._hasDomain || this._hasRange || this._hasDisjointClasses) {
                dl = (String)dl + "+";
            } else if (this._hasRoleHierarchy) {
                dl = (String)dl + "H";
            }
        } else {
            dl = "AL";
            if (this._hasNegation) {
                dl = "ALC";
            }
            if (this._hasTransitivity) {
                dl = (String)dl + "R+";
            }
            if ("ALCR+".equals(dl)) {
                dl = "S";
            }
            if (this._hasComplexSubRoles) {
                dl = "SR";
            } else if (this._hasRoleHierarchy) {
                dl = (String)dl + "H";
            }
            if (this.hasNominal()) {
                dl = (String)dl + "O";
            }
            if (this._hasInverse) {
                dl = (String)dl + "I";
            }
            if (this._hasCardinalityQ) {
                dl = (String)dl + "Q";
            } else if (this._hasCardinality) {
                dl = (String)dl + "N";
            } else if (this._hasFunctionality) {
                dl = (String)dl + "F";
            }
            if (this._hasDatatype) {
                dl = this._hasKeys ? (String)dl + "(Dk)" : (String)dl + "(D)";
            }
        }
        return dl;
    }

    public void setHasNegation(boolean v) {
        this._hasNegation = v;
    }

    public void setHasAllValues(boolean v) {
        this._hasAllValues = v;
    }

    public void setHasDisjointClasses(boolean v) {
        this._hasDisjointClasses = v;
    }

    public boolean hasInverse() {
        return this._hasInverse;
    }

    public void setHasInverse(boolean v) {
        this._hasInverse = v;
    }

    public boolean hasFunctionality() {
        return this._hasFunctionality;
    }

    public void setHasFunctionality(boolean v) {
        this._hasFunctionality = v;
    }

    public boolean hasCardinality() {
        return this._hasCardinality;
    }

    public void setHasCardinality(boolean v) {
        this._hasCardinality = v;
    }

    public boolean hasCardinalityQ() {
        return this._hasCardinalityQ;
    }

    public void setHasCardinalityQ(boolean v) {
        this._hasCardinalityQ = v;
    }

    public boolean hasFunctionalityD() {
        return this._hasFunctionalityD;
    }

    public void setHasFunctionalityD(boolean v) {
        this._hasFunctionalityD = v;
    }

    public boolean hasCardinalityD() {
        return this._hasCardinalityD;
    }

    public void setHasCardinalityD(boolean v) {
        this._hasCardinalityD = v;
    }

    public boolean hasTransitivity() {
        return this._hasTransitivity;
    }

    public void setHasTransitivity(boolean v) {
        this._hasTransitivity = v;
    }

    public void setHasRoleHierarchy(boolean v) {
        this._hasRoleHierarchy = v;
    }

    public void setHasReflexivity(boolean v) {
        this._hasReflexivity = v;
    }

    public void setHasIrreflexivity(boolean v) {
        this._hasIrreflexivity = v;
    }

    public boolean hasDisjointRoles() {
        return this._hasDisjointRoles;
    }

    public void setHasDisjointRoles(boolean v) {
        this._hasDisjointRoles = v;
    }

    public void setHasAsymmetry(boolean v) {
        this._hasAsymmetry = v;
    }

    public boolean hasComplexSubRoles() {
        return this._hasComplexSubRoles;
    }

    public void setHasComplexSubRoles(boolean v) {
        this._hasComplexSubRoles = v;
    }

    public void setHasDatatype(boolean v) {
        this._hasDatatype = v;
    }

    public boolean hasUserDefinedDatatype() {
        return this._hasUserDefinedDatatype;
    }

    public void setHasUserDefinedDatatype(boolean v) {
        if (v) {
            this.setHasDatatype(true);
        }
        this._hasUserDefinedDatatype = v;
    }

    public boolean hasKeys() {
        return this._hasKeys;
    }

    public void setHasKeys(boolean v) {
        this._hasKeys = v;
    }

    public void setHasDomain(boolean v) {
        this._hasDomain = v;
    }

    public void setHasRange(boolean v) {
        this._hasRange = v;
    }

    public void setHasIndividual(boolean v) {
        this._hasIndividual = v;
    }

    public boolean hasNominal() {
        return !this._nominals.isEmpty();
    }

    public Set<ATermAppl> getNominals() {
        return this._nominals;
    }

    public void addNominal(ATermAppl n) {
        this._nominals.add(n);
    }

    public Set<ATermAppl> getAnonInverses() {
        return this._anonInverses;
    }

    public void addAnonInverse(ATermAppl p) {
        this._anonInverses.add(p);
    }
}

