/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.knowledge;

import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.boxes.tbox.TBox;
import openllet.core.output.ATermBaseVisitor;
import openllet.core.utils.ATermUtils;

public abstract class FullyDefinedClassVisitor
extends ATermBaseVisitor {
    private boolean _fullyDefined = true;

    public abstract boolean isProperty(ATerm var1);

    public abstract boolean isDatatype(ATermAppl var1);

    public abstract TBox getTBox();

    public abstract Set<ATermAppl> getIndividuals();

    public boolean isFullyDefined(ATermAppl term) {
        this._fullyDefined = true;
        this.visit(term);
        return this._fullyDefined;
    }

    private void visitQCR(ATermAppl term) {
        ATermAppl q;
        this.visitRestr(term);
        if (this._fullyDefined && !this.isDatatype(q = (ATermAppl)term.getArgument(2))) {
            this.visit(q);
        }
    }

    private void visitQR(ATermAppl term) {
        ATermAppl q;
        this.visitRestr(term);
        if (this._fullyDefined && !this.isDatatype(q = (ATermAppl)term.getArgument(1))) {
            this.visit(q);
        }
    }

    private void visitRestr(ATermAppl term) {
        this._fullyDefined = this._fullyDefined && this.isProperty(term.getArgument(0));
    }

    @Override
    public void visit(ATermAppl term) {
        if (term.equals(ATermUtils.TOP) || term.equals(ATermUtils.BOTTOM) || term.equals(ATermUtils.TOP_LIT) || term.equals(ATermUtils.BOTTOM_LIT)) {
            return;
        }
        super.visit(term);
    }

    @Override
    public void visitAll(ATermAppl term) {
        this.visitQR(term);
    }

    @Override
    public void visitAnd(ATermAppl term) {
        if (this._fullyDefined) {
            this.visitList((ATermList)term.getArgument(0));
        }
    }

    @Override
    public void visitCard(ATermAppl term) {
        this.visitQCR(term);
    }

    @Override
    public void visitHasValue(ATermAppl term) {
        this.visitQR(term);
    }

    @Override
    public void visitLiteral(ATermAppl term) {
    }

    @Override
    public void visitMax(ATermAppl term) {
        this.visitQCR(term);
    }

    @Override
    public void visitMin(ATermAppl term) {
        this.visitQCR(term);
    }

    @Override
    public void visitNot(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
    }

    @Override
    public void visitOneOf(ATermAppl term) {
        if (this._fullyDefined) {
            this.visitList((ATermList)term.getArgument(0));
        }
    }

    @Override
    public void visitOr(ATermAppl term) {
        if (this._fullyDefined) {
            this.visitList((ATermList)term.getArgument(0));
        }
    }

    @Override
    public void visitSelf(ATermAppl term) {
        this.visitRestr(term);
    }

    @Override
    public void visitSome(ATermAppl term) {
        this.visitQR(term);
    }

    @Override
    public void visitTerm(ATermAppl term) {
        boolean bl = this._fullyDefined = this._fullyDefined && this.getTBox().getClasses().contains(term);
        if (!this._fullyDefined) {
            return;
        }
    }

    @Override
    public void visitValue(ATermAppl term) {
        ATermAppl nominal = (ATermAppl)term.getArgument(0);
        if (ATermUtils.isLiteral(nominal)) {
            this._fullyDefined = false;
        } else if (!ATermUtils.isLiteral(nominal)) {
            this._fullyDefined = this._fullyDefined && this.getIndividuals().contains(nominal);
        }
    }

    @Override
    public void visitInverse(ATermAppl term) {
        ATermAppl p = (ATermAppl)term.getArgument(0);
        if (ATermUtils.isPrimitive(p)) {
            this._fullyDefined = this._fullyDefined && this.isProperty((ATerm)p);
        } else {
            this.visitInverse(p);
        }
    }

    @Override
    public void visitRestrictedDatatype(ATermAppl dt) {
        this._fullyDefined = this._fullyDefined && this.isDatatype((ATermAppl)dt.getArgument(0));
    }
}

