/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.output;

import java.util.HashMap;
import java.util.Map;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermInt;
import openllet.aterm.ATermList;
import openllet.core.datatypes.Facet;
import openllet.core.datatypes.types.floating.XSDFloat;
import openllet.core.datatypes.types.real.XSDDecimal;
import openllet.core.datatypes.types.real.XSDInteger;
import openllet.core.output.ATermBaseRenderer;
import openllet.core.utils.ATermUtils;

public class ATermManchesterSyntaxRenderer
extends ATermBaseRenderer {
    public static final Map<ATermAppl, String> FACETS = new HashMap<ATermAppl, String>();

    @Override
    public void visitAll(ATermAppl term) {
        this._out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this._out.print(" only ");
        this.visit((ATermAppl)term.getArgument(1));
        this._out.print(")");
    }

    @Override
    public void visitAnd(ATermAppl term) {
        this._out.print("(");
        this.visitList((ATermList)term.getArgument(0), "and");
        this._out.print(")");
    }

    @Override
    public void visitCard(ATermAppl term) {
        this._out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this._out.print(" exactly " + ((ATermInt)term.getArgument(1)).getInt());
        this._out.print(")");
    }

    @Override
    public void visitHasValue(ATermAppl term) {
        this._out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this._out.print(" value ");
        ATermAppl value = (ATermAppl)((ATermAppl)term.getArgument(1)).getArgument(0);
        if (value.getArity() == 0) {
            this.visitTerm(value);
        } else {
            this.visitLiteral(value);
        }
        this._out.print(")");
    }

    @Override
    public void visitInverse(ATermAppl p) {
        this._out.print("inverse ");
        this.visit((ATermAppl)p.getArgument(0));
    }

    @Override
    public void visitLiteral(ATermAppl term) {
        ATermAppl lexicalValue = (ATermAppl)term.getArgument(0);
        ATermAppl lang = (ATermAppl)term.getArgument(1);
        ATermAppl datatypeURI = (ATermAppl)term.getArgument(2);
        if (datatypeURI.equals(XSDInteger.getInstance().getName()) || datatypeURI.equals(XSDDecimal.getInstance().getName())) {
            this._out.print(lexicalValue.getName());
        } else if (datatypeURI.equals(XSDFloat.getInstance().getName())) {
            this._out.print(lexicalValue.getName());
            this._out.print("f");
        } else if (!datatypeURI.equals(ATermUtils.PLAIN_LITERAL_DATATYPE)) {
            this._out.print(lexicalValue.getName());
            this._out.print("^^");
            this._out.print(datatypeURI.getName());
        } else {
            this._out.print("\"" + lexicalValue.getName() + "\"");
            if (!lang.equals(ATermUtils.EMPTY)) {
                this._out.print("@" + lang);
            }
        }
    }

    @Override
    public void visitMax(ATermAppl term) {
        this._out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this._out.print(" max " + ((ATermInt)term.getArgument(1)).getInt() + " ");
        this.visit((ATermAppl)term.getArgument(2));
        this._out.print(")");
    }

    @Override
    public void visitMin(ATermAppl term) {
        this._out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this._out.print(" min " + ((ATermInt)term.getArgument(1)).getInt() + " ");
        this.visit((ATermAppl)term.getArgument(2));
        this._out.print(")");
    }

    @Override
    public void visitNot(ATermAppl term) {
        this._out.print("not ");
        this.visit((ATermAppl)term.getArgument(0));
    }

    @Override
    public void visitOneOf(ATermAppl term) {
        this._out.print("{");
        ATermList list = (ATermList)term.getArgument(0);
        while (!list.isEmpty()) {
            ATermAppl value = (ATermAppl)list.getFirst();
            this.visit((ATermAppl)value.getArgument(0));
            if ((list = list.getNext()).isEmpty()) continue;
            this._out.print(" ");
        }
        this._out.print("}");
    }

    @Override
    public void visitOr(ATermAppl term) {
        this._out.print("(");
        this.visitList((ATermList)term.getArgument(0), "or");
        this._out.print(")");
    }

    @Override
    public void visitSelf(ATermAppl term) {
        this._out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this._out.print(" Self)");
    }

    @Override
    public void visitSome(ATermAppl term) {
        this._out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this._out.print(" some ");
        this.visit((ATermAppl)term.getArgument(1));
        this._out.print(")");
    }

    @Override
    public void visitValue(ATermAppl term) {
        this._out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this._out.print(")");
    }

    public void visitList(ATermList list, String op) {
        int size = list.getLength();
        for (ATerm term : list) {
            this.visit((ATermAppl)term);
            if (--size == 0) continue;
            this._out.print(" " + op + " ");
        }
    }

    @Override
    public void visitRestrictedDatatype(ATermAppl dt) {
        this._out.print("");
        this.visit((ATermAppl)dt.getArgument(0));
        this._out.print("[");
        ATermList list = (ATermList)dt.getArgument(1);
        while (!list.isEmpty()) {
            ATermAppl facet = (ATermAppl)list.getFirst();
            this._out.print(FACETS.get(facet.getArgument(0)));
            this._out.print(" ");
            this.visit((ATermAppl)facet.getArgument(1));
            if ((list = list.getNext()).isEmpty()) continue;
            this._out.print(", ");
        }
        this._out.print("]");
    }

    static {
        FACETS.put(Facet.XSD.LENGTH.getName(), "length");
        FACETS.put(Facet.XSD.MIN_LENGTH.getName(), "minLength");
        FACETS.put(Facet.XSD.MAX_LENGTH.getName(), "maxLength");
        FACETS.put(Facet.XSD.PATTERN.getName(), "pattern");
        FACETS.put(Facet.XSD.MIN_INCLUSIVE.getName(), ">=");
        FACETS.put(Facet.XSD.MIN_EXCLUSIVE.getName(), ">");
        FACETS.put(Facet.XSD.MAX_INCLUSIVE.getName(), "<=");
        FACETS.put(Facet.XSD.MAX_EXCLUSIVE.getName(), "<");
    }
}

