/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import openllet.aterm.ATermAppl;
import openllet.atom.OpenError;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.IndividualIterator;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.expressivity.Expressivity;
import openllet.core.rules.BindingGeneratorStrategy;
import openllet.core.rules.BindingGeneratorStrategyImpl;
import openllet.core.rules.PartialBinding;
import openllet.core.rules.RuleAtomAsserter;
import openllet.core.rules.RulesToATermTranslator;
import openllet.core.rules.TrivialSatisfactionHelpers;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.model.Rule;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.rete.AlphaNetwork;
import openllet.core.rules.rete.Compiler;
import openllet.core.rules.rete.Interpreter;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.branch.RuleBranch;
import openllet.core.tableau.completion.SROIQStrategy;
import openllet.core.tableau.completion.rule.TableauRule;
import openllet.core.utils.Pair;
import openllet.core.utils.Timer;

public class ContinuousRulesStrategy
extends SROIQStrategy {
    private final BindingGeneratorStrategy _bindingStrategy;
    private Interpreter _interpreter;
    private boolean _merging;
    private final Set<PartialBinding> _unsafeRules;
    private final Queue<PartialBinding> _partialBindings;
    private final Map<Pair<Rule, VariableBinding>, Integer> _rulesApplied;
    private final RulesToATermTranslator _atermTranslator;
    private final RuleAtomAsserter _ruleAtomAsserter;
    private final TrivialSatisfactionHelpers _atomTester;

    public ContinuousRulesStrategy(ABox abox) {
        super(abox);
        this._bindingStrategy = new BindingGeneratorStrategyImpl(abox);
        this._partialBindings = new ConcurrentLinkedQueue<PartialBinding>();
        this._unsafeRules = new HashSet<PartialBinding>();
        this._rulesApplied = new HashMap<Pair<Rule, VariableBinding>, Integer>();
        this._atermTranslator = new RulesToATermTranslator();
        this._ruleAtomAsserter = new RuleAtomAsserter();
        this._atomTester = new TrivialSatisfactionHelpers(abox);
    }

    public void addUnsafeRule(Rule rule, Set<ATermAppl> explain) {
        this._unsafeRules.add(new PartialBinding(rule, new VariableBinding(this._abox), new DependencySet(explain)));
    }

    public void addPartialBinding(PartialBinding binding) {
        this._partialBindings.add(binding);
    }

    @Override
    public Edge addEdge(Individual subj, Role pred, Node obj, DependencySet ds) {
        Edge edge = super.addEdge(subj, pred, obj, ds);
        if (edge != null && !this._abox.isClosed() && subj.isRootNominal() && obj.isRootNominal() && this._interpreter != null) {
            this._interpreter._alphaNet.activateEdge(edge);
        }
        return edge;
    }

    @Override
    public void addType(Node node, ATermAppl c, DependencySet ds) {
        super.addType(node, c, ds);
        if (!this._merging && !this._abox.isClosed() && node.isRootNominal() && this._interpreter != null && node.isIndividual()) {
            Individual ind = (Individual)node;
            this._interpreter._alphaNet.activateType(ind, c, ds);
        }
    }

    @Override
    protected boolean mergeIndividuals(Individual y, Individual x, DependencySet ds) {
        if (super.mergeIndividuals(y, x, ds)) {
            if (this._interpreter != null) {
                this._interpreter._alphaNet.activateDifferents(y);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setDifferent(Node y, Node z, DependencySet ds) {
        if (super.setDifferent(y, z, ds)) {
            if (this._interpreter != null && !this._merging && !this._abox.isClosed() && y.isRootNominal() && y.isIndividual() && z.isRootNominal() && z.isIndividual()) {
                this._interpreter._alphaNet.activateDifferent((Individual)y, (Individual)z, ds);
            }
            return true;
        }
        return false;
    }

    public Collection<PartialBinding> applyRete() {
        Optional<Timer> timer;
        if (OpenlletOptions.ALWAYS_REBUILD_RETE) {
            timer = this._timers.startTimer("rule-rebuildRete");
            this._partialBindings.clear();
            this._partialBindings.addAll(this._unsafeRules);
            this._interpreter.reset();
            timer.ifPresent(t -> t.stop());
        }
        timer = this._timers.startTimer("rule-reteRun");
        this._interpreter.run();
        timer.ifPresent(t -> t.stop());
        return this._interpreter.getBindings();
    }

    public void applyRuleBindings() {
        int total = 0;
        for (PartialBinding ruleBinding : this._partialBindings) {
            Rule rule = ruleBinding.getRule();
            VariableBinding initial = ruleBinding.getBinding();
            for (VariableBinding binding : this._bindingStrategy.createGenerator(rule, initial)) {
                int branch;
                Pair<Rule, VariableBinding> ruleKey = new Pair<Rule, VariableBinding>(rule, binding);
                if (this._rulesApplied.containsKey(ruleKey)) continue;
                ++total;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Rule: " + rule + "\nBinding: " + binding + "\ntotal:" + total);
                }
                if ((branch = this.createDisjunctionsFromBinding(binding, rule, ruleBinding.getDependencySet())) >= 0) {
                    this._rulesApplied.put(ruleKey, branch);
                }
                if (!this._abox.isClosed()) continue;
                return;
            }
        }
    }

    @Override
    public void complete(Expressivity expr) {
        this.initialize(this._abox.getKB().getExpressivity());
        this._merging = false;
        Optional<Timer> timer = this._timers.startTimer("rule-buildReteRules");
        Compiler compiler = new Compiler(this);
        for (Map.Entry<Rule, Rule> e : this._abox.getKB().getNormalizedRules().entrySet()) {
            Rule rule = e.getKey();
            Rule normalizedRule = e.getValue();
            if (normalizedRule == null) continue;
            Set<ATermAppl> explain = this._abox.doExplanation() ? rule.getExplanation(this._atermTranslator) : Collections.emptySet();
            try {
                compiler.compile(normalizedRule, explain);
            }
            catch (UnsupportedOperationException uoe) {
                throw new OpenError("Unsupported rule " + normalizedRule, (Throwable)uoe);
            }
        }
        timer.ifPresent(t -> t.stop());
        AlphaNetwork alphaNet = compiler.getAlphaNet();
        if (this._abox.doExplanation()) {
            alphaNet.setDoExplanation(true);
        }
        this._interpreter = new Interpreter(alphaNet);
        this._partialBindings.clear();
        this._partialBindings.addAll(this._unsafeRules);
        this._rulesApplied.clear();
        this.applyRete();
        while (!this._abox.isComplete()) {
            while (this._abox.isChanged() && !this._abox.isClosed()) {
                TableauRule tableauRule;
                boolean closed;
                this._completionTimer.ifPresent(t -> t.check());
                this._abox.setChanged(false);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Branch: " + this._abox.getBranchIndex() + ", Depth: " + this._abox.getStats()._treeDepth + ", Size: " + this._abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb");
                    this._abox.validate();
                    this._abox.printTree();
                    this._interpreter._alphaNet.print();
                }
                IndividualIterator i = this._abox.getIndIterator();
                Iterator rule = this._tableauRules.iterator();
                while (rule.hasNext() && !(closed = (tableauRule = (TableauRule)rule.next()).apply(i))) {
                }
                if (this._abox.isClosed()) break;
                if (this._abox.isChanged() || this._partialBindings.isEmpty()) continue;
                this.applyRuleBindings();
                if (!this._abox.isClosed()) continue;
                break;
            }
            if (this._abox.isClosed()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Clash at Branch (" + this._abox.getBranchIndex() + ") " + this._abox.getClash());
                }
                if (this.backtrack()) {
                    this._abox.setClash(null);
                    continue;
                }
                this._abox.setComplete(true);
                continue;
            }
            if (OpenlletOptions.SATURATE_TABLEAU) {
                Branch unexploredBranch = null;
                for (int i = this._abox.getBranches().size() - 1; i >= 0; --i) {
                    unexploredBranch = this._abox.getBranches().get(i);
                    unexploredBranch.setTryNext(unexploredBranch.getTryNext() + 1);
                    if (unexploredBranch.getTryNext() < unexploredBranch.getTryCount()) {
                        this.restore(unexploredBranch);
                        System.out.println("restoring _branch " + unexploredBranch.getBranchIndexInABox() + " _tryNext = " + unexploredBranch.getTryNext() + " _tryCount = " + unexploredBranch.getTryCount());
                        unexploredBranch.tryNext();
                        break;
                    }
                    System.out.println("removing _branch " + unexploredBranch.getBranchIndexInABox());
                    this._abox.getBranches().remove(i);
                    unexploredBranch = null;
                }
                if (unexploredBranch != null) continue;
                this._abox.setComplete(true);
                continue;
            }
            this._abox.setComplete(true);
        }
    }

    private int createDisjunctionsFromBinding(VariableBinding binding, Rule rule, DependencySet dsParam) {
        DependencySet ds = dsParam;
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            DependencySet dependencySet = this._atomTester.isAtomTrue(ruleAtom, binding);
            if (dependencySet != null) {
                ds = ds.union(dependencySet, this._abox.doExplanation());
                continue;
            }
            atoms.add(ruleAtom);
        }
        if (atoms.isEmpty()) {
            if (rule.getHead().isEmpty()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Empty head for rule " + rule);
                }
                this._abox.setClash(Clash.unexplained(null, ds));
            } else {
                for (RuleAtom ruleAtom : rule.getHead()) {
                    this._ruleAtomAsserter.assertAtom(ruleAtom, binding, ds, false, this._abox, this);
                }
            }
            return -1;
        }
        int bodyAtomCount = atoms.size();
        for (RuleAtom ruleAtom : rule.getHead()) {
            DependencySet atomDS = this._atomTester.isAtomTrue(ruleAtom, binding);
            if (atomDS != null) continue;
            atoms.add(ruleAtom);
        }
        if (atoms.size() == bodyAtomCount && !rule.getHead().isEmpty()) {
            return -1;
        }
        if (atoms.size() == 1) {
            this._ruleAtomAsserter.assertAtom((RuleAtom)atoms.get(0), binding, ds, true, this._abox, this);
            return -1;
        }
        RuleBranch ruleBranch = new RuleBranch(this._abox, this, this._ruleAtomAsserter, atoms, binding, bodyAtomCount, ds);
        this.addBranch(ruleBranch);
        ruleBranch.tryNext();
        return ruleBranch.getBranchIndexInABox();
    }

    @Override
    public void mergeTo(Node y, Node z, DependencySet ds) {
        this._merging = true;
        super.mergeTo(y, z, ds);
        if (this._abox.isClosed() || this._interpreter == null || y.isRootNominal() || z.isRootNominal()) {
            // empty if block
        }
        this._merging = false;
    }

    @Override
    public void restore(Branch branch) {
        super.restore(branch);
        this.restoreRules(branch);
    }

    @Override
    public void restoreLocal(Individual ind, Branch branch) {
        super.restoreLocal(ind, branch);
        this.restoreRules(branch);
    }

    private void restoreRules(Branch branch) {
        int total = 0;
        Iterator<Map.Entry<Pair<Rule, VariableBinding>, Integer>> ruleAppIter = this._rulesApplied.entrySet().iterator();
        while (ruleAppIter.hasNext()) {
            Map.Entry<Pair<Rule, VariableBinding>, Integer> ruleBranchEntry = ruleAppIter.next();
            if (ruleBranchEntry.getValue() <= branch.getBranchIndexInABox()) continue;
            ruleAppIter.remove();
            ++total;
        }
        Iterator iter = this._partialBindings.iterator();
        while (iter.hasNext()) {
            PartialBinding binding = (PartialBinding)iter.next();
            if (binding.getBranch() <= branch.getBranchIndexInABox()) continue;
            iter.remove();
        }
        this._interpreter.restore(branch.getBranchIndexInABox());
    }
}

