/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Literal;
import openllet.core.datatypes.DatatypeReasoner;
import openllet.core.datatypes.exceptions.DatatypeReasonerException;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.rules.BindingHelper;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.VariableUtils;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.DataRangeAtom;
import openllet.shared.tools.Log;

public class DataRangeBindingHelper
implements BindingHelper {
    private static final Logger _logger = Log.getLogger(DataRangeBindingHelper.class);
    private final DatatypeReasoner _dtReasoner;
    private final DataRangeAtom _atom;
    private boolean _hasNext;

    public DataRangeBindingHelper(ABox abox, DataRangeAtom atom) {
        this._dtReasoner = abox.getDatatypeReasoner();
        this._atom = atom;
        this._hasNext = false;
    }

    public Collection<AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
        return Collections.emptySet();
    }

    public Collection<AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
        return VariableUtils.getVars(this._atom);
    }

    @Override
    public void rebind(VariableBinding newBinding) {
        Literal dValue = newBinding.get((AtomDObject)this._atom.getArgument());
        if (dValue == null) {
            throw new InternalReasonerException("DataRangeBindingHelper cannot generate bindings for " + this._atom);
        }
        try {
            this._hasNext = this._dtReasoner.isSatisfiable(Collections.singleton((ATermAppl)this._atom.getPredicate()), dValue.getValue());
        }
        catch (DatatypeReasonerException e) {
            String msg = "Unexpected datatype reasoner exception: " + e.getMessage();
            _logger.severe(msg);
            throw new InternalReasonerException(e);
        }
    }

    @Override
    public boolean selectNextBinding() {
        if (this._hasNext) {
            this._hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public void setCurrentBinding(VariableBinding currentBinding) {
    }

    public String toString() {
        return this._atom.toString();
    }
}

