/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Individual;
import openllet.core.rules.AllNamedIndividualsIterator;
import openllet.core.rules.BindingHelper;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.model.AtomIObject;
import openllet.core.rules.model.AtomIVariable;
import openllet.core.rules.model.AtomVariable;

public class ObjectVariableBindingHelper
implements BindingHelper {
    private final ABox _abox;
    private final AtomIVariable _var;
    private volatile Individual _currentIndividual;
    private volatile Iterator<Individual> _individualIterator;

    public ObjectVariableBindingHelper(ABox abox, AtomIVariable var) {
        this._abox = abox;
        this._var = var;
    }

    public Collection<AtomIVariable> getBindableVars(Collection<AtomVariable> bound) {
        return Collections.singleton(this._var);
    }

    public Collection<AtomIVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
        return Collections.emptyList();
    }

    @Override
    public void rebind(VariableBinding newBinding) {
        this._individualIterator = newBinding.containsKey(this._var) ? Collections.singleton(newBinding.get(this._var)).iterator() : new AllNamedIndividualsIterator(this._abox);
    }

    @Override
    public boolean selectNextBinding() {
        if (this._individualIterator == null || !this._individualIterator.hasNext()) {
            return false;
        }
        this._currentIndividual = this._individualIterator.next();
        return true;
    }

    @Override
    public void setCurrentBinding(VariableBinding currentBinding) {
        currentBinding.set((AtomIObject)this._var, this._currentIndividual);
    }

    public String toString() {
        return "individuals(" + this._var + ")";
    }
}

