/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules;

import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.rules.model.AtomDConstant;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomDVariable;
import openllet.core.rules.model.AtomIConstant;
import openllet.core.rules.model.AtomIVariable;
import openllet.core.rules.model.AtomObject;
import openllet.core.rules.model.AtomObjectVisitor;
import openllet.core.rules.model.BuiltInAtom;
import openllet.core.rules.model.ClassAtom;
import openllet.core.rules.model.DataRangeAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.DifferentIndividualsAtom;
import openllet.core.rules.model.IndividualPropertyAtom;
import openllet.core.rules.model.Rule;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.model.RuleAtomVisitor;
import openllet.core.rules.model.SameIndividualAtom;
import openllet.core.utils.ATermUtils;

public class RulesToATermTranslator
implements RuleAtomVisitor,
AtomObjectVisitor {
    private volatile ATermAppl _term = null;

    public ATermAppl translate(Rule rule) {
        this._term = null;
        this.visit(rule);
        return this._term;
    }

    public ATermAppl translate(RuleAtom ruleAtom) {
        this._term = null;
        ruleAtom.accept(this);
        return this._term;
    }

    public ATermAppl translate(AtomObject obj) {
        this._term = null;
        obj.accept(this);
        return this._term;
    }

    public void visit(Rule rule) {
        ATermAppl[] head = new ATermAppl[rule.getHead().size()];
        ATermAppl[] body = new ATermAppl[rule.getBody().size()];
        int i = 0;
        for (RuleAtom ruleAtom : rule.getHead()) {
            head[i++] = this.translate(ruleAtom);
        }
        i = 0;
        for (RuleAtom ruleAtom : rule.getBody()) {
            body[i++] = this.translate(ruleAtom);
        }
        this._term = ATermUtils.makeRule(rule.getName(), head, body);
    }

    @Override
    public void visit(BuiltInAtom atom) {
        int arity = atom.getAllArguments().size();
        ATermAppl[] args = new ATermAppl[arity + 1];
        args[0] = ATermUtils.makeTermAppl((String)atom.getPredicate());
        int i = 1;
        for (AtomDObject arg : atom.getAllArguments()) {
            args[i++] = this.translate(arg);
        }
        this._term = ATermUtils.makeBuiltinAtom(args);
    }

    @Override
    public void visit(ClassAtom atom) {
        ATermAppl c = (ATermAppl)atom.getPredicate();
        ATermAppl i = this.translate((AtomObject)atom.getArgument());
        this._term = ATermUtils.makeTypeAtom(i, c);
    }

    @Override
    public void visit(DataRangeAtom atom) {
        ATermAppl d = (ATermAppl)atom.getPredicate();
        ATermAppl l = this.translate((AtomObject)atom.getArgument());
        this._term = ATermUtils.makeTypeAtom(l, d);
    }

    @Override
    public void visit(DatavaluedPropertyAtom atom) {
        ATermAppl p = (ATermAppl)atom.getPredicate();
        ATermAppl s = this.translate((AtomObject)atom.getArgument1());
        ATermAppl o = this.translate((AtomObject)atom.getArgument2());
        this._term = ATermUtils.makePropAtom(p, s, o);
    }

    @Override
    public void visit(DifferentIndividualsAtom atom) {
        ATermAppl t1 = this.translate((AtomObject)atom.getArgument1());
        ATermAppl t2 = this.translate((AtomObject)atom.getArgument2());
        this._term = ATermUtils.makeDifferent((ATerm)t1, (ATerm)t2);
    }

    @Override
    public void visit(IndividualPropertyAtom atom) {
        ATermAppl p = (ATermAppl)atom.getPredicate();
        ATermAppl s = this.translate((AtomObject)atom.getArgument1());
        ATermAppl o = this.translate((AtomObject)atom.getArgument2());
        this._term = ATermUtils.makePropAtom(p, s, o);
    }

    @Override
    public void visit(SameIndividualAtom atom) {
        ATermAppl t1 = this.translate((AtomObject)atom.getArgument1());
        ATermAppl t2 = this.translate((AtomObject)atom.getArgument2());
        this._term = ATermUtils.makeSameAs((ATerm)t1, (ATerm)t2);
    }

    @Override
    public void visit(AtomDConstant constant) {
        this._term = constant.getValue();
    }

    @Override
    public void visit(AtomDVariable variable) {
        this._term = ATermUtils.makeVar(variable.getName());
    }

    @Override
    public void visit(AtomIConstant constant) {
        this._term = constant.getValue();
    }

    @Override
    public void visit(AtomIVariable variable) {
        this._term = ATermUtils.makeVar(variable.getName());
    }
}

