/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.rules.BindingHelper;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.VariableUtils;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomIObject;
import openllet.core.rules.model.AtomObject;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.BuiltInAtom;
import openllet.core.rules.model.ClassAtom;
import openllet.core.rules.model.DataRangeAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.DifferentIndividualsAtom;
import openllet.core.rules.model.IndividualPropertyAtom;
import openllet.core.rules.model.Rule;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.model.RuleAtomVisitor;
import openllet.core.rules.model.SameIndividualAtom;
import openllet.core.utils.ATermUtils;

public class TrivialSatisfactionHelpers {
    private static final BindingTester ALWAYS_TRUE = new BindingTester(){

        @Override
        public DependencySet check(VariableBinding binding) {
            return DependencySet.INDEPENDENT;
        }

        public String toString() {
            return "test(TRUE)";
        }
    };
    private final ABox _abox;

    public TrivialSatisfactionHelpers(ABox abox) {
        this._abox = abox;
    }

    public Collection<BindingHelper> getHelpers(Rule rule) {
        ArrayList<BindingHelper> helpers = new ArrayList<BindingHelper>();
        BodyAtomVisitor bodyVisitor = new BodyAtomVisitor();
        for (RuleAtom ruleAtom : rule.getBody()) {
            ruleAtom.accept(bodyVisitor);
            if (bodyVisitor.getTester() == null) continue;
            helpers.add(new FilterHelper(bodyVisitor.getTester(), VariableUtils.getVars(ruleAtom)));
        }
        return helpers;
    }

    public DependencySet isAtomTrue(RuleAtom atom, VariableBinding binding) {
        HeadAtomVisitor visitor = new HeadAtomVisitor();
        atom.accept(visitor);
        BindingTester tester = visitor.getTester();
        return tester == null ? null : tester.check(binding);
    }

    private static abstract class UnaryBindingTester<R extends AtomObject>
    implements BindingTester {
        public R _arg;
        final /* synthetic */ TrivialSatisfactionHelpers this$0;

        public UnaryBindingTester(R arg) {
            this.this$0 = var1_1;
            this._arg = arg;
        }

        public R getArg() {
            return this._arg;
        }
    }

    private class TestSame
    extends BinaryBindingTester<AtomIObject, AtomIObject> {
        public TestSame(AtomIObject arg1, AtomIObject arg2) {
            super(TrivialSatisfactionHelpers.this, (AtomObject)arg1, (AtomObject)arg2);
        }

        @Override
        public DependencySet check(VariableBinding binding) {
            Individual ind2;
            Individual ind1 = binding.get((AtomIObject)this._arg1);
            if (ind1.isSame(ind2 = binding.get((AtomIObject)this._arg2))) {
                DependencySet ds1 = ind1.getMergeDependency(true);
                DependencySet ds2 = ind2.getMergeDependency(true);
                return ds1 == null ? ds2 : (ds2 == null ? ds1 : ds1.union(ds2, true));
            }
            return null;
        }
    }

    private static abstract class TestProperty<S extends AtomObject>
    extends BinaryBindingTester<AtomIObject, S> {
        public Role _role;
        final /* synthetic */ TrivialSatisfactionHelpers this$0;

        public TestProperty(ATermAppl p, AtomIObject arg1, S arg2) {
            this.this$0 = var1_1;
            super((TrivialSatisfactionHelpers)var1_1, (AtomObject)arg1, arg2);
            this._role = ((TrivialSatisfactionHelpers)var1_1)._abox.getRole((ATerm)p);
            if (this._role == null) {
                throw new InternalReasonerException("Cannot retreive role!: " + p);
            }
        }

        public DependencySet check(Individual node1, Node node2) {
            EdgeList list = node1.getRNeighborEdges(this._role);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Edge edge = (Edge)list.get(i);
                if (!edge.getNeighbor(node1).equals(node2)) continue;
                return edge.getDepends();
            }
            return null;
        }
    }

    private class TestIndividualProperty
    extends TestProperty<AtomIObject> {
        public TestIndividualProperty(ATermAppl p, AtomIObject arg1, AtomIObject arg2) {
            super(TrivialSatisfactionHelpers.this, p, arg1, (AtomObject)arg2);
        }

        @Override
        public DependencySet check(VariableBinding binding) {
            return this.check(binding.get((AtomIObject)this.getArg1()), binding.get((AtomIObject)this.getArg2()));
        }
    }

    private class TestDifferent
    extends BinaryBindingTester<AtomIObject, AtomIObject> {
        public TestDifferent(AtomIObject arg1, AtomIObject arg2) {
            super(TrivialSatisfactionHelpers.this, (AtomObject)arg1, (AtomObject)arg2);
        }

        @Override
        public DependencySet check(VariableBinding binding) {
            return binding.get((AtomIObject)this._arg1).getDifferenceDependency(binding.get((AtomIObject)this._arg2));
        }

        public String toString() {
            return "notDifferent(" + this.getArg1() + "," + this.getArg2() + ")";
        }
    }

    private class TestDataProperty
    extends TestProperty<AtomDObject> {
        public TestDataProperty(ATermAppl p, AtomIObject arg1, AtomDObject arg2) {
            super(TrivialSatisfactionHelpers.this, p, arg1, (AtomObject)arg2);
        }

        @Override
        public DependencySet check(VariableBinding binding) {
            return this.check(binding.get((AtomIObject)this.getArg1()), binding.get((AtomDObject)this.getArg2()));
        }
    }

    private class TestClass
    extends UnaryBindingTester<AtomIObject> {
        private final ATermAppl _c;

        public TestClass(ATermAppl c, AtomIObject arg) {
            super(TrivialSatisfactionHelpers.this, (AtomObject)arg);
            this._c = c;
        }

        @Override
        public DependencySet check(VariableBinding binding) {
            Individual ind = binding.get((AtomIObject)this.getArg());
            return ind.getDepends((ATerm)this._c);
        }

        public String toString() {
            return "notClass(" + this.getArg() + ":" + this._c + ")";
        }
    }

    private class HeadAtomVisitor
    implements RuleAtomVisitor {
        private BindingTester _tester = null;

        private HeadAtomVisitor() {
        }

        public BindingTester getTester() {
            return this._tester;
        }

        @Override
        public void visit(BuiltInAtom atom) {
            this._tester = ALWAYS_TRUE;
        }

        @Override
        public void visit(ClassAtom atom) {
            this._tester = new TestClass(ATermUtils.normalize((ATermAppl)atom.getPredicate()), (AtomIObject)atom.getArgument());
        }

        @Override
        public void visit(DataRangeAtom atom) {
            this._tester = ALWAYS_TRUE;
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            this._tester = new TestDataProperty((ATermAppl)atom.getPredicate(), (AtomIObject)atom.getArgument1(), (AtomDObject)atom.getArgument2());
        }

        @Override
        public void visit(DifferentIndividualsAtom atom) {
            this._tester = new TestDifferent((AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2());
        }

        @Override
        public void visit(IndividualPropertyAtom atom) {
            this._tester = new TestIndividualProperty((ATermAppl)atom.getPredicate(), (AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2());
        }

        @Override
        public void visit(SameIndividualAtom atom) {
            this._tester = new TestSame((AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2());
        }
    }

    private static class FilterHelper
    implements BindingHelper {
        private boolean _result = false;
        private final BindingTester _tester;
        private final Collection<? extends AtomVariable> _vars;

        public FilterHelper(BindingTester tester, Collection<? extends AtomVariable> vars) {
            this._tester = tester;
            this._vars = vars;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
            return Collections.emptySet();
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
            return this._vars;
        }

        @Override
        public void rebind(VariableBinding newBinding) {
            this._result = this._tester.check(newBinding) == null;
        }

        @Override
        public boolean selectNextBinding() {
            boolean result = this._result;
            this._result = false;
            return result;
        }

        @Override
        public void setCurrentBinding(VariableBinding currentBinding) {
        }

        public String toString() {
            return "Filter(" + this._tester + ")";
        }
    }

    private class BodyAtomVisitor
    implements RuleAtomVisitor {
        private BindingTester _tester = null;

        private BodyAtomVisitor() {
        }

        public BindingTester getTester() {
            return this._tester;
        }

        @Override
        public void visit(BuiltInAtom atom) {
            this._tester = null;
        }

        @Override
        public void visit(ClassAtom atom) {
            this._tester = new TestClass(ATermUtils.normalize(ATermUtils.negate((ATermAppl)atom.getPredicate())), (AtomIObject)atom.getArgument());
        }

        @Override
        public void visit(DataRangeAtom atom) {
            this._tester = null;
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            this._tester = null;
        }

        @Override
        public void visit(DifferentIndividualsAtom atom) {
            this._tester = new TestSame((AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2());
        }

        @Override
        public void visit(IndividualPropertyAtom atom) {
            this._tester = null;
        }

        @Override
        public void visit(SameIndividualAtom atom) {
            this._tester = new TestDifferent((AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2());
        }
    }

    private static interface BindingTester {
        public DependencySet check(VariableBinding var1);
    }

    private static abstract class BinaryBindingTester<R extends AtomObject, S extends AtomObject>
    implements BindingTester {
        public R _arg1;
        public S _arg2;
        final /* synthetic */ TrivialSatisfactionHelpers this$0;

        public BinaryBindingTester(R arg1, S arg2) {
            this.this$0 = var1_1;
            this._arg1 = arg1;
            this._arg2 = arg2;
        }

        public R getArg1() {
            return this._arg1;
        }

        public S getArg2() {
            return this._arg2;
        }
    }
}

