/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.math.BigDecimal;
import java.math.BigInteger;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Literal;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.rules.builtins.NumericVisitor;
import openllet.core.utils.ATermUtils;

public class NumberToLiteralVisitor
implements NumericVisitor {
    private final ABox _abox;
    private Literal _result;

    public NumberToLiteralVisitor(ABox abox) {
        this._abox = abox;
    }

    private static void argCheck(Number[] args) {
        if (args.length != 1) {
            throw new InternalReasonerException("Wrong number of arguments to visitor.");
        }
    }

    public Literal getLiteral() {
        return this._result;
    }

    private void setLiteral(Number arg, String typeURI) {
        this._result = this._abox.addLiteral(ATermUtils.makeTypedLiteral(arg.toString(), typeURI));
    }

    @Override
    public void visit(BigDecimal[] args) {
        NumberToLiteralVisitor.argCheck(args);
        this.setLiteral(args[0], "http://www.w3.org/2001/XMLSchema#decimal");
    }

    @Override
    public void visit(BigInteger[] args) {
        NumberToLiteralVisitor.argCheck(args);
        this.setLiteral(args[0], "http://www.w3.org/2001/XMLSchema#integer");
    }

    @Override
    public void visit(Double[] args) {
        NumberToLiteralVisitor.argCheck(args);
        this.setLiteral(args[0], "http://www.w3.org/2001/XMLSchema#double");
    }

    @Override
    public void visit(Float[] args) {
        NumberToLiteralVisitor.argCheck(args);
        this.setLiteral(args[0], "http://www.w3.org/2001/XMLSchema#float");
    }
}

