/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.net.URI;
import java.net.URISyntaxException;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.rules.builtins.Function;
import openllet.core.rules.builtins.StringFunctionAdapter;
import openllet.core.rules.builtins.StringToStringFunction;

public class URIOperators {
    public static final Function resolveURI = new StringFunctionAdapter(new ResolveURI());
    public static final Function anyURI = new StringFunctionAdapter(new AnyURI());

    private static class AnyURI
    implements StringToStringFunction {
        private AnyURI() {
        }

        @Override
        public String apply(String ... args) {
            if (args.length != 6) {
                throw new InternalReasonerException("AnyURI wrong number of arguments");
            }
            Object schema = args[0];
            Object host = args[1];
            Object port = args[2];
            Object path = args[3];
            Object query = args[4];
            Object fragment = args[5];
            if (!((String)schema).endsWith(":")) {
                schema = (String)schema + ":";
            }
            if (!((String)host).startsWith("//")) {
                host = "//" + (String)host;
            }
            if (((String)port).length() > 0 && !((String)port).startsWith(":")) {
                port = ":" + (String)port;
            }
            if (((String)path).length() > 0 && !((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            if (((String)query).length() > 0 && !((String)query).startsWith("?")) {
                query = "?" + (String)query;
            }
            if (((String)fragment).length() > 0 && !((String)fragment).startsWith("#")) {
                fragment = "#" + (String)fragment;
            }
            try {
                return new URI((String)schema + (String)host + (String)port + (String)path + (String)query + (String)fragment).toASCIIString();
            }
            catch (URISyntaxException e) {
                throw new InternalReasonerException("Returned string is not a URI", e);
            }
        }
    }

    private static class ResolveURI
    implements StringToStringFunction {
        private ResolveURI() {
        }

        @Override
        public String apply(String ... args) {
            URI baseURI;
            URI relativeURI;
            if (args.length != 2) {
                throw new InternalReasonerException("ResolveURI takes two and only two arguments");
            }
            String relative = args[0];
            String base = args[1];
            if (relative.length() == 0) {
                return relative;
            }
            try {
                relativeURI = new URI(relative);
                if (relativeURI.isAbsolute()) {
                    return relative;
                }
            }
            catch (URISyntaxException e) {
                throw new InternalReasonerException("Relative URI reference is not a valid URI", e);
            }
            try {
                baseURI = new URI(base);
            }
            catch (URISyntaxException e) {
                throw new InternalReasonerException("Base URI reference is not a valid URI", e);
            }
            try {
                URI ret = new URI(baseURI.toASCIIString() + relativeURI.toASCIIString());
                return ret.toASCIIString();
            }
            catch (URISyntaxException e) {
                throw new InternalReasonerException("Evaluation of base and relative URI is not a URI", e);
            }
        }
    }
}

