/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.rules.model.AtomConstant;
import openllet.core.rules.model.AtomObject;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.BinaryAtom;
import openllet.core.rules.model.BuiltInAtom;
import openllet.core.rules.model.ClassAtom;
import openllet.core.rules.model.DataRangeAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.DifferentIndividualsAtom;
import openllet.core.rules.model.IndividualPropertyAtom;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.model.RuleAtomVisitor;
import openllet.core.rules.model.SameIndividualAtom;
import openllet.core.rules.rete.AlphaDiffFromNode;
import openllet.core.rules.rete.AlphaEdgeNode;
import openllet.core.rules.rete.AlphaFixedObjectEdgeNode;
import openllet.core.rules.rete.AlphaFixedSubjectEdgeNode;
import openllet.core.rules.rete.AlphaNoVarEdgeNode;
import openllet.core.rules.rete.AlphaNode;
import openllet.core.rules.rete.AlphaReflexiveEdgeNode;
import openllet.core.rules.rete.AlphaTypeNode;

public class AlphaNetwork
implements Iterable<AlphaNode> {
    private final Map<Object, List<AlphaNode>> _map = new ConcurrentHashMap<Object, List<AlphaNode>>();
    private final List<AlphaNode> _alphaNodes = new ArrayList<AlphaNode>();
    private final AlphaNodeCreator _creator = new AlphaNodeCreator();
    private final ABox _abox;

    public AlphaNetwork(ABox abox) {
        this._abox = abox;
    }

    @Override
    public Iterator<AlphaNode> iterator() {
        return this._alphaNodes.iterator();
    }

    public AlphaNode addNode(RuleAtom atom) {
        Object pred = atom.getPredicate();
        List<AlphaNode> nodes = this._map.get(pred);
        if (nodes == null) {
            nodes = new ArrayList<AlphaNode>();
            this._map.put(pred, nodes);
        } else {
            for (AlphaNode node : nodes) {
                if (!node.matches(atom)) continue;
                return node;
            }
        }
        AlphaNode node = this._creator.create(atom);
        if (node != null) {
            if (node instanceof AlphaEdgeNode) {
                Role role = ((AlphaEdgeNode)node).getRole();
                this.addAlphaNodeForSubs(role, node);
                if (role.isObjectRole()) {
                    this.addAlphaNodeForSubs(role.getInverse(), node);
                }
            } else {
                nodes.add(node);
            }
        }
        this._alphaNodes.add(node);
        return node;
    }

    private void addAlphaNodeForSubs(Role r, AlphaNode node) {
        for (Role sub : r.getSubRoles()) {
            if (sub.isBottom()) continue;
            this.addAlphaNode(sub, node);
        }
    }

    private void addAlphaNode(Role r, AlphaNode node) {
        if (!r.isAnon()) {
            List<AlphaNode> subNodes = this._map.get(r.getName());
            if (subNodes == null) {
                subNodes = new ArrayList<AlphaNode>();
                this._map.put(r.getName(), subNodes);
            }
            subNodes.add(node);
        }
    }

    public void activateAll() {
        this._abox.getIndIterator().forEachRemaining(this::activateIndividual);
    }

    public boolean activateIndividual(Individual ind) {
        boolean changed = false;
        if (!ind.isRootNominal() || ind.isPruned()) {
            return false;
        }
        List<ATermAppl> types = ind.getTypes(0);
        for (int i = 0; i < types.size(); ++i) {
            ATermAppl type = types.get(i);
            this.activateType(ind, type, ind.getDepends((ATerm)type));
        }
        this.activateDifferents(ind);
        for (Edge edge : new ArrayList<Edge>(ind.getOutEdges())) {
            if (!edge.getTo().isRootNominal()) continue;
            this.activateEdge(edge);
        }
        return false;
    }

    public void activateType(Individual ind, ATermAppl type, DependencySet ds) {
        List<AlphaNode> alphas = this._map.get(type);
        if (alphas != null) {
            for (AlphaNode alpha : alphas) {
                ((AlphaTypeNode)alpha).activate(ind, type, ds);
            }
        }
    }

    public void activateEdge(Edge edge) {
        List<AlphaNode> alphas;
        Role r = edge.getRole();
        if (r.isAnon()) {
            r = r.getInverse();
        }
        if ((alphas = this._map.get(r.getName())) != null) {
            for (AlphaNode alpha : alphas) {
                ((AlphaEdgeNode)alpha).activate(edge);
            }
        }
    }

    public void activateDifferents(Individual ind) {
        List<AlphaNode> alphas = this._map.get("DIFFERENT");
        if (alphas != null) {
            for (Node n : ind.getDifferents()) {
                Individual diff = (Individual)n;
                for (AlphaNode alpha : alphas) {
                    ((AlphaDiffFromNode)alpha).activate(ind, diff, ind.getDifferenceDependency(diff));
                }
            }
        }
    }

    public void activateDifferent(Individual ind, Individual diff, DependencySet ds) {
        List<AlphaNode> alphas = this._map.get("DIFFERENT");
        if (alphas != null) {
            for (AlphaNode alpha : alphas) {
                ((AlphaDiffFromNode)alpha).activate(ind, diff, ds);
            }
        }
    }

    public void setDoExplanation(boolean doExplanation) {
        for (AlphaNode alphaNode : this._alphaNodes) {
            alphaNode.setDoExplanation(doExplanation);
        }
    }

    public void print() {
        for (AlphaNode node : this._alphaNodes) {
            node.unmark();
        }
        for (AlphaNode node : this._alphaNodes) {
            node.print("");
        }
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        for (AlphaNode node : this) {
            tmp.append(node.toString()).append("\n");
        }
        return tmp.toString();
    }

    private class AlphaNodeCreator
    implements RuleAtomVisitor {
        private AlphaNode _result;

        private AlphaNodeCreator() {
        }

        private AlphaNode create(RuleAtom atom) {
            this._result = null;
            atom.accept(this);
            if (this._result == null) {
                throw new UnsupportedOperationException("Not supported " + atom);
            }
            return this._result;
        }

        private void addPropertyAtom(BinaryAtom<ATermAppl, ? extends AtomObject, ? extends AtomObject> atom) {
            AtomObject s = atom.getArgument1();
            AtomObject o = atom.getArgument2();
            Role role = AlphaNetwork.this._abox.getRole((ATerm)atom.getPredicate());
            this._result = s instanceof AtomVariable && o instanceof AtomVariable ? (s.equals(o) ? new AlphaReflexiveEdgeNode(AlphaNetwork.this._abox, role) : new AlphaEdgeNode(AlphaNetwork.this._abox, role)) : (s instanceof AtomConstant ? (o instanceof AtomConstant ? new AlphaNoVarEdgeNode(AlphaNetwork.this._abox, role, ((AtomConstant)s).getValue(), ((AtomConstant)o).getValue()) : new AlphaFixedSubjectEdgeNode(AlphaNetwork.this._abox, role, ((AtomConstant)s).getValue())) : new AlphaFixedObjectEdgeNode(AlphaNetwork.this._abox, role, ((AtomConstant)o).getValue()));
        }

        @Override
        public void visit(SameIndividualAtom atom) {
        }

        @Override
        public void visit(IndividualPropertyAtom atom) {
            this.addPropertyAtom(atom);
        }

        @Override
        public void visit(DifferentIndividualsAtom atom) {
            this._result = new AlphaDiffFromNode(AlphaNetwork.this._abox);
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            this.addPropertyAtom(atom);
        }

        @Override
        public void visit(DataRangeAtom atom) {
        }

        @Override
        public void visit(ClassAtom atom) {
            Object arg = atom.getArgument();
            ATermAppl name = arg instanceof AtomConstant ? ((AtomConstant)arg).getValue() : null;
            this._result = new AlphaTypeNode(AlphaNetwork.this._abox, (ATermAppl)atom.getPredicate(), name);
        }

        @Override
        public void visit(BuiltInAtom atom) {
        }
    }
}

