/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.Arrays;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Literal;
import openllet.core.rules.builtins.BuiltIn;
import openllet.core.rules.rete.BetaNode;
import openllet.core.rules.rete.NodeProvider;
import openllet.core.rules.rete.Token;
import openllet.core.rules.rete.WME;
import openllet.core.utils.ATermUtils;

public class BetaBuiltinNode
extends BetaNode {
    private final ABox _abox;
    private final String _name;
    private final BuiltIn _builtin;
    private final NodeProvider[] _args;

    public BetaBuiltinNode(ABox abox, String name, BuiltIn builtin, NodeProvider[] args) {
        this._abox = abox;
        this._name = name;
        this._builtin = builtin;
        this._args = args;
    }

    @Override
    public void activate(WME wme) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void activate(Token token) {
        Literal[] literals = new Literal[this._args.length];
        for (int i = 0; i < literals.length; ++i) {
            literals[i] = this._args[i] == null ? null : (Literal)this._args[i].getNode(null, token);
        }
        if (this._builtin.apply(this._abox, literals)) {
            this.activateChildren(WME.createBuiltin(literals, DependencySet.INDEPENDENT), token);
        }
    }

    @Override
    public void print(String indentLvl) {
        String indent = indentLvl + "  ";
        System.out.print(indent);
        System.out.println(this);
        for (BetaNode node : this.getBetas()) {
            node.print(indent);
        }
    }

    public String toString() {
        return "Builtin " + ATermUtils.toString(ATermUtils.makeTermAppl(this._name)) + Arrays.toString(this._args);
    }
}

