/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.Arrays;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Literal;
import openllet.core.rules.builtins.BuiltIn;
import openllet.core.rules.rete.FilterCondition;
import openllet.core.rules.rete.NodeProvider;
import openllet.core.rules.rete.Token;
import openllet.core.rules.rete.WME;
import openllet.core.utils.ATermUtils;

public class BuiltInCondition
implements FilterCondition {
    private final ABox _abox;
    private final String _name;
    private final BuiltIn _builtin;
    private final NodeProvider[] _args;

    public BuiltInCondition(ABox abox, String name, BuiltIn builtin, NodeProvider[] args) {
        this._abox = abox;
        this._name = name;
        this._builtin = builtin;
        this._args = args;
        for (NodeProvider arg : args) {
            if (arg != null) continue;
            throw new NullPointerException();
        }
    }

    @Override
    public boolean test(WME wme, Token token) {
        Literal[] literals = new Literal[this._args.length];
        for (int i = 0; i < literals.length; ++i) {
            literals[i] = (Literal)this._args[i].getNode(wme, token);
        }
        return this._builtin.apply(this._abox, literals);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._args);
        result = 31 * result + this._builtin.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BuiltInCondition)) {
            return false;
        }
        BuiltInCondition other = (BuiltInCondition)obj;
        return this._builtin.equals(other._builtin) && Arrays.equals(this._args, other._args);
    }

    public String toString() {
        return ATermUtils.toString(ATermUtils.makeTermAppl(this._name)) + Arrays.toString(this._args);
    }
}

