/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import openllet.core.rules.rete.BetaNode;
import openllet.shared.tools.Log;

public abstract class ReteNode {
    public static final Logger _logger = Log.getLogger(ReteNode.class);
    private final List<BetaNode> _children = new ArrayList<BetaNode>();
    private boolean _marked = false;

    public void addChild(BetaNode beta) {
        this._children.add(beta);
    }

    public Collection<BetaNode> getBetas() {
        return this._children;
    }

    public void reset() {
        for (BetaNode child : this._children) {
            child.reset();
        }
    }

    public void restore(int branch) {
        for (BetaNode child : this._children) {
            child.restore(branch);
        }
    }

    public void mark() {
        this.setMark(true);
    }

    public void unmark() {
        this.setMark(false);
    }

    private void setMark(boolean value) {
        this._marked = value;
        for (ReteNode reteNode : this._children) {
            reteNode.setMark(value);
        }
    }

    public void print(String indent) {
        System.out.print(indent);
        System.out.println(this);
    }
}

