/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.logging.Logger;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.IndividualIterator;
import openllet.core.boxes.abox.Node;
import openllet.core.tableau.blocking.Blocking;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.queue.QueueElement;
import openllet.core.tableau.completion.rule.TableauRule;
import openllet.shared.tools.Log;

public abstract class AbstractTableauRule
implements TableauRule {
    public static final Logger _logger = Log.getLogger(AbstractTableauRule.class);
    protected final CompletionStrategy _strategy;
    protected final NodeSelector _nodeSelector;
    protected final BlockingType _blockingType;

    public AbstractTableauRule(CompletionStrategy strategy, NodeSelector nodeSelector, BlockingType blockingType) {
        this._strategy = strategy;
        this._nodeSelector = nodeSelector;
        this._blockingType = blockingType;
    }

    @Override
    public boolean apply(IndividualIterator i) {
        if (OpenlletOptions.USE_THREADED_KERNEL) {
            Blocking blocking = this._strategy.getBlocking();
            return i.nodes().filter(node -> {
                if (blocking.isBlocked((Individual)node)) {
                    if (OpenlletOptions.USE_COMPLETION_QUEUE) {
                        this.addQueueElement((Node)node);
                    }
                } else {
                    this.apply((Individual)node);
                    if (this._strategy.getABox().isClosed()) {
                        return true;
                    }
                }
                return false;
            }).findAny().isPresent();
        }
        i.reset(this._nodeSelector);
        ABox abox = this._strategy.getABox();
        if (OpenlletOptions.USE_COMPLETION_QUEUE) {
            while (i.hasNext()) {
                Individual node2 = i.next();
                if (this._strategy.getBlocking().isBlocked(node2)) {
                    this.addQueueElement(node2);
                    continue;
                }
                this.apply(node2);
                if (!abox.isClosed()) continue;
                return true;
            }
        } else {
            while (i.hasNext()) {
                Individual node3 = i.next();
                if (this._strategy.getBlocking().isBlocked(node3)) continue;
                this.apply(node3);
                if (!abox.isClosed()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isBlocked(Individual node) {
        switch (this._blockingType) {
            case NONE: {
                return false;
            }
            case DIRECT: {
                return this._strategy.getBlocking().isDirectlyBlocked(node);
            }
            case INDIRECT: {
                return this._strategy.getBlocking().isIndirectlyBlocked(node);
            }
            case COMPLETE: {
                return this._strategy.getBlocking().isBlocked(node);
            }
        }
        throw new AssertionError();
    }

    protected void addQueueElement(Node node) {
        this._strategy.getABox().getCompletionQueue().add(new QueueElement(node), this._nodeSelector);
    }

    protected static enum BlockingType {
        NONE,
        DIRECT,
        INDIRECT,
        COMPLETE;

    }
}

