/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.List;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermInt;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.rbox.Role;
import openllet.core.tableau.branch.GuessBranch;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.rule.AbstractTableauRule;
import openllet.core.utils.ATermUtils;

public class GuessRule
extends AbstractTableauRule {
    public GuessRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.GUESS, AbstractTableauRule.BlockingType.NONE);
    }

    @Override
    public void apply(Individual x) {
        if (x.isBlockable()) {
            return;
        }
        List<ATermAppl> types = x.getTypes(5);
        int size = types.size();
        for (int j = 0; j < size; ++j) {
            ATermAppl mc = types.get(j);
            this.applyGuessingRule(x, mc);
            if (!this._strategy.getABox().isClosed()) continue;
            return;
        }
    }

    private void applyGuessingRule(Individual x, ATermAppl mc) {
        ATermAppl max = (ATermAppl)mc.getArgument(0);
        Role r = this._strategy.getABox().getRole(max.getArgument(0));
        int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
        ATermAppl c = (ATermAppl)max.getArgument(2);
        if (r.isDatatypeRole()) {
            return;
        }
        boolean apply = false;
        EdgeList edges = x.getRPredecessorEdges(r.getInverse());
        for (int e = 0; e < edges.size(); ++e) {
            Edge edge = (Edge)edges.get(e);
            Individual pred = edge.getFrom();
            if (!pred.isBlockable()) continue;
            apply = true;
            break;
        }
        if (!apply) {
            return;
        }
        if (x.getMaxCard(r) < n) {
            return;
        }
        if (x.hasDistinctRNeighborsForMin(r, n, ATermUtils.TOP, true)) {
            return;
        }
        int guessMin = x.getMinCard(r, c);
        if (guessMin == 0) {
            guessMin = 1;
        }
        DependencySet ds = x.getDepends((ATerm)mc);
        edges = x.getRNeighborEdges(r);
        for (int e = 0; e < edges.size(); ++e) {
            Edge edge = (Edge)edges.get(e);
            ds = ds.union(edge.getDepends(), this._strategy.getABox().doExplanation());
        }
        GuessBranch newBranch = new GuessBranch(this._strategy.getABox(), this._strategy, x, r, guessMin, n, c, ds);
        this._strategy.addBranch(newBranch);
        newBranch.tryNext();
    }
}

