/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermInt;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.abox.NodeMerge;
import openllet.core.boxes.rbox.Role;
import openllet.core.tableau.branch.MaxBranch;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.rule.AbstractTableauRule;
import openllet.core.utils.SetUtils;

public class MaxCardinalityRule
extends AbstractTableauRule {
    public MaxCardinalityRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.MAX_NUMBER, AbstractTableauRule.BlockingType.INDIRECT);
    }

    @Override
    public void apply(Individual ind) {
        if (!ind.canApply(5)) {
            return;
        }
        List<ATermAppl> maxCardinality = ind.getTypes(5);
        for (int i = 0; i < maxCardinality.size(); ++i) {
            ATermAppl mc = maxCardinality.get(i);
            this.applyMaxRule(ind, mc);
            if (this._strategy.getABox().isClosed()) {
                return;
            }
            if (!ind.isMerged()) continue;
            return;
        }
        ind._applyNext[5] = maxCardinality.size();
    }

    protected void applyMaxRule(Individual x, ATermAppl mc) {
        ATermAppl max = (ATermAppl)mc.getArgument(0);
        Role r = this._strategy.getABox().getRole(max.getArgument(0));
        int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
        ATermAppl c = (ATermAppl)max.getArgument(2);
        DependencySet ds = x.getDepends((ATerm)mc);
        if (!OpenlletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        if (n == 1) {
            this.applyFunctionalMaxRule(x, r, c, ds);
            if (this._strategy.getABox().isClosed()) {
                return;
            }
        } else {
            boolean hasMore = true;
            while (hasMore) {
                hasMore = this.applyMaxRule(x, r, c, n, ds);
                if (this._strategy.getABox().isClosed()) {
                    return;
                }
                if (x.isMerged()) {
                    return;
                }
                if (!hasMore) continue;
                ds = ds.union(new DependencySet(this._strategy.getABox().getBranches().size()), this._strategy.getABox().doExplanation());
            }
        }
    }

    protected boolean applyMaxRule(Individual x, Role r, ATermAppl c, int k, DependencySet dsParam) {
        DependencySet ds = dsParam;
        EdgeList edges = x.getRNeighborEdges(r);
        Set<Node> neighbors = edges.getFilteredNeighbors(x, c);
        int n = neighbors.size();
        if (k == 0 && n > 0) {
            for (int e = 0; e < edges.size(); ++e) {
                Edge edge = (Edge)edges.get(e);
                Node neighbor = edge.getNeighbor(x);
                DependencySet typeDS = neighbor.getDepends((ATerm)c);
                if (typeDS == null) continue;
                Role edgeRole = edge.getRole();
                DependencySet subDS = r.getExplainSubOrInv(edgeRole);
                ds = ds.union(subDS, this._strategy.getABox().doExplanation());
                ds = ds.union(edge.getDepends(), this._strategy.getABox().doExplanation());
                ds = ds.union(typeDS, this._strategy.getABox().doExplanation());
            }
            this._strategy.getABox().setClash(Clash.maxCardinality(x, ds, r.getName(), 0));
            return false;
        }
        if (n <= k) {
            return false;
        }
        ArrayList<NodeMerge> mergePairs = new ArrayList<NodeMerge>();
        DependencySet differenceDS = this.findMergeNodes(neighbors, x, mergePairs);
        ds = ds.union(differenceDS, this._strategy.getABox().doExplanation());
        if (mergePairs.size() == 0) {
            DependencySet dsEdges = x.hasDistinctRNeighborsForMax(r, k + 1, c);
            if (dsEdges == null) {
                _logger.fine(() -> "Cannot determine the exact clash dependency for " + x);
                this._strategy.getABox().setClash(Clash.maxCardinality(x, ds));
                return false;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Early clash detection for max rule worked " + x + " has more than " + k + " " + r + " edges " + ds.union(dsEdges, this._strategy.getABox().doExplanation()) + " " + x.getRNeighborEdges(r).getNeighbors(x));
            }
            if (this._strategy.getABox().doExplanation()) {
                this._strategy.getABox().setClash(Clash.maxCardinality(x, ds.union(dsEdges, this._strategy.getABox().doExplanation()), r.getName(), k));
            } else {
                this._strategy.getABox().setClash(Clash.maxCardinality(x, ds.union(dsEdges, this._strategy.getABox().doExplanation())));
            }
            return false;
        }
        MaxBranch newBranch = new MaxBranch(this._strategy.getABox(), this._strategy, x, r, k, c, mergePairs, ds);
        this._strategy.addBranch(newBranch);
        if (!newBranch.tryNext()) {
            return false;
        }
        _logger.fine(() -> "hasMore: " + (n > k + 1));
        return n > k + 1;
    }

    private DependencySet findMergeNodes(Set<Node> neighbors, Individual node, List<NodeMerge> pairs) {
        DependencySet ds = DependencySet.INDEPENDENT;
        ArrayList<Node> nodes = new ArrayList<Node>(neighbors);
        for (int i = 0; i < nodes.size(); ++i) {
            Node y = (Node)nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node x = (Node)nodes.get(j);
                if (y.isDifferent(x)) {
                    ds = ds.union(y.getDifferenceDependency(x), this._strategy.getABox().doExplanation());
                    continue;
                }
                if (x.getNominalLevel() < y.getNominalLevel()) {
                    pairs.add(new NodeMerge(y, x));
                    continue;
                }
                if (y.isNominal()) {
                    pairs.add(new NodeMerge(x, y));
                    continue;
                }
                if (y.hasSuccessor(node)) {
                    pairs.add(new NodeMerge(x, y));
                    continue;
                }
                pairs.add(new NodeMerge(y, x));
            }
        }
        return ds;
    }

    public void applyFunctionalMaxRule(Individual x, Role s, ATermAppl c, DependencySet dsParam) {
        DependencySet ds = dsParam;
        Set<Role> functionalSupers = s.getFunctionalSupers();
        if (functionalSupers.isEmpty()) {
            functionalSupers = SetUtils.singleton(s);
        }
        block0: for (Role r : functionalSupers) {
            Edge edge;
            int edgeIndex;
            Set<Node> neighbors;
            EdgeList edges;
            if (OpenlletOptions.USE_TRACING) {
                ds = ds.union(s.getExplainSuper((ATerm)r.getName()), this._strategy.getABox().doExplanation()).union(r.getExplainFunctional(), this._strategy.getABox().doExplanation());
            }
            if ((edges = x.getRNeighborEdges(r)).size() <= 1 || (neighbors = edges.getFilteredNeighbors(x, c)).size() <= 1) continue;
            Node head = null;
            int edgeCount = edges.size();
            for (edgeIndex = 0; edgeIndex < edgeCount; ++edgeIndex) {
                edge = (Edge)edges.get(edgeIndex);
                head = edge.getNeighbor(x);
                if (head.isPruned() || !neighbors.contains(head)) continue;
                ds = ds.union(edge.getDepends(), this._strategy.getABox().doExplanation());
                ds = ds.union(head.getDepends((ATerm)c), this._strategy.getABox().doExplanation());
                ds = ds.union(r.getExplainSubOrInv(edge.getRole()), this._strategy.getABox().doExplanation());
                break;
            }
            ++edgeIndex;
            while (edgeIndex < edgeCount) {
                edge = (Edge)edges.get(edgeIndex);
                Node next = edge.getNeighbor(x);
                if (!next.isPruned() && neighbors.contains(next) && head != null && !head.isSame(next)) {
                    ds = ds.union(edge.getDepends(), this._strategy.getABox().doExplanation());
                    ds = ds.union(next.getDepends((ATerm)c), this._strategy.getABox().doExplanation());
                    ds = ds.union(r.getExplainSubOrInv(edge.getRole()), this._strategy.getABox().doExplanation());
                    if (next.isDifferent(head)) {
                        ds = ds.union(head.getDepends((ATerm)c), this._strategy.getABox().doExplanation());
                        ds = ds.union(next.getDepends((ATerm)c), this._strategy.getABox().doExplanation());
                        ds = ds.union(next.getDifferenceDependency(head), this._strategy.getABox().doExplanation());
                        if (r.isFunctional()) {
                            this._strategy.getABox().setClash(Clash.functionalCardinality(x, ds, r.getName()));
                            continue block0;
                        }
                        this._strategy.getABox().setClash(Clash.maxCardinality(x, ds, r.getName(), 1));
                        continue block0;
                    }
                    if (x.isNominal() && head.isBlockable() && next.isBlockable() && head.hasSuccessor(x) && next.hasSuccessor(x)) {
                        Individual newNominal = this._strategy.createFreshIndividual(null, ds);
                        this._strategy.addEdge(x, r, newNominal, ds);
                        continue block0;
                    }
                    if (next.getNominalLevel() < head.getNominalLevel() || !head.isNominal() && next.hasSuccessor(x)) {
                        Node temp = head;
                        head = next;
                        next = temp;
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("FUNC: " + x + " for prop " + r + " merge " + next + " -> " + head + " " + ds);
                    }
                    this._strategy.mergeTo(next, head, ds);
                    if (this._strategy.getABox().isClosed()) {
                        return;
                    }
                    if (head.isPruned()) {
                        ds = ds.union(head.getMergeDependency(true), this._strategy.getABox().doExplanation());
                        head = head.getSame();
                    }
                }
                ++edgeIndex;
            }
        }
    }
}

