/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.List;
import java.util.logging.Level;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Individual;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.rule.AbstractTableauRule;
import openllet.core.utils.ATermUtils;

public class NominalRule
extends AbstractTableauRule {
    public NominalRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.NOMINAL, AbstractTableauRule.BlockingType.NONE);
    }

    @Override
    public void apply(Individual y) {
        List<ATermAppl> types = y.getTypes(6);
        int size = types.size();
        for (int j = 0; j < size; ++j) {
            ATermAppl nc = types.get(j);
            DependencySet ds = y.getDepends((ATerm)nc);
            if (!OpenlletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) continue;
            this.applyNominalRule(y, nc, ds);
            if (this._strategy.getABox().isClosed()) {
                return;
            }
            if (!y.isMerged()) continue;
            this.apply(y.getSame());
            return;
        }
    }

    private void applyNominalRule(Individual y, ATermAppl nc, DependencySet dsParam) {
        DependencySet ds = dsParam;
        this._strategy.getABox().copyOnWrite();
        ATermAppl nominal = (ATermAppl)nc.getArgument(0);
        Individual z = this._strategy.getABox().getIndividual((ATerm)nominal);
        if (z == null) {
            if (ATermUtils.isAnonNominal(nominal)) {
                z = this._strategy.getABox().addIndividual(nominal, ds);
            } else {
                throw new InternalReasonerException("Nominal " + nominal + " not found in KB!");
            }
        }
        if (z.isMerged()) {
            ds = ds.union(z.getMergeDependency(true), this._strategy.getABox().doExplanation());
            z = z.getSame();
        }
        if (y.isSame(z)) {
            return;
        }
        if (y.isDifferent(z)) {
            ds = ds.union(y.getDifferenceDependency(z), this._strategy.getABox().doExplanation());
            if (this._strategy.getABox().doExplanation()) {
                this._strategy.getABox().setClash(Clash.nominal(y, ds, z.getName()));
            } else {
                this._strategy.getABox().setClash(Clash.nominal(y, ds));
            }
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("NOM:  " + y + " -> " + z);
        }
        this._strategy.mergeTo(y, z, ds);
    }
}

