/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.taxonomy;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.taxonomy.AbstractDefinitionOrder;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.TermFactory;
import org.jgrapht.Graph;
import org.jgrapht.alg.KosarajuStrongConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class JGraphBasedDefinitionOrder
extends AbstractDefinitionOrder {
    private Map<ATermAppl, Set<ATermAppl>> _equivalents;
    private Graph<ATermAppl, DefaultEdge> _graph;

    public JGraphBasedDefinitionOrder(KnowledgeBase kb, Comparator<ATerm> comparator) {
        super(kb, comparator);
    }

    private Set<ATermAppl> createSet() {
        return this._comparator != null ? new TreeSet(this._comparator) : CollectionUtils.makeIdentitySet();
    }

    private Queue<ATermAppl> createQueue() {
        return this._comparator != null ? new PriorityQueue(10, this._comparator) : new LinkedList();
    }

    private boolean addEquivalent(ATermAppl key, ATermAppl value) {
        Set<ATermAppl> values = this._equivalents.get(key);
        if (values == null) {
            values = this.createSet();
            this._equivalents.put(key, values);
        }
        return values.add(value);
    }

    private Set<ATermAppl> getAllEquivalents(ATermAppl key) {
        Set<ATermAppl> values = this._equivalents.get(key);
        if (values != null) {
            values.add(key);
        } else {
            values = Collections.singleton(key);
        }
        return values;
    }

    private Set<ATermAppl> getEquivalents(ATermAppl key) {
        Set<ATermAppl> values = this._equivalents.get(key);
        return values != null ? values : Collections.emptySet();
    }

    @Override
    protected void initialize() {
        this._equivalents = CollectionUtils.makeIdentityMap();
        this._graph = new DefaultDirectedGraph(DefaultEdge.class);
        this._graph.addVertex((Object)TermFactory.TOP);
        for (ATermAppl c : this._kb.getClasses()) {
            this._graph.addVertex((Object)c);
        }
    }

    @Override
    protected void addUses(ATermAppl c, ATermAppl usedByC) {
        if (c.equals(TermFactory.TOP)) {
            this.addEquivalent(TermFactory.TOP, usedByC);
        } else if (!c.equals(usedByC)) {
            this._graph.addEdge((Object)c, (Object)usedByC);
        }
    }

    @Override
    protected Set<ATermAppl> computeCycles() {
        Set<ATermAppl> cyclicConcepts = CollectionUtils.makeIdentitySet();
        cyclicConcepts.addAll(this.getEquivalents(TermFactory.TOP));
        KosarajuStrongConnectivityInspector scInspector = new KosarajuStrongConnectivityInspector(this._graph);
        List sccList = scInspector.stronglyConnectedSets();
        for (Set scc : sccList) {
            if (scc.size() == 1) continue;
            cyclicConcepts.addAll(scc);
            this.collapseCycle(scc);
        }
        return cyclicConcepts;
    }

    private void collapseCycle(Set<ATermAppl> scc) {
        Iterator<ATermAppl> i = scc.iterator();
        ATermAppl rep = i.next();
        while (i.hasNext()) {
            ATermAppl node = i.next();
            this.addEquivalent(rep, node);
            for (DefaultEdge edge : this._graph.incomingEdgesOf((Object)node)) {
                ATermAppl incoming = (ATermAppl)this._graph.getEdgeSource((Object)edge);
                if (incoming.equals(rep)) continue;
                this._graph.addEdge((Object)incoming, (Object)rep);
            }
            for (DefaultEdge edge : this._graph.outgoingEdgesOf((Object)node)) {
                ATermAppl outgoing = (ATermAppl)this._graph.getEdgeTarget((Object)edge);
                if (outgoing.equals(rep)) continue;
                this._graph.addEdge((Object)rep, (Object)outgoing);
            }
            this._graph.removeVertex((Object)node);
        }
    }

    @Override
    protected List<ATermAppl> computeDefinitionOrder() {
        List<ATermAppl> definitionOrder = CollectionUtils.makeList();
        definitionOrder.add(TermFactory.TOP);
        definitionOrder.addAll(this.getEquivalents(TermFactory.TOP));
        this._graph.removeVertex((Object)TermFactory.TOP);
        this.destructiveTopologocialSort(definitionOrder);
        definitionOrder.add(TermFactory.BOTTOM);
        return definitionOrder;
    }

    public void destructiveTopologocialSort(List<ATermAppl> nodesSorted) {
        Queue<ATermAppl> nodesPending = this.createQueue();
        for (ATermAppl node : this._graph.vertexSet()) {
            if (this._graph.outDegreeOf((Object)node) != 0) continue;
            nodesPending.add(node);
        }
        while (!nodesPending.isEmpty()) {
            ATermAppl node = nodesPending.remove();
            assert (this._graph.outDegreeOf((Object)node) == 0);
            nodesSorted.addAll(this.getAllEquivalents(node));
            for (DefaultEdge edge : this._graph.incomingEdgesOf((Object)node)) {
                ATermAppl source = (ATermAppl)this._graph.getEdgeSource((Object)edge);
                if (this._graph.outDegreeOf((Object)source) != 1) continue;
                nodesPending.add(source);
            }
            this._graph.removeVertex((Object)node);
        }
        assert (this._graph.vertexSet().isEmpty()) : "Failed to sort elements: " + this._graph.vertexSet();
    }
}

