/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.taxonomy.printer;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyUtils;
import openllet.core.taxonomy.printer.TaxonomyPrinter;
import openllet.core.utils.ATermUtils;

public class RDFXMLTaxonomyPrinter
implements TaxonomyPrinter<ATermAppl> {
    public static final String OWL_EQUIVALENT_CLASS = "owl:equivalentClass";
    public static final String RDFS_SUB_CLASS_OF = "rdfs:subClassOf";
    public static final String RDF_TYPE = "rdf:type";
    protected boolean onlyDirectSubclass = true;
    private Taxonomy<ATermAppl> _taxonomyImpl;
    private PrintWriter _out;
    private Set<ATermAppl> _visited;

    @Override
    public void print(Taxonomy<ATermAppl> taxonomy) {
        this.print(taxonomy, new PrintWriter(System.out));
    }

    @Override
    public void print(Taxonomy<ATermAppl> taxonomy, PrintWriter out) {
        this._taxonomyImpl = taxonomy;
        this._out = out;
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println();
        out.println("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" ");
        out.println("         xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" ");
        out.println("         xmlns:owl=\"http://www.w3.org/2002/07/owl#\"> ");
        out.println();
        this.printTree();
        out.println();
        out.println("</rdf:RDF>");
        out.flush();
    }

    protected void printTree() {
        this._visited = new HashSet<ATermAppl>();
        this._visited.add(ATermUtils.BOTTOM);
        this.printTree(ATermUtils.TOP);
        this.printTree(ATermUtils.BOTTOM);
        for (ATermAppl c : this._taxonomyImpl.getClasses()) {
            this.printTree(c);
        }
    }

    protected void printTree(ATermAppl c) {
        if (this._visited.contains(c)) {
            return;
        }
        Set<ATermAppl> eqClasses = ATermUtils.primitiveOrBottom(this._taxonomyImpl.getEquivalents(c));
        this._visited.add(c);
        this._visited.addAll(eqClasses);
        this.printConceptDefinition(c, false);
        for (ATermAppl aTermAppl : eqClasses) {
            this.printTriple(OWL_EQUIVALENT_CLASS, aTermAppl);
        }
        if (!c.equals(ATermUtils.BOTTOM)) {
            Set<Set<ATermAppl>> supers = this._taxonomyImpl.getSupers(c, this.onlyDirectSubclass);
            Iterator iterator = supers.iterator();
            while (iterator.hasNext()) {
                Set equivalenceSet = (Set)iterator.next();
                ATermAppl subClass = ATermUtils.primitiveOrBottom(equivalenceSet).iterator().next();
                this.printTriple(RDFS_SUB_CLASS_OF, subClass);
            }
        }
        this._out.println("</owl:Class>");
        for (ATermAppl aTermAppl : eqClasses) {
            this._out.println();
            this.printConceptDefinition(aTermAppl, true);
        }
        this._out.println();
        Set<ATermAppl> instances = TaxonomyUtils.getDirectInstances(this._taxonomyImpl, c);
        for (ATermAppl instance : instances) {
            if (ATermUtils.isBnode(instance)) {
                return;
            }
            this._out.print("<rdf:Description rdf:about=\"");
            this._out.print(instance.getName());
            this._out.println("\">");
            this.printTriple(RDF_TYPE, c);
            this._out.println("</rdf:Description>");
            this._out.println();
        }
    }

    protected void printTriple(String predicate, ATermAppl c2) {
        this._out.print("   <" + predicate);
        this._out.print(" rdf:resource=\"");
        this.printConcept(c2);
        this._out.println("\"/> ");
    }

    protected void printConceptDefinition(ATermAppl c, boolean close) {
        this._out.print("<owl:Class rdf:about=\"");
        this.printConcept(c);
        if (close) {
            this._out.println("\"/> ");
        } else {
            this._out.println("\"> ");
        }
    }

    protected void printConcept(ATermAppl c) {
        String uri = null;
        uri = c.equals(ATermUtils.TOP) ? "http://www.w3.org/2002/07/owl#Thing" : (c.equals(ATermUtils.BOTTOM) ? "http://www.w3.org/2002/07/owl#Nothing" : c.getName());
        this._out.print(uri);
    }
}

