/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

public class IdentityHashSet<T>
extends AbstractSet<T>
implements Set<T>,
Cloneable {
    private static final Object VALUE = new Object();
    private transient IdentityHashMap<T, Object> _map;

    public IdentityHashSet() {
        this._map = new IdentityHashMap();
    }

    public IdentityHashSet(Collection<? extends T> c) {
        this._map = new IdentityHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public IdentityHashSet(int size) {
        this._map = new IdentityHashMap(size);
    }

    @Override
    public boolean add(T element) {
        return this._map.put(element, VALUE) == null;
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Object clone() {
        try {
            IdentityHashSet newSet = (IdentityHashSet)super.clone();
            newSet._map = (IdentityHashMap)this._map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this._map.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public boolean remove(Object element) {
        return this._map.remove(element) != VALUE;
    }

    @Override
    public int size() {
        return this._map.size();
    }
}

