/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import openllet.core.utils.SetUtils;

public class MultiMapUtils {
    public static <K, V> boolean add(Map<K, Set<V>> map, K key, V value) {
        Set<Object> values = map.get(key);
        if (values == null) {
            values = SetUtils.create();
            map.put(key, values);
        }
        return values.add(value);
    }

    public static <K, V> boolean addAll(Map<K, Set<V>> map, K key, Collection<V> value) {
        Set<Object> values = map.get(key);
        if (values == null) {
            values = SetUtils.create();
            map.put(key, values);
        }
        return values.addAll(value);
    }

    public static <K, V> boolean contains(Map<K, Set<V>> map, K key, V value) {
        Set<V> values = map.get(key);
        return values != null && values.contains(value);
    }

    public static <K, V> Set<V> get(Map<K, Set<V>> map, K key) {
        Set<V> values = map.get(key);
        return values != null ? values : Collections.emptySet();
    }

    public static <K, V> boolean remove(Map<K, Set<V>> map, K key, V value) {
        boolean removed = false;
        Set<V> values = map.get(key);
        if (values != null) {
            removed = values.remove(value);
            if (values.isEmpty()) {
                map.remove(key);
            }
        }
        return removed;
    }
}

