/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.util.logging.Logger;
import openllet.core.exceptions.TimeoutException;
import openllet.core.exceptions.TimerInterruptedException;
import openllet.core.utils.DurationFormat;
import openllet.shared.tools.Log;

public class Timer {
    private static final Logger _logger = Log.getLogger(Timer.class);
    public static final long NOT_STARTED = -1L;
    public static final long NO_TIMEOUT = 0L;
    private final String _name;
    private long _totalTime;
    private long _startTime;
    private long _count;
    private long _startCount;
    private long _timeout;
    private long _lastTime;
    private boolean interrupted;
    private final Timer _parent;

    public Timer() {
        this("", null);
    }

    public Timer(String name) {
        this(name, null);
    }

    public Timer(String name, Timer parent) {
        this._name = name;
        this._parent = parent;
        this._timeout = 0L;
        this.reset();
    }

    public void add(Timer timer) {
        this._totalTime += timer._totalTime;
        this._count += timer._count;
    }

    public void start() {
        if (this._startCount == 0L) {
            this._startTime = System.currentTimeMillis();
        }
        ++this._startCount;
    }

    public long stop() {
        if (!this.isStarted()) {
            _logger.fine(() -> String.format("Ignoring attempt to stop a timer (\"%s\") that is not running. Timer results are incorrect for multi-threaded code.", this._name));
            return -9223372036854775807L;
        }
        --this._startCount;
        if (!this.isStarted()) {
            this._lastTime = System.currentTimeMillis() - this._startTime;
            this._totalTime += this._lastTime;
            this._startTime = -1L;
            ++this._count;
            return this._lastTime;
        }
        return -1L;
    }

    public void reset() {
        this._totalTime = 0L;
        this._startTime = -1L;
        this._startCount = 0L;
        this._count = 0L;
        this.interrupted = false;
    }

    public void restart() {
        if (this.isStarted()) {
            this.stop();
        }
        this.start();
    }

    public void check() throws TimeoutException, TimerInterruptedException {
        if (this.interrupted) {
            this.interrupted = false;
            throw new TimerInterruptedException("Timer " + this.getName() + " interrupted.");
        }
        long elapsed = this.getElapsed();
        if (this._timeout != 0L && elapsed > this._timeout) {
            throw new TimeoutException("Running time of " + this._name + " exceeded timeout of " + this._timeout);
        }
        if (this._parent != null) {
            this._parent.check();
        }
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public boolean isStarted() {
        return this._startCount > 0L;
    }

    public String getName() {
        return this._name;
    }

    public long getElapsed() {
        return this.isStarted() ? System.currentTimeMillis() - this._startTime : 0L;
    }

    public long getTotal() {
        return this._totalTime;
    }

    public long getCount() {
        return this._count;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public double getAverage() {
        return (double)this._totalTime / (this._count == 0L ? 1.0 : (double)this._count);
    }

    public long getLast() {
        return this._lastTime;
    }

    public void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Cannot set the timeout to a negative value!");
        }
        this._timeout = timeout;
    }

    public String toString() {
        if (this._startCount > 0L) {
            return "Timer " + this._name + " Avg: " + this.getAverage() + " Count: " + this._count + " Total: " + this.getTotal() + " Still running: " + this._startCount;
        }
        return "Timer " + this._name + " Avg: " + this.getAverage() + " Count: " + this._count + " Total: " + this.getTotal();
    }

    public Timer getParent() {
        return this._parent;
    }

    public String format() {
        return DurationFormat.LONG.format(this.getTotal() + this.getElapsed());
    }
}

