/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import openllet.core.OpenlletOptions;
import openllet.core.output.TableData;
import openllet.core.utils.AlphaNumericComparator;
import openllet.core.utils.Timer;

public class Timers {
    private final Map<String, Timer> _timers = new LinkedHashMap<String, Timer>();
    public final Timer _mainTimer = this.createTimer("main");
    private static Function<String, UnsupportedOperationException> _doesNotExist = name -> new UnsupportedOperationException("Timer " + name + " does not exist!");

    public Timers() {
        this._mainTimer.start();
    }

    public void addAll(Timers other) {
        for (Map.Entry<String, Timer> entry : other._timers.entrySet()) {
            String name = entry.getKey();
            Timer otherTimer = entry.getValue();
            Optional<Timer> thisTimer = this.getTimer(name);
            if (thisTimer.isPresent()) {
                thisTimer.get().add(otherTimer);
                continue;
            }
            this._timers.put(name, otherTimer);
        }
    }

    public Timer createTimer(String name) {
        Timer t = new Timer(name, this._mainTimer);
        this._timers.put(name, t);
        return t;
    }

    public Optional<Timer> startTimer(String name) {
        if (OpenlletOptions.USE_THREADED_KERNEL) {
            return Optional.empty();
        }
        Timer t = this.getTimer(name).orElseGet(() -> this.createTimer(name));
        t.start();
        return Optional.of(t);
    }

    public void execute(String name, Consumer<Timers> consumer) {
        if (OpenlletOptions.USE_THREADED_KERNEL) {
            consumer.accept(this);
            return;
        }
        Optional<Timer> timer = this.startTimer(name);
        consumer.accept(this);
        timer.ifPresent(t -> t.stop());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RESULT> RESULT execute(String name, Supplier<RESULT> producer) {
        if (OpenlletOptions.USE_THREADED_KERNEL) {
            return producer.get();
        }
        Optional<Timer> timer = this.startTimer(name);
        try {
            RESULT RESULT = producer.get();
            return RESULT;
        }
        finally {
            timer.ifPresent(Timer::stop);
        }
    }

    public void checkTimer(String name) {
        this.getTimer(name).orElseThrow(() -> _doesNotExist.apply(name)).check();
    }

    public void resetTimer(String name) {
        this.getTimer(name).orElseThrow(() -> _doesNotExist.apply(name)).reset();
    }

    public void interrupt() {
        this._mainTimer.interrupt();
    }

    public void setTimeout(String name, long timeout) {
        this.getTimer(name).orElseGet(() -> this.createTimer(name)).setTimeout(timeout);
    }

    public void stopTimer(String name) {
        this.getTimer(name).orElseThrow(() -> _doesNotExist.apply(name)).stop();
    }

    public void resetAll() {
        for (Timer timer : this._timers.values()) {
            timer.reset();
        }
        this._mainTimer.start();
    }

    public long getTimerTotal(String name) {
        return this.getTimer(name).map(t -> t.getTotal()).orElse(0L);
    }

    public double getTimerAverage(String name) {
        return this.getTimer(name).map(t -> t.getAverage()).orElse(0.0);
    }

    public Optional<Timer> getTimer(String name) {
        return Optional.ofNullable(this._timers.get(name));
    }

    public Collection<Timer> getTimers() {
        return this._timers.values();
    }

    public void print() {
        this.print(false);
    }

    public void print(Writer pw) {
        this.print(pw, false, "Total");
    }

    public void print(boolean shortForm) {
        this.print(shortForm, "Total");
    }

    public void print(boolean shortForm, String sortBy) {
        this.print(new PrintWriter(System.out), shortForm, sortBy);
    }

    public void print(Writer pw, boolean shortForm, String sortBy) {
        boolean[] blArray;
        String[] stringArray;
        if (shortForm) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "Name";
            stringArray = stringArray2;
            stringArray2[1] = "Total (ms)";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "Name";
            stringArray3[1] = "Count";
            stringArray3[2] = "Avg";
            stringArray = stringArray3;
            stringArray3[3] = "Total (ms)";
        }
        String[] colNames = stringArray;
        if (shortForm) {
            boolean[] blArray2 = new boolean[2];
            blArray2[0] = false;
            blArray = blArray2;
            blArray2[1] = true;
        } else {
            boolean[] blArray3 = new boolean[4];
            blArray3[0] = false;
            blArray3[1] = true;
            blArray3[2] = true;
            blArray = blArray3;
            blArray3[3] = true;
        }
        boolean[] alignment = blArray;
        ArrayList<Timer> list = new ArrayList<Timer>(this._timers.values());
        if (sortBy != null) {
            Collections.sort(list, (o1, o2) -> {
                if (sortBy.equalsIgnoreCase("Total")) {
                    long t1 = o1.getTotal();
                    long t2 = o2.getTotal();
                    if (t1 == 0L) {
                        t1 = o1.getElapsed();
                    }
                    if (t2 == 0L) {
                        t2 = o2.getElapsed();
                    }
                    return (int)(t2 - t1);
                }
                if (sortBy.equalsIgnoreCase("Avg")) {
                    return (int)(o2.getAverage() - o1.getAverage());
                }
                if (sortBy.equalsIgnoreCase("Count")) {
                    return (int)(o2.getCount() - o1.getCount());
                }
                return AlphaNumericComparator.CASE_INSENSITIVE.compare(o1, o2);
            });
        }
        DecimalFormat nf = new DecimalFormat("0.00");
        TableData table = new TableData(Arrays.asList(colNames));
        table.setAlignment(alignment);
        for (Timer timer : list) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(timer.getName());
            if (!shortForm) {
                row.add(String.valueOf(timer.getCount()));
                row.add(nf.format(timer.getAverage()));
            }
            if (timer.isStarted()) {
                row.add(String.valueOf(timer.getElapsed()));
            } else {
                row.add(String.valueOf(timer.getTotal()));
            }
            table.add(row);
        }
        table.print(pw);
    }

    public String toString() {
        return this._timers.values().toString();
    }
}

