/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils.fsm;

import java.util.HashSet;
import java.util.Set;
import openllet.core.boxes.rbox.Role;
import openllet.core.utils.fsm.Transition;

public class State<T> {
    private static int next_unused_name = 0;
    private int _name = next_unused_name++;
    private final Set<Transition<T>> _transitions = new HashSet<Transition<T>>();

    public void addTransition(T symbol, State<T> s) {
        if (symbol == null || s == null) {
            throw new NullPointerException();
        }
        if (!(symbol instanceof Role)) {
            throw new ClassCastException();
        }
        Transition<T> t = new Transition<T>(symbol, s);
        this._transitions.add(t);
    }

    public void addTransition(State<T> s) {
        if (s == null) {
            throw new NullPointerException();
        }
        Transition<T> t = new Transition<T>(s);
        this._transitions.add(t);
    }

    public Set<Transition<T>> getTransitions() {
        return this._transitions;
    }

    public State<T> move(T symbol) {
        for (Transition<T> t : this._transitions) {
            if (!t.hasName(symbol)) continue;
            return t.getTo();
        }
        return null;
    }

    public int getName() {
        return this._name;
    }

    public void setName(int i) {
        this._name = i;
    }

    public String toString() {
        return String.valueOf(this._name);
    }
}

