/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils.fsm;

import openllet.core.utils.fsm.State;

public class Transition<T> {
    private static final Object EPSILON = null;
    private final T _name;
    private volatile State<T> _to;

    public Transition(State<T> t) {
        this._name = EPSILON;
        this._to = t;
    }

    public Transition(T name, State<T> to) {
        this._name = name;
        this._to = to;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._to == null ? 0 : this._to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transition other = (Transition)obj;
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        return !(this._to == null ? other._to != null : !this._to.equals(other._to));
    }

    public boolean isEpsilon() {
        return this._name == EPSILON;
    }

    public State<T> getTo() {
        return this._to;
    }

    public void setTo(State<T> to) {
        this._to = to;
    }

    public T getName() {
        return this._name;
    }

    public boolean hasName(T c) {
        return this._name == EPSILON ? c == EPSILON : (c == EPSILON ? false : this._name.equals(c));
    }

    public String toString() {
        return (this._name == EPSILON ? "epsilon" : this._name.toString()) + " -> " + this._to.getName();
    }
}

