/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import openllet.core.utils.iterator.IteratorUtils;

public abstract class NestedIterator<Outer, Inner>
implements Iterator<Inner> {
    private volatile Iterator<? extends Outer> _outerIterator;
    private volatile Iterator<? extends Inner> _innerIterator;

    public NestedIterator(Iterable<? extends Outer> outerIterable) {
        this(outerIterable.iterator());
    }

    public NestedIterator(Iterator<? extends Outer> outerIterator) {
        this._outerIterator = outerIterator;
        this.findIterator();
    }

    private void findIterator() {
        while (this._outerIterator.hasNext()) {
            Outer subj = this._outerIterator.next();
            this._innerIterator = this.getInnerIterator(subj);
            if (!this._innerIterator.hasNext()) continue;
            return;
        }
        this._innerIterator = IteratorUtils.emptyIterator();
    }

    public abstract Iterator<? extends Inner> getInnerIterator(Outer var1);

    @Override
    public boolean hasNext() {
        return this._innerIterator.hasNext();
    }

    @Override
    public Inner next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Inner value = this._innerIterator.next();
        if (!this._innerIterator.hasNext()) {
            this.findIterator();
        }
        return value;
    }

    @Override
    public void remove() {
        this._innerIterator.remove();
    }
}

