/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.engine;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.utils.ATermUtils;
import openllet.query.sparqldl.engine.AbstractABoxEngineWrapper;
import openllet.query.sparqldl.engine.QueryEngine;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.QueryPredicate;
import openllet.query.sparqldl.model.QueryResult;
import openllet.query.sparqldl.model.QueryResultImpl;
import openllet.query.sparqldl.model.ResultBinding;
import openllet.query.sparqldl.model.ResultBindingImpl;
import openllet.shared.tools.Log;

public class OptimizedQueryEngine2
extends AbstractABoxEngineWrapper {
    public static final Logger _logger = Log.getLogger(QueryEngine.class);
    private QueryResult _results;
    private KnowledgeBase _kb;

    @Override
    public boolean supports(Query q) {
        return !q.getDistVars().isEmpty();
    }

    private void exec(Query q, ResultBinding binding, boolean first) {
        HashSet instances;
        if (q.getDistVars().isEmpty()) {
            this._results.add(binding);
            return;
        }
        Iterator<ATermAppl> i = q.getDistVars().iterator();
        ATermAppl var = i.next();
        Set<ATermAppl> empty = Collections.emptySet();
        ATermAppl clazz = q.rollUpTo(var, empty, false);
        _logger.fine(() -> "Rolling up " + var + " to " + clazz);
        if (first) {
            instances = new HashSet(this._kb.getIndividuals());
            for (QueryAtom atom : q.findAtoms(QueryPredicate.PropertyValue, var, null, null)) {
                instances.retainAll(this._kb.retrieveIndividualsWithProperty(atom.getArguments().get(1)));
            }
            for (QueryAtom atom : q.findAtoms(QueryPredicate.PropertyValue, null, null, var)) {
                instances.retainAll(this._kb.retrieveIndividualsWithProperty(ATermUtils.makeInv((ATermAppl)atom.getArguments().get(1))));
            }
        } else {
            instances = this._kb.getInstances(clazz);
        }
        for (ATermAppl b : instances) {
            _logger.fine(() -> "trying " + var + " --> " + b);
            ResultBinding newBinding = binding.duplicate();
            newBinding.setValue(var, b);
            Query q2 = q.apply(newBinding);
            this.exec(q2, newBinding, false);
        }
    }

    @Override
    public QueryResult execABoxQuery(Query q) {
        this._results = new QueryResultImpl(q);
        this._kb = q.getKB();
        long satCount = this._kb.getABox().getStats()._satisfiabilityCount;
        long consCount = this._kb.getABox().getStats()._consistencyCount;
        this.exec(q, new ResultBindingImpl(), true);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Total satisfiability operations: " + (this._kb.getABox().getStats()._satisfiabilityCount - satCount));
            _logger.fine("Total consistency operations: " + (this._kb.getABox().getStats()._consistencyCount - consCount));
            _logger.fine("Results of ABox query : " + this._results);
        }
        return this._results;
    }
}

