/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import openllet.aterm.ATermAppl;
import openllet.core.utils.ATermUtils;
import openllet.query.sparqldl.model.Core;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.QueryAtomImpl;
import openllet.query.sparqldl.model.QueryPredicate;
import openllet.query.sparqldl.model.ResultBinding;

public class CoreImpl
extends QueryAtomImpl
implements Core {
    private List<ATermAppl> _distVars = null;
    private List<ATermAppl> _consts = null;
    private Collection<ATermAppl> _undistVars = null;
    private final Collection<QueryAtom> _atoms;

    public CoreImpl(List<ATermAppl> arguments, Collection<ATermAppl> uv, Collection<QueryAtom> atoms) {
        super(QueryPredicate.UndistVarCore, arguments);
        this._atoms = atoms;
        this._undistVars = uv;
    }

    private void setup() {
        this._distVars = new ArrayList<ATermAppl>();
        this._consts = new ArrayList<ATermAppl>();
        for (ATermAppl a : this._arguments) {
            if (ATermUtils.isVar((ATermAppl)a)) {
                this._distVars.add(a);
                continue;
            }
            this._consts.add(a);
        }
    }

    @Override
    public Collection<ATermAppl> getConstants() {
        if (this._consts == null) {
            this.setup();
        }
        return this._consts;
    }

    @Override
    public Collection<ATermAppl> getDistVars() {
        if (this._distVars == null) {
            this.setup();
        }
        return this._distVars;
    }

    @Override
    public Collection<ATermAppl> getUndistVars() {
        if (this._undistVars == null) {
            this.setup();
        }
        return this._undistVars;
    }

    @Override
    public QueryAtom apply(ResultBinding binding) {
        if (this.isGround()) {
            return this;
        }
        ArrayList<ATermAppl> newArguments = new ArrayList<ATermAppl>();
        for (ATermAppl a : this._arguments) {
            if (binding.isBound(a)) {
                newArguments.add(binding.getValue(a));
                continue;
            }
            newArguments.add(a);
        }
        ArrayList<QueryAtom> newAtoms = new ArrayList<QueryAtom>();
        for (QueryAtom a : this._atoms) {
            newAtoms.add(a.apply(binding));
        }
        return new CoreImpl(newArguments, this._undistVars, newAtoms);
    }

    @Override
    public int hashCode() {
        return this._arguments.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoreImpl other = (CoreImpl)obj;
        return this._arguments.equals(other._arguments);
    }
}

