/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import openllet.aterm.ATermAppl;
import openllet.query.sparqldl.model.QueryResult;
import openllet.query.sparqldl.model.ResultBinding;
import openllet.query.sparqldl.model.ResultBindingImpl;

public class MultiQueryResults
implements QueryResult {
    private final List<ATermAppl> _resultVars;
    private final List<QueryResult> _queryResults;
    private int _size;

    public MultiQueryResults(List<ATermAppl> resultVars, List<QueryResult> queryResults) {
        this._resultVars = resultVars;
        this._queryResults = queryResults;
        this._size = 1;
        for (QueryResult result : queryResults) {
            this._size *= result.size();
        }
    }

    @Override
    public void add(ResultBinding binding) {
        throw new UnsupportedOperationException("MultiQueryResults do not support addition!");
    }

    @Override
    public List<ATermAppl> getResultVars() {
        return this._resultVars;
    }

    @Override
    public boolean isDistinct() {
        for (QueryResult result : this._queryResults) {
            if (result.isDistinct()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public Iterator<ResultBinding> iterator() {
        return new Iterator<ResultBinding>(){
            private final List<Iterator<ResultBinding>> iterators = new ArrayList<Iterator<ResultBinding>>();
            private final List<ResultBinding> bindings = new ArrayList<ResultBinding>();
            private boolean hasNext = this.init();

            private boolean init() {
                for (QueryResult result : MultiQueryResults.this._queryResults) {
                    Iterator iterator = result.iterator();
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    this.iterators.add(iterator);
                    this.bindings.add((ResultBinding)iterator.next());
                }
                return true;
            }

            private void findNext() {
                ListIterator<Iterator<ResultBinding>> i = this.iterators.listIterator();
                for (int index = 0; index < this.iterators.size(); ++index) {
                    Iterator<ResultBinding> iterator = i.next();
                    if (iterator.hasNext()) {
                        this.bindings.set(index, iterator.next());
                        return;
                    }
                    if (index == this.iterators.size() - 1) {
                        this.hasNext = false;
                        return;
                    }
                    iterator = ((QueryResult)MultiQueryResults.this._queryResults.get(index)).iterator();
                    i.set(iterator);
                    this.bindings.set(index, iterator.next());
                }
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public ResultBinding next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ResultBindingImpl result = new ResultBindingImpl();
                for (ResultBinding binding : this.bindings) {
                    result.setValues(binding);
                }
                this.findNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this._size;
    }
}

