/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.DoubleCollection;
import com.carrotsearch.hppcrt.DoubleLookupContainer;
import com.carrotsearch.hppcrt.cursors.DoubleCursor;
import com.carrotsearch.hppcrt.predicates.DoublePredicate;
import java.util.Arrays;

public abstract class AbstractDoubleCollection
implements DoubleCollection {
    protected DoubleLookupContainer testContainer;
    protected DoublePredicate testPredicate;
    protected DoublePredicate containsTestPredicate = new DoublePredicate(){

        public final boolean apply(double k) {
            return AbstractDoubleCollection.this.testContainer.contains(k);
        }
    };
    protected DoublePredicate containsNegateTestPredicate = new DoublePredicate(){

        public final boolean apply(double k) {
            return !AbstractDoubleCollection.this.testContainer.contains(k);
        }
    };
    protected DoublePredicate negatePredicate = new DoublePredicate(){

        public final boolean apply(double k) {
            return !AbstractDoubleCollection.this.testPredicate.apply(k);
        }
    };

    public int removeAll(DoubleLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    public int retainAll(DoubleLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    public int retainAll(DoublePredicate predicate) {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

    public double[] toArray(double[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        int i = 0;
        for (DoubleCursor c : this) {
            target[i++] = c.value;
        }
        return target;
    }

    public double[] toArray() {
        try {
            return this.toArray(new double[this.size()]);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate a '%s'.toArray() of  %d elements", (Throwable)e, this.getClass().toString(), this.size());
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

