/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.logging;

import org.semanticweb.elk.util.logging.ElkTimer;
import org.semanticweb.elk.util.logging.LogLevel;
import org.semanticweb.elk.util.logging.LoggerWrap;
import org.slf4j.Logger;

public class Statistics {
    static final int megaBytes = 0x100000;

    public static void logOperationStart(String operationName, Logger logger) {
        Statistics.logOperationStart(operationName, logger, LogLevel.DEBUG);
    }

    public static void logOperationStart(String operationName, Logger logger, LogLevel priority) {
        if (LoggerWrap.isEnabledFor(logger, priority)) {
            LoggerWrap.log(logger, priority, operationName + " started");
            ElkTimer timer = ElkTimer.getNamedTimer(operationName, 2);
            timer.reset();
            timer.start();
        }
    }

    public static void logOperationFinish(String operationName, Logger logger) {
        Statistics.logOperationFinish(operationName, logger, LogLevel.DEBUG);
    }

    public static void logOperationFinish(String operationName, Logger logger, LogLevel priority) {
        if (LoggerWrap.isEnabledFor(logger, priority)) {
            ElkTimer timer = ElkTimer.getNamedTimer(operationName, 2);
            timer.stop();
            LoggerWrap.log(logger, priority, operationName + " took " + timer.getTotalWallTime() / 1000000L + " ms");
        }
    }

    public static void logMemoryUsage(Logger logger) {
        Statistics.logMemoryUsage(logger, LogLevel.DEBUG);
    }

    public static void logMemoryUsage(Logger logger, LogLevel priority) {
        if (LoggerWrap.isEnabledFor(logger, priority)) {
            Runtime runtime = Runtime.getRuntime();
            LoggerWrap.log(logger, priority, "Memory (MB) Used/Total/Max: " + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L + "/" + runtime.totalMemory() / 0x100000L + "/" + runtime.maxMemory() / 0x100000L);
        }
    }
}

