/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import openllet.owlapi.OWLManagementObject;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public interface OWLManagedObject
extends OWLManagementObject {
    public OWLNamedIndividual getMe();

    default public Stream<OWLNamedIndividual> getObjects(IRI property) {
        return this.getObjects(this.getMe(), property);
    }

    default public Optional<OWLNamedIndividual> getObject(IRI property) {
        return this.getObjects(property).findAny();
    }

    default public void updateObject(IRI property, OWLNamedIndividual object) {
        OWLObjectProperty owlProperty = this.getFactory().getOWLObjectProperty(property);
        this.removeObjectPropertyAxiom(owlProperty, this.getMe());
        this.addObjectPropertyAxiom((OWLObjectPropertyExpression)owlProperty, (OWLIndividual)this.getMe(), (OWLIndividual)object);
    }

    default public Set<OWLLiteral> getValues(IRI property) {
        return this.getValues(this.getMe(), property);
    }

    default public Optional<OWLLiteral> getValue(IRI property) {
        Set<OWLLiteral> values = this.getValues(this.getMe(), property);
        return values.isEmpty() ? Optional.empty() : Optional.of(values.iterator().next());
    }

    default public void addObject(IRI property, OWLNamedIndividual object) {
        OWLObjectProperty owlProperty = this.getFactory().getOWLObjectProperty(property);
        this.addObjectPropertyAxiom((OWLObjectPropertyExpression)owlProperty, (OWLIndividual)this.getMe(), (OWLIndividual)object);
    }

    default public void addValue(IRI property, OWLLiteral literal) {
        OWLDataProperty owlProperty = this.getFactory().getOWLDataProperty(property);
        this.addDataPropertyAxiom(owlProperty, (OWLIndividual)this.getMe(), literal);
    }

    default public void addValue(IRI property, String literal) {
        OWLDataProperty owlProperty = this.getFactory().getOWLDataProperty(property);
        this.addDataPropertyAxiom(owlProperty, (OWLIndividual)this.getMe(), literal);
    }

    default public void addValue(IRI property, int literal) {
        OWLDataProperty owlProperty = this.getFactory().getOWLDataProperty(property);
        this.addDataPropertyAxiom(owlProperty, (OWLIndividual)this.getMe(), literal);
    }

    default public void addValue(IRI property, double literal) {
        OWLDataProperty owlProperty = this.getFactory().getOWLDataProperty(property);
        this.addDataPropertyAxiom(owlProperty, (OWLIndividual)this.getMe(), literal);
    }

    default public void updateValue(IRI property, OWLLiteral literal) {
        OWLDataProperty owlProperty = this.getFactory().getOWLDataProperty(property);
        this.removeDataPropertyAxiom(owlProperty, this.getMe());
        this.addDataPropertyAxiom(owlProperty, (OWLIndividual)this.getMe(), literal);
    }

    default public void updateValue(IRI property, String literal) {
        OWLDataProperty owlProperty = this.getFactory().getOWLDataProperty(property);
        this.removeDataPropertyAxiom(owlProperty, this.getMe());
        this.addDataPropertyAxiom(owlProperty, (OWLIndividual)this.getMe(), literal);
    }

    default public void updateValue(IRI property, int literal) {
        OWLDataProperty owlProperty = this.getFactory().getOWLDataProperty(property);
        this.removeDataPropertyAxiom(owlProperty, this.getMe());
        this.addDataPropertyAxiom(owlProperty, (OWLIndividual)this.getMe(), literal);
    }

    default public void updateValue(IRI property, double literal) {
        OWLDataProperty owlProperty = this.getFactory().getOWLDataProperty(property);
        this.removeDataPropertyAxiom(owlProperty, this.getMe());
        this.addDataPropertyAxiom(owlProperty, (OWLIndividual)this.getMe(), literal);
    }
}

