/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.owlapi.OWL;
import openllet.owlapi.OWLException;
import openllet.owlapi.OWLGroup;
import openllet.owlapi.OWLHelper;
import openllet.owlapi.OWLIncrementalFlatFileStorageManagerListener;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OWLManagerGroup
implements OWLGroup {
    private static final Logger _logger = Log.getLogger(OWLManagerGroup.class);
    public volatile Optional<File> _ontologiesDirectory = Optional.empty();
    public volatile OWLOntologyManager _volatileManager = null;
    public volatile OWLOntologyManager _persistentManager = null;
    private volatile OWLIncrementalFlatFileStorageManagerListener _storageListener;

    public OWLManagerGroup() {
    }

    public OWLManagerGroup(File ontologiesDirectory) {
        this.setOntologiesDirectory(ontologiesDirectory);
    }

    public OWLManagerGroup(Optional<OWLOntologyManager> volatileManager, Optional<OWLOntologyManager> storageManager) {
        volatileManager.ifPresent(m -> {
            this._volatileManager = m;
        });
        storageManager.ifPresent(m -> {
            this._persistentManager = m;
        });
    }

    public OWLManagerGroup(OWLOntology ontology) {
        this._volatileManager = ontology.getOWLOntologyManager();
    }

    public Logger getLogger() {
        return _logger;
    }

    @Override
    public boolean setOntologiesDirectory(File directory) {
        this._ontologiesDirectory = Optional.ofNullable(directory);
        return this._ontologiesDirectory.isPresent();
    }

    @Override
    public Optional<File> getOntologiesDirectory() {
        return this._ontologiesDirectory;
    }

    @Override
    public OWLOntologyManager getVolatileManager() {
        if (null == this._volatileManager) {
            this._volatileManager = OWLManager.createConcurrentOWLOntologyManager();
        }
        return this._volatileManager;
    }

    @Override
    public synchronized OWLOntologyManager getPersistentManager() {
        if (null == this._persistentManager) {
            this._persistentManager = OWLManager.createConcurrentOWLOntologyManager();
            if (!this.getOntologiesDirectory().isPresent()) {
                String msg = "You should define a directory for stored ontologies before using stored ontologies.";
                OWLException ex = new OWLException("You should define a directory for stored ontologies before using stored ontologies.");
                Log.error((Logger)this.getLogger(), (String)"You should define a directory for stored ontologies before using stored ontologies.", (Throwable)((Object)ex));
                throw ex;
            }
            try {
                this._storageListener = new OWLIncrementalFlatFileStorageManagerListener(this.getOntologiesDirectory().get(), new File(this.getOntologiesDirectory().get().getPath() + File.separator + "owl.delta"), this);
                this.getPersistentManager().addOntologyChangeListener((OWLOntologyChangeListener)this._storageListener);
            }
            catch (Exception e) {
                throw new OWLException(e);
            }
        }
        return this._persistentManager;
    }

    @Override
    public boolean havePersistentManager() {
        return null != this._persistentManager;
    }

    @Override
    public boolean haveVolatileManager() {
        return null != this._volatileManager;
    }

    @Override
    public void loadDirectory(File directory, OWLOntologyManager manager, BiFunction<OWLOntologyManager, File, Optional<OWLOntology>> loader) {
        if (!directory.exists() && !directory.mkdir()) {
            throw new OWLException("Can't create the directory " + directory + " .");
        }
        if (!directory.isDirectory()) {
            throw new OWLException("The directory parameter must be a true existing directory. " + directory + " isn't.");
        }
        ArrayList<File> loaded = new ArrayList<File>();
        for (File file : directory.listFiles()) {
            if (file.isFile() && file.canRead() && file.getName().endsWith(".owl")) {
                try {
                    _logger.info("loading from " + file);
                    loader.apply(manager, file).ifPresent(ontology -> {
                        OWLHelper.setFormat(ontology);
                        _logger.info(ontology.getOntologyID() + "loaded from " + file);
                    });
                    loaded.add(file);
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "Can't load ontology of file " + file, e);
                }
                continue;
            }
            _logger.info(() -> file + " will not be load.");
        }
        for (File file : loaded) {
            File partFile = new File(file.getAbsolutePath() + ".part");
            if (!partFile.exists() || !partFile.isFile()) continue;
            _logger.info(file + " removing " + partFile);
            partFile.delete();
        }
        for (File file : directory.listFiles()) {
            if (!file.isFile() || !file.canRead() || !file.getName().endsWith(".part")) continue;
            String absolutePath = file.getAbsolutePath();
            int partSize = ".part".length();
            File newName = new File(absolutePath.substring(0, absolutePath.length() - partSize));
            file.renameTo(newName);
            _logger.info((File)file + " rename to " + newName);
            loader.apply(manager, newName).ifPresent(ontology -> {
                OWLHelper.setFormat(ontology);
                _logger.info(ontology.getOntologyID() + "loaded from " + file);
            });
        }
    }

    @Override
    public void loadDirectory(File directory) {
        this.loadDirectory(directory, this.getPersistentManager(), (m, f) -> {
            try {
                return Optional.of(m.loadOntologyFromOntologyDocument(f));
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "Can't load ontology of file " + f, e);
                return Optional.empty();
            }
        });
    }

    @Override
    public String ontology2filename(OWLOntologyID ontId) {
        if (this._ontologiesDirectory.isPresent()) {
            return OWLHelper.ontology2filename(this._ontologiesDirectory.get(), ontId);
        }
        throw new OWLException("Storage directory should be define to enable loading of ontology by iri.");
    }

    @Override
    public String ontology2filename(OWLOntology ontology) {
        return this.ontology2filename(ontology.getOntologyID());
    }

    @Override
    public void check(OWLOntologyManager manager) {
        if (manager == this._volatileManager || manager == this._persistentManager) {
            return;
        }
        throw new OWLException("The given manager isn't know from in the OWLManagerGroup. Check your manager usage.");
    }

    public void flushIncrementalStorage() {
        this._storageListener.flush();
    }

    @Override
    public void close() {
        if (this == OWL._managerGroup) {
            _logger.log(Level.WARNING, "You try to close a static resource that should never be closed : ignore");
            return;
        }
        if (this._volatileManager != null) {
            this._volatileManager.clearOntologies();
            this._volatileManager.getIRIMappers().clear();
            this._volatileManager = null;
        }
        if (this._persistentManager != null) {
            if (null != this._storageListener) {
                this._persistentManager.removeOntologyChangeListener((OWLOntologyChangeListener)this._storageListener);
                this._storageListener.close();
            }
            this._persistentManager.clearOntologies();
            this._persistentManager.getIRIMappers().clear();
            this._persistentManager = null;
        }
    }
}

