/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.printers;

import java.io.IOException;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyChain;
import org.semanticweb.elk.owl.interfaces.ElkObjectSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkTransitiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.iris.ElkAbbreviatedIri;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.predefined.PredefinedElkIris;
import org.semanticweb.elk.owl.printers.PrintingException;
import org.semanticweb.elk.owl.visitors.AbstractElkObjectVisitor;

public class KrssSyntaxPrinterVisitor
extends AbstractElkObjectVisitor<Void> {
    private final Appendable writer;

    public KrssSyntaxPrinterVisitor(Appendable writer) {
        this.writer = writer;
    }

    @Override
    protected Void defaultVisit(ElkObject elkObject) {
        throw new PrintingException("Currently not supported by KRSS printer: " + elkObject);
    }

    @Override
    public Void visit(ElkSubClassOfAxiom elkSubClassOfAxiom) {
        this.write("(implies ");
        this.write(elkSubClassOfAxiom.getSubClassExpression());
        this.write(' ');
        this.write(elkSubClassOfAxiom.getSuperClassExpression());
        this.write(")\n");
        return null;
    }

    @Override
    public Void visit(ElkEquivalentClassesAxiom elkEquivalentClassesAxiom) {
        this.write("(equivalent ");
        this.write(elkEquivalentClassesAxiom.getClassExpressions());
        this.write(")\n");
        return null;
    }

    @Override
    public Void visit(ElkSubObjectPropertyOfAxiom elkSubObjectPropertyOfAxiom) {
        this.write("(role-inclusion ");
        this.write(elkSubObjectPropertyOfAxiom.getSubObjectPropertyExpression());
        this.write(' ');
        this.write(elkSubObjectPropertyOfAxiom.getSuperObjectPropertyExpression());
        this.write(")\n");
        return null;
    }

    @Override
    public Void visit(ElkTransitiveObjectPropertyAxiom elkTransitiveObjectPropertyAxiom) {
        this.write("(transitive ");
        this.write((ElkObject)elkTransitiveObjectPropertyAxiom.getProperty());
        this.write(")\n");
        return null;
    }

    @Override
    public Void visit(ElkObjectSomeValuesFrom elkObjectSomeValuesFrom) {
        this.write("(some ");
        this.write((ElkObject)elkObjectSomeValuesFrom.getProperty());
        this.write(' ');
        this.write((ElkObject)elkObjectSomeValuesFrom.getFiller());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectIntersectionOf elkObjectIntersectionOf) {
        this.write("(and ");
        this.write(elkObjectIntersectionOf.getClassExpressions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkClass elkClass) {
        this.write(elkClass);
        return null;
    }

    @Override
    public Void visit(ElkObjectProperty elkObjectProperty) {
        this.write(elkObjectProperty);
        return null;
    }

    @Override
    public Void visit(ElkObjectPropertyChain elkObjectPropertyChain) {
        this.write("(compose ");
        this.write(elkObjectPropertyChain.getObjectPropertyExpressions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkFullIri iri) {
        this.write(iri);
        return null;
    }

    @Override
    public Void visit(ElkAbbreviatedIri iri) {
        this.write(iri);
        return null;
    }

    protected final void write(char ch) {
        try {
            this.writer.append(ch);
        }
        catch (IOException e) {
            throw new PrintingException(e.getMessage(), e.getCause());
        }
    }

    protected final void write(String string) {
        try {
            this.writer.append(string);
        }
        catch (IOException e) {
            throw new PrintingException(e.getMessage(), e.getCause());
        }
    }

    protected final void write(ElkIri iri) {
        if (PredefinedElkIris.OWL_THING.equals(iri)) {
            this.write("top");
        } else {
            this.write(iri.getFullIriAsString());
        }
    }

    protected final void write(ElkEntity elkEntity) {
        this.write(elkEntity.getIri());
    }

    protected final void write(ElkObject elkObject) {
        elkObject.accept(this);
    }

    protected final void write(Iterable<? extends ElkObject> elkObjects) {
        boolean first = true;
        for (ElkObject elkObject : elkObjects) {
            if (!first) {
                this.write(' ');
            } else {
                first = false;
            }
            this.write(elkObject);
        }
    }
}

