# Contributing to LionAGI

Thank you for your interest in contributing to LionAGI!

## Ways to Contribute

- **Bug Reports**: Found an issue? Create a GitHub issue
- **Feature Requests**: Have ideas for improvements? Let us know
- **Documentation**: Help improve our docs and examples
- **Code**: Submit pull requests for bug fixes and features
- **Community**: Help others in discussions and forums

## Development Setup

1. Fork the repository
2. Clone your fork
3. Install dependencies: `uv sync`
4. Create a branch: `git checkout -b feature/your-feature`
5. Make changes and add tests
6. Run tests: `uv run pytest`
7. Submit a pull request

## Code Standards

- Follow Python PEP 8 style guidelines
- Add type hints to all functions
- Include docstrings for public APIs
- Write tests for new functionality
- Keep pull requests focused and atomic

## Documentation

- Update docs when adding features
- Include examples in docstrings
- Test code examples to ensure they work
- Follow our documentation standards

## Community Guidelines

- Be respectful and inclusive
- Help newcomers learn
- Focus on constructive feedback
- Follow our Code of Conduct

## Questions?

- GitHub Discussions for questions
- GitHub Issues for bugs and features
- Discord community for real-time chat

We appreciate all contributions, no matter how small!
