#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# ORCID Hub documentation build configuration file, created by
# sphinx-quickstart on Tue Nov 28 17:15:32 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
import datetime
import time
import logging
import recommonmark.parser
from recommonmark.transform import AutoStructify

BUILD_DATE = datetime.datetime.utcfromtimestamp(int(os.environ.get("SOURCE_DATE_EPOCH", time.time())))

# sys.path.insert(0, os.path.abspath("."))
# sys.path.insert(0, os.path.abspath("../.."))
_dir = os.path.dirname(__file__)
sys.path.append(os.path.dirname(_dir))
sys.path.append(_dir)

# disable logging to Sentry:
raven_logger = logging.getLogger("raven.base.Client")
raven_logger.setLevel(logging.CRITICAL)

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = "1.0"

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named "sphinx.ext.*") or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.doctest",
    "sphinx.ext.intersphinx",
    "m2r",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_parsers = {
#     ".md": recommonmark.parser.CommonMarkParser,
# }
# source_suffix = {
#     ".rst": "restructuredtext",
#     ".md": "markdown",
# }
source_suffix = [".rst", ".md"]
# source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "ORCID Hub"
copyright = "2017, Royal Society of New Zealand"
author = "Jason Gush, Radomirs Cirskis, Roshan Pawar"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#

try:
    from orcid_hub._version import __version__
    # The short X.Y version.
    version = '.'.join(__version__.split('.')[:2])
    # The full version, including alpha/beta/rc tags.
    release = __version__
except ImportError:
    # The short X.Y version.
    version = "3.0"
    # The full version, including alpha/beta/rc tags.
    release = "3.0a5"
    version = release = "dev"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# If true, `todo` and `todoList` produce output, else they produce nothing.
#todo_include_todos = False
todo_include_todos = True


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'alabaster'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_logo = "../orcid_hub/static/images/logo.png"
html_favicon = "../orcid_hub/static/images/favicon-32x32.png"

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# This is required for the alabaster theme
# refs: http://alabaster.readthedocs.io/en/latest/installation.html#sidebars
html_sidebars = {
    '**': [
        'relations.html',  # needs 'show_related': True theme option to display
        'searchbox.html',
    ]
}


# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'ORCIDHubdoc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'ORCIDHub.tex', 'ORCID Hub Documentation',
     'Jason Gush, Radomirs Cirskis, Roshan Pawar', 'manual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'orcidhub', 'ORCID Hub Documentation',
     [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'ORCIDHub', 'ORCID Hub Documentation',
     author, 'ORCIDHub', 'One line description of project.',
     'Miscellaneous'),
]

# this should be at the bottom of conf.py
# def setup(app):
#     app.add_config_value(
#         'recommonmark_config', {
#             'url_resolver': lambda url: github_doc_root + url,
#             'auto_toc_tree_section': 'Contents',
#         }, True)
#     app.add_transform(AutoStructify)

