# coding: utf-8

"""
    ORCID Member

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class MemberAPIV21Api(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_permission_notification(self, orcid, **kwargs):
        """
        Add a notification
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_permission_notification(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param NotificationPermission body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_permission_notification_with_http_info(orcid, **kwargs)
        else:
            (data) = self.add_permission_notification_with_http_info(orcid, **kwargs)
            return data

    def add_permission_notification_with_http_info(self, orcid, **kwargs):
        """
        Add a notification
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_permission_notification_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param NotificationPermission body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_permission_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `add_permission_notification`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/notification-permission'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_two_legs']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_address(self, orcid, **kwargs):
        """
        Add an address
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_address(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param Address body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_address_with_http_info(orcid, **kwargs)
        else:
            (data) = self.create_address_with_http_info(orcid, **kwargs)
            return data

    def create_address_with_http_info(self, orcid, **kwargs):
        """
        Add an address
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_address_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param Address body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `create_address`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/address'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_education(self, orcid, **kwargs):
        """
        Create an Education
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_education(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param Education body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_education_with_http_info(orcid, **kwargs)
        else:
            (data) = self.create_education_with_http_info(orcid, **kwargs)
            return data

    def create_education_with_http_info(self, orcid, **kwargs):
        """
        Create an Education
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_education_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param Education body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_education" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `create_education`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/education'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_employment(self, orcid, **kwargs):
        """
        Create an Employment
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_employment(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param Employment body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_employment_with_http_info(orcid, **kwargs)
        else:
            (data) = self.create_employment_with_http_info(orcid, **kwargs)
            return data

    def create_employment_with_http_info(self, orcid, **kwargs):
        """
        Create an Employment
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_employment_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param Employment body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_employment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `create_employment`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/employment'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_external_identifier(self, orcid, **kwargs):
        """
        Add external identifier
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_external_identifier(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param PersonExternalIdentifier body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_external_identifier_with_http_info(orcid, **kwargs)
        else:
            (data) = self.create_external_identifier_with_http_info(orcid, **kwargs)
            return data

    def create_external_identifier_with_http_info(self, orcid, **kwargs):
        """
        Add external identifier
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_external_identifier_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param PersonExternalIdentifier body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_external_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `create_external_identifier`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/external-identifiers'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_funding(self, orcid, **kwargs):
        """
        Create a Funding
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_funding(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param Funding body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_funding_with_http_info(orcid, **kwargs)
        else:
            (data) = self.create_funding_with_http_info(orcid, **kwargs)
            return data

    def create_funding_with_http_info(self, orcid, **kwargs):
        """
        Create a Funding
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_funding_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param Funding body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_funding" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `create_funding`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/funding'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_group_id_record(self, **kwargs):
        """
        Create a Group
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_group_id_record(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param GroupIdRecord body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_group_id_record_with_http_info(**kwargs)
        else:
            (data) = self.create_group_id_record_with_http_info(**kwargs)
            return data

    def create_group_id_record_with_http_info(self, **kwargs):
        """
        Create a Group
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_group_id_record_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param GroupIdRecord body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_group_id_record" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/v2.1/group-id-record'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_keyword(self, orcid, **kwargs):
        """
        Add keyword
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_keyword(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param Keyword body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_keyword_with_http_info(orcid, **kwargs)
        else:
            (data) = self.create_keyword_with_http_info(orcid, **kwargs)
            return data

    def create_keyword_with_http_info(self, orcid, **kwargs):
        """
        Add keyword
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_keyword_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param Keyword body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_keyword" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `create_keyword`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/keywords'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_other_name(self, orcid, **kwargs):
        """
        Add other name
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_other_name(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param OtherName body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_other_name_with_http_info(orcid, **kwargs)
        else:
            (data) = self.create_other_name_with_http_info(orcid, **kwargs)
            return data

    def create_other_name_with_http_info(self, orcid, **kwargs):
        """
        Add other name
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_other_name_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param OtherName body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_other_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `create_other_name`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/other-names'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_peer_review(self, orcid, **kwargs):
        """
        Create a Peer Review
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_peer_review(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param PeerReview body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_peer_review_with_http_info(orcid, **kwargs)
        else:
            (data) = self.create_peer_review_with_http_info(orcid, **kwargs)
            return data

    def create_peer_review_with_http_info(self, orcid, **kwargs):
        """
        Create a Peer Review
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_peer_review_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param PeerReview body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_peer_review" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `create_peer_review`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/peer-review'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_researcher_url(self, orcid, **kwargs):
        """
        Add a new researcher url for an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_researcher_url(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param ResearcherUrl body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_researcher_url_with_http_info(orcid, **kwargs)
        else:
            (data) = self.create_researcher_url_with_http_info(orcid, **kwargs)
            return data

    def create_researcher_url_with_http_info(self, orcid, **kwargs):
        """
        Add a new researcher url for an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_researcher_url_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param ResearcherUrl body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_researcher_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `create_researcher_url`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/researcher-urls'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_work(self, orcid, **kwargs):
        """
        Create a Work
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_work(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param Work body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_work_with_http_info(orcid, **kwargs)
        else:
            (data) = self.create_work_with_http_info(orcid, **kwargs)
            return data

    def create_work_with_http_info(self, orcid, **kwargs):
        """
        Create a Work
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_work_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param Work body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_work" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `create_work`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/work'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_works(self, orcid, **kwargs):
        """
        Create a listo of Work
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_works(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param WorkBulk body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_works_with_http_info(orcid, **kwargs)
        else:
            (data) = self.create_works_with_http_info(orcid, **kwargs)
            return data

    def create_works_with_http_info(self, orcid, **kwargs):
        """
        Create a listo of Work
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_works_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param WorkBulk body:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_works" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `create_works`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/works'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_address(self, orcid, put_code, **kwargs):
        """
        Delete an address
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_address(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_address_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.delete_address_with_http_info(orcid, put_code, **kwargs)
            return data

    def delete_address_with_http_info(self, orcid, put_code, **kwargs):
        """
        Delete an address
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_address_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `delete_address`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `delete_address`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/address/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_education(self, orcid, put_code, **kwargs):
        """
        Delete an Education
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_education(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_education_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.delete_education_with_http_info(orcid, put_code, **kwargs)
            return data

    def delete_education_with_http_info(self, orcid, put_code, **kwargs):
        """
        Delete an Education
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_education_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_education" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `delete_education`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `delete_education`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/education/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_employment(self, orcid, put_code, **kwargs):
        """
        Delete an Employment
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_employment(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_employment_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.delete_employment_with_http_info(orcid, put_code, **kwargs)
            return data

    def delete_employment_with_http_info(self, orcid, put_code, **kwargs):
        """
        Delete an Employment
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_employment_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_employment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `delete_employment`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `delete_employment`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/employment/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_external_identifier(self, orcid, put_code, **kwargs):
        """
        Delete external identifier
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_external_identifier(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_external_identifier_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.delete_external_identifier_with_http_info(orcid, put_code, **kwargs)
            return data

    def delete_external_identifier_with_http_info(self, orcid, put_code, **kwargs):
        """
        Delete external identifier
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_external_identifier_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_external_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `delete_external_identifier`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `delete_external_identifier`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/external-identifiers/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_funding(self, orcid, put_code, **kwargs):
        """
        Delete a Funding
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_funding(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_funding_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.delete_funding_with_http_info(orcid, put_code, **kwargs)
            return data

    def delete_funding_with_http_info(self, orcid, put_code, **kwargs):
        """
        Delete a Funding
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_funding_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_funding" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `delete_funding`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `delete_funding`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/funding/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_group_id_record(self, put_code, **kwargs):
        """
        Delete a Group
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_group_id_record(put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_group_id_record_with_http_info(put_code, **kwargs)
        else:
            (data) = self.delete_group_id_record_with_http_info(put_code, **kwargs)
            return data

    def delete_group_id_record_with_http_info(self, put_code, **kwargs):
        """
        Delete a Group
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_group_id_record_with_http_info(put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_group_id_record" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `delete_group_id_record`")


        collection_formats = {}

        resource_path = '/v2.1/group-id-record/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_keyword(self, orcid, put_code, **kwargs):
        """
        Delete keyword
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_keyword(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_keyword_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.delete_keyword_with_http_info(orcid, put_code, **kwargs)
            return data

    def delete_keyword_with_http_info(self, orcid, put_code, **kwargs):
        """
        Delete keyword
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_keyword_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_keyword" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `delete_keyword`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `delete_keyword`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/keywords/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_other_name(self, orcid, put_code, **kwargs):
        """
        Delete other name
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_other_name(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_other_name_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.delete_other_name_with_http_info(orcid, put_code, **kwargs)
            return data

    def delete_other_name_with_http_info(self, orcid, put_code, **kwargs):
        """
        Delete other name
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_other_name_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_other_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `delete_other_name`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `delete_other_name`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/other-names/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_peer_review(self, orcid, put_code, **kwargs):
        """
        Delete a Peer Review
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_peer_review(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_peer_review_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.delete_peer_review_with_http_info(orcid, put_code, **kwargs)
            return data

    def delete_peer_review_with_http_info(self, orcid, put_code, **kwargs):
        """
        Delete a Peer Review
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_peer_review_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_peer_review" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `delete_peer_review`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `delete_peer_review`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/peer-review/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_researcher_url(self, orcid, put_code, **kwargs):
        """
        Delete one researcher url from an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_researcher_url(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_researcher_url_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.delete_researcher_url_with_http_info(orcid, put_code, **kwargs)
            return data

    def delete_researcher_url_with_http_info(self, orcid, put_code, **kwargs):
        """
        Delete one researcher url from an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_researcher_url_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_researcher_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `delete_researcher_url`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `delete_researcher_url`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/researcher-urls/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_work(self, orcid, put_code, **kwargs):
        """
        Delete a Work
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_work(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_work_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.delete_work_with_http_info(orcid, put_code, **kwargs)
            return data

    def delete_work_with_http_info(self, orcid, put_code, **kwargs):
        """
        Delete a Work
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_work_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_work" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `delete_work`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `delete_work`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/work/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def edit_address(self, orcid, put_code, **kwargs):
        """
        Edit an address
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_address(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param Address body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.edit_address_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.edit_address_with_http_info(orcid, put_code, **kwargs)
            return data

    def edit_address_with_http_info(self, orcid, put_code, **kwargs):
        """
        Edit an address
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_address_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param Address body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `edit_address`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `edit_address`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/address/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def edit_external_identifier(self, orcid, put_code, **kwargs):
        """
        Edit external identifier
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_external_identifier(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param PersonExternalIdentifier body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.edit_external_identifier_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.edit_external_identifier_with_http_info(orcid, put_code, **kwargs)
            return data

    def edit_external_identifier_with_http_info(self, orcid, put_code, **kwargs):
        """
        Edit external identifier
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_external_identifier_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param PersonExternalIdentifier body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_external_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `edit_external_identifier`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `edit_external_identifier`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/external-identifiers/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def edit_keyword(self, orcid, put_code, **kwargs):
        """
        Edit keyword
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_keyword(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param Keyword body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.edit_keyword_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.edit_keyword_with_http_info(orcid, put_code, **kwargs)
            return data

    def edit_keyword_with_http_info(self, orcid, put_code, **kwargs):
        """
        Edit keyword
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_keyword_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param Keyword body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_keyword" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `edit_keyword`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `edit_keyword`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/keywords/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def edit_other_name(self, orcid, put_code, **kwargs):
        """
        Edit other name
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_other_name(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param OtherName body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.edit_other_name_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.edit_other_name_with_http_info(orcid, put_code, **kwargs)
            return data

    def edit_other_name_with_http_info(self, orcid, put_code, **kwargs):
        """
        Edit other name
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_other_name_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param OtherName body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_other_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `edit_other_name`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `edit_other_name`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/other-names/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def edit_researcher_url(self, orcid, put_code, **kwargs):
        """
        Edits researcher url for an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_researcher_url(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param ResearcherUrl body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.edit_researcher_url_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.edit_researcher_url_with_http_info(orcid, put_code, **kwargs)
            return data

    def edit_researcher_url_with_http_info(self, orcid, put_code, **kwargs):
        """
        Edits researcher url for an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_researcher_url_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param ResearcherUrl body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_researcher_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `edit_researcher_url`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `edit_researcher_url`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/researcher-urls/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def flag_as_archived_permission_notification(self, orcid, id, **kwargs):
        """
        Archive a notification
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.flag_as_archived_permission_notification(orcid, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param int id: (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.flag_as_archived_permission_notification_with_http_info(orcid, id, **kwargs)
        else:
            (data) = self.flag_as_archived_permission_notification_with_http_info(orcid, id, **kwargs)
            return data

    def flag_as_archived_permission_notification_with_http_info(self, orcid, id, **kwargs):
        """
        Archive a notification
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.flag_as_archived_permission_notification_with_http_info(orcid, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param int id: (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method flag_as_archived_permission_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `flag_as_archived_permission_notification`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `flag_as_archived_permission_notification`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/notification-permission/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['orcid_two_legs']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Notification',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def search_by_query_xml(self, **kwargs):
        """
        Search records
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_by_query_xml(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str q:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.search_by_query_xml_with_http_info(**kwargs)
        else:
            (data) = self.search_by_query_xml_with_http_info(**kwargs)
            return data

    def search_by_query_xml_with_http_info(self, **kwargs):
        """
        Search records
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_by_query_xml_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str q:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['q']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_by_query_xml" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/v2.1/search'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'q' in params:
            query_params['q'] = params['q']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_education(self, orcid, put_code, **kwargs):
        """
        Update an Education
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_education(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param Education body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_education_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.update_education_with_http_info(orcid, put_code, **kwargs)
            return data

    def update_education_with_http_info(self, orcid, put_code, **kwargs):
        """
        Update an Education
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_education_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param Education body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_education" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `update_education`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `update_education`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/education/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_employment(self, orcid, put_code, **kwargs):
        """
        Update an Employment
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_employment(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param Employment body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_employment_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.update_employment_with_http_info(orcid, put_code, **kwargs)
            return data

    def update_employment_with_http_info(self, orcid, put_code, **kwargs):
        """
        Update an Employment
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_employment_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param Employment body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_employment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `update_employment`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `update_employment`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/employment/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_funding(self, orcid, put_code, **kwargs):
        """
        Update a Funding
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_funding(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param Funding body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_funding_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.update_funding_with_http_info(orcid, put_code, **kwargs)
            return data

    def update_funding_with_http_info(self, orcid, put_code, **kwargs):
        """
        Update a Funding
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_funding_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param Funding body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_funding" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `update_funding`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `update_funding`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/funding/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_group_id_record(self, put_code, **kwargs):
        """
        Update a Group
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_group_id_record(put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str put_code: (required)
        :param GroupIdRecord body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_group_id_record_with_http_info(put_code, **kwargs)
        else:
            (data) = self.update_group_id_record_with_http_info(put_code, **kwargs)
            return data

    def update_group_id_record_with_http_info(self, put_code, **kwargs):
        """
        Update a Group
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_group_id_record_with_http_info(put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str put_code: (required)
        :param GroupIdRecord body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['put_code', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_group_id_record" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `update_group_id_record`")


        collection_formats = {}

        resource_path = '/v2.1/group-id-record/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_peer_review(self, orcid, put_code, **kwargs):
        """
        Update a Peer Review
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_peer_review(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param PeerReview body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_peer_review_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.update_peer_review_with_http_info(orcid, put_code, **kwargs)
            return data

    def update_peer_review_with_http_info(self, orcid, put_code, **kwargs):
        """
        Update a Peer Review
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_peer_review_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param PeerReview body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_peer_review" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `update_peer_review`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `update_peer_review`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/peer-review/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_work(self, orcid, put_code, **kwargs):
        """
        Update a Work
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_work(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param Work body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_work_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.update_work_with_http_info(orcid, put_code, **kwargs)
            return data

    def update_work_with_http_info(self, orcid, put_code, **kwargs):
        """
        Update a Work
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_work_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :param Work body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_work" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `update_work`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `update_work`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/work/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_activities(self, orcid, **kwargs):
        """
        Fetch all activities
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_activities(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: ActivitiesSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_activities_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_activities_with_http_info(orcid, **kwargs)
            return data

    def view_activities_with_http_info(self, orcid, **kwargs):
        """
        Fetch all activities
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_activities_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: ActivitiesSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_activities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_activities`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/activities'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ActivitiesSummary',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_address(self, orcid, put_code, **kwargs):
        """
        Fetch an address
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_address(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_address_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_address_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_address_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch an address
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_address_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_address`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_address`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/address/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_addresses(self, orcid, **kwargs):
        """
        Fetch all addresses of a profile
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_addresses(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_addresses_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_addresses_with_http_info(orcid, **kwargs)
            return data

    def view_addresses_with_http_info(self, orcid, **kwargs):
        """
        Fetch all addresses of a profile
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_addresses_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_addresses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_addresses`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/address'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_biography(self, orcid, **kwargs):
        """
        Get biography details
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_biography(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_biography_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_biography_with_http_info(orcid, **kwargs)
            return data

    def view_biography_with_http_info(self, orcid, **kwargs):
        """
        Get biography details
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_biography_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_biography" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_biography`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/biography'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_client(self, client_id, **kwargs):
        """
        Fetch client details
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_client(client_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_client_with_http_info(client_id, **kwargs)
        else:
            (data) = self.view_client_with_http_info(client_id, **kwargs)
            return data

    def view_client_with_http_info(self, client_id, **kwargs):
        """
        Fetch client details
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_client_with_http_info(client_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_client" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `view_client`")

        if 'client_id' in params and not re.search('[^/]+', params['client_id']):
            raise ValueError("Invalid value for parameter `client_id` when calling `view_client`, must conform to the pattern `/[^/]+/`")

        collection_formats = {}

        resource_path = '/v2.1/client/{client_id}'.replace('{format}', 'json')
        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_education(self, orcid, put_code, **kwargs):
        """
        Fetch an Education
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_education(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: Education
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_education_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_education_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_education_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch an Education
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_education_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: Education
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_education" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_education`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_education`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/education/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Education',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_education_summary(self, orcid, put_code, **kwargs):
        """
        Fetch an Education summary
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_education_summary(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: EducationSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_education_summary_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_education_summary_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_education_summary_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch an Education summary
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_education_summary_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: EducationSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_education_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_education_summary`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_education_summary`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/education/summary/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EducationSummary',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_educations(self, orcid, **kwargs):
        """
        Fetch all educations
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_educations(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: Educations
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_educations_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_educations_with_http_info(orcid, **kwargs)
            return data

    def view_educations_with_http_info(self, orcid, **kwargs):
        """
        Fetch all educations
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_educations_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: Educations
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_educations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_educations`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/educations'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Educations',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_emails(self, orcid, **kwargs):
        """
        Fetch all emails for an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_emails(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_emails_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_emails_with_http_info(orcid, **kwargs)
            return data

    def view_emails_with_http_info(self, orcid, **kwargs):
        """
        Fetch all emails for an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_emails_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_emails" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_emails`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/email'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_employment(self, orcid, put_code, **kwargs):
        """
        Fetch an Employment
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_employment(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: Employment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_employment_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_employment_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_employment_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch an Employment
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_employment_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: Employment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_employment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_employment`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_employment`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/employment/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Employment',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_employment_summary(self, orcid, put_code, **kwargs):
        """
        Fetch an Employment Summary
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_employment_summary(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: EmploymentSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_employment_summary_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_employment_summary_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_employment_summary_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch an Employment Summary
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_employment_summary_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: EmploymentSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_employment_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_employment_summary`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_employment_summary`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/employment/summary/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EmploymentSummary',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_employments(self, orcid, **kwargs):
        """
        Fetch all employments
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_employments(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: Employments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_employments_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_employments_with_http_info(orcid, **kwargs)
            return data

    def view_employments_with_http_info(self, orcid, **kwargs):
        """
        Fetch all employments
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_employments_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: Employments
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_employments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_employments`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/employments'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Employments',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_external_identifier(self, orcid, put_code, **kwargs):
        """
        Fetch external identifier
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_external_identifier(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_external_identifier_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_external_identifier_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_external_identifier_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch external identifier
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_external_identifier_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_external_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_external_identifier`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_external_identifier`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/external-identifiers/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_external_identifiers(self, orcid, **kwargs):
        """
        Fetch external identifiers
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_external_identifiers(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_external_identifiers_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_external_identifiers_with_http_info(orcid, **kwargs)
            return data

    def view_external_identifiers_with_http_info(self, orcid, **kwargs):
        """
        Fetch external identifiers
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_external_identifiers_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_external_identifiers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_external_identifiers`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/external-identifiers'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_funding(self, orcid, put_code, **kwargs):
        """
        Fetch a Funding
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_funding(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: Funding
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_funding_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_funding_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_funding_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch a Funding
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_funding_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: Funding
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_funding" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_funding`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_funding`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/funding/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Funding',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_funding_summary(self, orcid, put_code, **kwargs):
        """
        Fetch a Funding Summary
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_funding_summary(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: FundingSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_funding_summary_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_funding_summary_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_funding_summary_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch a Funding Summary
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_funding_summary_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: FundingSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_funding_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_funding_summary`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_funding_summary`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/funding/summary/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FundingSummary',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_fundings(self, orcid, **kwargs):
        """
        Fetch all fundings
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_fundings(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: Fundings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_fundings_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_fundings_with_http_info(orcid, **kwargs)
            return data

    def view_fundings_with_http_info(self, orcid, **kwargs):
        """
        Fetch all fundings
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_fundings_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: Fundings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_fundings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_fundings`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/fundings'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Fundings',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_group_id_record(self, put_code, **kwargs):
        """
        Fetch a Group
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_group_id_record(put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str put_code: (required)
        :return: GroupIdRecord
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_group_id_record_with_http_info(put_code, **kwargs)
        else:
            (data) = self.view_group_id_record_with_http_info(put_code, **kwargs)
            return data

    def view_group_id_record_with_http_info(self, put_code, **kwargs):
        """
        Fetch a Group
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_group_id_record_with_http_info(put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str put_code: (required)
        :return: GroupIdRecord
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_group_id_record" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_group_id_record`")


        collection_formats = {}

        resource_path = '/v2.1/group-id-record/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='GroupIdRecord',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_group_id_records(self, **kwargs):
        """
        Fetch Groups
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_group_id_records(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str page_size:
        :param str page:
        :param str name:
        :return: GroupIdRecords
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_group_id_records_with_http_info(**kwargs)
        else:
            (data) = self.view_group_id_records_with_http_info(**kwargs)
            return data

    def view_group_id_records_with_http_info(self, **kwargs):
        """
        Fetch Groups
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_group_id_records_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str page_size:
        :param str page:
        :param str name:
        :return: GroupIdRecords
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page', 'name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_group_id_records" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/v2.1/group-id-record'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['page-size'] = params['page_size']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='GroupIdRecords',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_keyword(self, orcid, put_code, **kwargs):
        """
        Fetch keyword
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_keyword(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_keyword_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_keyword_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_keyword_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch keyword
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_keyword_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_keyword" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_keyword`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_keyword`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/keywords/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_keywords(self, orcid, **kwargs):
        """
        Fetch keywords
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_keywords(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_keywords_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_keywords_with_http_info(orcid, **kwargs)
            return data

    def view_keywords_with_http_info(self, orcid, **kwargs):
        """
        Fetch keywords
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_keywords_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_keywords" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_keywords`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/keywords'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_other_name(self, orcid, put_code, **kwargs):
        """
        Fetch Other name
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_other_name(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_other_name_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_other_name_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_other_name_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch Other name
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_other_name_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_other_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_other_name`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_other_name`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/other-names/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_other_names(self, orcid, **kwargs):
        """
        Fetch Other names
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_other_names(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_other_names_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_other_names_with_http_info(orcid, **kwargs)
            return data

    def view_other_names_with_http_info(self, orcid, **kwargs):
        """
        Fetch Other names
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_other_names_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_other_names" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_other_names`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/other-names'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_peer_review(self, orcid, put_code, **kwargs):
        """
        Fetch a Peer Review
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_peer_review(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: PeerReview
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_peer_review_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_peer_review_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_peer_review_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch a Peer Review
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_peer_review_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: PeerReview
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_peer_review" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_peer_review`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_peer_review`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/peer-review/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PeerReview',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_peer_review_summary(self, orcid, put_code, **kwargs):
        """
        Fetch a Peer Review Summary
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_peer_review_summary(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: PeerReviewSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_peer_review_summary_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_peer_review_summary_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_peer_review_summary_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch a Peer Review Summary
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_peer_review_summary_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: PeerReviewSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_peer_review_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_peer_review_summary`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_peer_review_summary`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/peer-review/summary/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PeerReviewSummary',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_peer_reviews(self, orcid, **kwargs):
        """
        Fetch all peer reviews
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_peer_reviews(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: PeerReviews
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_peer_reviews_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_peer_reviews_with_http_info(orcid, **kwargs)
            return data

    def view_peer_reviews_with_http_info(self, orcid, **kwargs):
        """
        Fetch all peer reviews
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_peer_reviews_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: PeerReviews
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_peer_reviews" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_peer_reviews`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/peer-reviews'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PeerReviews',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_permission_notification(self, orcid, id, **kwargs):
        """
        Fetch a notification by id
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_permission_notification(orcid, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param int id: (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_permission_notification_with_http_info(orcid, id, **kwargs)
        else:
            (data) = self.view_permission_notification_with_http_info(orcid, id, **kwargs)
            return data

    def view_permission_notification_with_http_info(self, orcid, id, **kwargs):
        """
        Fetch a notification by id
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_permission_notification_with_http_info(orcid, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param int id: (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_permission_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_permission_notification`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `view_permission_notification`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/notification-permission/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_two_legs']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Notification',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_person(self, orcid, **kwargs):
        """
        Fetch person details
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_person(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_person_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_person_with_http_info(orcid, **kwargs)
            return data

    def view_person_with_http_info(self, orcid, **kwargs):
        """
        Fetch person details
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_person_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_person" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_person`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/person'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_personal_details(self, orcid, **kwargs):
        """
        Fetch personal details for an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_personal_details(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_personal_details_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_personal_details_with_http_info(orcid, **kwargs)
            return data

    def view_personal_details_with_http_info(self, orcid, **kwargs):
        """
        Fetch personal details for an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_personal_details_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_personal_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_personal_details`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/personal-details'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_record(self, orcid, **kwargs):
        """
        Fetch record details
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_record(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_record_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_record_with_http_info(orcid, **kwargs)
            return data

    def view_record_with_http_info(self, orcid, **kwargs):
        """
        Fetch record details
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_record_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_record" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_record`")

        if 'orcid' in params and not re.search('[^/]+', params['orcid']):
            raise ValueError("Invalid value for parameter `orcid` when calling `view_record`, must conform to the pattern `/[^/]+/`")

        collection_formats = {}

        resource_path = '/v2.1/{orcid}{ignore}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_researcher_url(self, orcid, put_code, **kwargs):
        """
        Fetch one researcher url for an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_researcher_url(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_researcher_url_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_researcher_url_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_researcher_url_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch one researcher url for an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_researcher_url_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_researcher_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_researcher_url`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_researcher_url`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/researcher-urls/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_researcher_urls(self, orcid, **kwargs):
        """
        Fetch all researcher urls for an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_researcher_urls(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_researcher_urls_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_researcher_urls_with_http_info(orcid, **kwargs)
            return data

    def view_researcher_urls_with_http_info(self, orcid, **kwargs):
        """
        Fetch all researcher urls for an ORCID ID
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_researcher_urls_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_researcher_urls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_researcher_urls`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/researcher-urls'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_specified_works(self, orcid, put_codes, **kwargs):
        """
        Fetch specified works
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_specified_works(orcid, put_codes, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_codes: (required)
        :return: WorkBulk
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_specified_works_with_http_info(orcid, put_codes, **kwargs)
        else:
            (data) = self.view_specified_works_with_http_info(orcid, put_codes, **kwargs)
            return data

    def view_specified_works_with_http_info(self, orcid, put_codes, **kwargs):
        """
        Fetch specified works
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_specified_works_with_http_info(orcid, put_codes, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_codes: (required)
        :return: WorkBulk
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_codes']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_specified_works" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_specified_works`")
        # verify the required parameter 'put_codes' is set
        if ('put_codes' not in params) or (params['put_codes'] is None):
            raise ValueError("Missing the required parameter `put_codes` when calling `view_specified_works`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/works/{putCodes}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_codes' in params:
            path_params['putCodes'] = params['put_codes']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='WorkBulk',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_work(self, orcid, put_code, **kwargs):
        """
        Fetch a Work
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_work(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: Work
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_work_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_work_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_work_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch a Work
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_work_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: Work
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_work" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_work`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_work`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/work/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Work',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_work_summary(self, orcid, put_code, **kwargs):
        """
        Fetch a Work Summary
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_work_summary(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: WorkSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_work_summary_with_http_info(orcid, put_code, **kwargs)
        else:
            (data) = self.view_work_summary_with_http_info(orcid, put_code, **kwargs)
            return data

    def view_work_summary_with_http_info(self, orcid, put_code, **kwargs):
        """
        Fetch a Work Summary
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_work_summary_with_http_info(orcid, put_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :param str put_code: (required)
        :return: WorkSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid', 'put_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_work_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_work_summary`")
        # verify the required parameter 'put_code' is set
        if ('put_code' not in params) or (params['put_code'] is None):
            raise ValueError("Missing the required parameter `put_code` when calling `view_work_summary`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/work/summary/{putCode}'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']
        if 'put_code' in params:
            path_params['putCode'] = params['put_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='WorkSummary',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def view_works(self, orcid, **kwargs):
        """
        Fetch all works
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_works(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: Works
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.view_works_with_http_info(orcid, **kwargs)
        else:
            (data) = self.view_works_with_http_info(orcid, **kwargs)
            return data

    def view_works_with_http_info(self, orcid, **kwargs):
        """
        Fetch all works
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.view_works_with_http_info(orcid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orcid: (required)
        :return: Works
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orcid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_works" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orcid' is set
        if ('orcid' not in params) or (params['orcid'] is None):
            raise ValueError("Missing the required parameter `orcid` when calling `view_works`")


        collection_formats = {}

        resource_path = '/v2.1/{orcid}/works'.replace('{format}', 'json')
        path_params = {}
        if 'orcid' in params:
            path_params['orcid'] = params['orcid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.orcid+xml; qs=5', 'application/orcid+xml; qs=3', 'application/xml', 'application/vnd.orcid+json; qs=4', 'application/orcid+json; qs=2', 'application/json'])

        # Authentication setting
        auth_settings = ['orcid_auth']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Works',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
