# orcid_api_v3.DevelopmentMemberAPIV30Api

All URIs are relative to *//api.orcid.org/*

Method | HTTP request | Description
------------- | ------------- | -------------
[**add_permission_notificationv3**](DevelopmentMemberAPIV30Api.md#add_permission_notificationv3) | **POST** /v3.0/{orcid}/notification-permission | Add a notification
[**create_addressv3**](DevelopmentMemberAPIV30Api.md#create_addressv3) | **POST** /v3.0/{orcid}/address | Add an address
[**create_distinctionv3**](DevelopmentMemberAPIV30Api.md#create_distinctionv3) | **POST** /v3.0/{orcid}/distinction | Create an Distinction
[**create_educationv3**](DevelopmentMemberAPIV30Api.md#create_educationv3) | **POST** /v3.0/{orcid}/education | Create an Education
[**create_employmentv3**](DevelopmentMemberAPIV30Api.md#create_employmentv3) | **POST** /v3.0/{orcid}/employment | Create an Employment
[**create_external_identifierv3**](DevelopmentMemberAPIV30Api.md#create_external_identifierv3) | **POST** /v3.0/{orcid}/external-identifiers | Add external identifier
[**create_fundingv3**](DevelopmentMemberAPIV30Api.md#create_fundingv3) | **POST** /v3.0/{orcid}/funding | Create a Funding
[**create_group_id_recordv3**](DevelopmentMemberAPIV30Api.md#create_group_id_recordv3) | **POST** /v3.0/group-id-record | Create a Group
[**create_invited_positionv3**](DevelopmentMemberAPIV30Api.md#create_invited_positionv3) | **POST** /v3.0/{orcid}/invited-position | Create an InvitedPosition
[**create_keywordv3**](DevelopmentMemberAPIV30Api.md#create_keywordv3) | **POST** /v3.0/{orcid}/keywords | Add keyword
[**create_membershipv3**](DevelopmentMemberAPIV30Api.md#create_membershipv3) | **POST** /v3.0/{orcid}/membership | Create an Membership
[**create_other_namev3**](DevelopmentMemberAPIV30Api.md#create_other_namev3) | **POST** /v3.0/{orcid}/other-names | Add other name
[**create_peer_reviewv3**](DevelopmentMemberAPIV30Api.md#create_peer_reviewv3) | **POST** /v3.0/{orcid}/peer-review | Create a Peer Review
[**create_qualificationv3**](DevelopmentMemberAPIV30Api.md#create_qualificationv3) | **POST** /v3.0/{orcid}/qualification | Create an Qualification
[**create_research_resourcev3**](DevelopmentMemberAPIV30Api.md#create_research_resourcev3) | **POST** /v3.0/{orcid}/research-resource | Create a Research Resource
[**create_researcher_urlv3**](DevelopmentMemberAPIV30Api.md#create_researcher_urlv3) | **POST** /v3.0/{orcid}/researcher-urls | Add a new researcher url for an ORCID ID
[**create_servicev3**](DevelopmentMemberAPIV30Api.md#create_servicev3) | **POST** /v3.0/{orcid}/service | Create an Service
[**create_worksv3**](DevelopmentMemberAPIV30Api.md#create_worksv3) | **POST** /v3.0/{orcid}/works | Create a listo of Work
[**create_workv3**](DevelopmentMemberAPIV30Api.md#create_workv3) | **POST** /v3.0/{orcid}/work | Create a Work
[**delete_addressv3**](DevelopmentMemberAPIV30Api.md#delete_addressv3) | **DELETE** /v3.0/{orcid}/address/{putCode} | Delete an address
[**delete_distinctionv3**](DevelopmentMemberAPIV30Api.md#delete_distinctionv3) | **DELETE** /v3.0/{orcid}/distinction/{putCode} | Delete an Distinction
[**delete_educationv3**](DevelopmentMemberAPIV30Api.md#delete_educationv3) | **DELETE** /v3.0/{orcid}/education/{putCode} | Delete an Education
[**delete_employmentv3**](DevelopmentMemberAPIV30Api.md#delete_employmentv3) | **DELETE** /v3.0/{orcid}/employment/{putCode} | Delete an Employment
[**delete_external_identifierv3**](DevelopmentMemberAPIV30Api.md#delete_external_identifierv3) | **DELETE** /v3.0/{orcid}/external-identifiers/{putCode} | Delete external identifier
[**delete_fundingv3**](DevelopmentMemberAPIV30Api.md#delete_fundingv3) | **DELETE** /v3.0/{orcid}/funding/{putCode} | Delete a Funding
[**delete_group_id_recordv3**](DevelopmentMemberAPIV30Api.md#delete_group_id_recordv3) | **DELETE** /v3.0/group-id-record/{putCode} | Delete a Group
[**delete_invited_positionv3**](DevelopmentMemberAPIV30Api.md#delete_invited_positionv3) | **DELETE** /v3.0/{orcid}/invited-position/{putCode} | Delete an InvitedPosition
[**delete_keywordv3**](DevelopmentMemberAPIV30Api.md#delete_keywordv3) | **DELETE** /v3.0/{orcid}/keywords/{putCode} | Delete keyword
[**delete_membershipv3**](DevelopmentMemberAPIV30Api.md#delete_membershipv3) | **DELETE** /v3.0/{orcid}/membership/{putCode} | Delete an Membership
[**delete_other_namev3**](DevelopmentMemberAPIV30Api.md#delete_other_namev3) | **DELETE** /v3.0/{orcid}/other-names/{putCode} | Delete other name
[**delete_peer_reviewv3**](DevelopmentMemberAPIV30Api.md#delete_peer_reviewv3) | **DELETE** /v3.0/{orcid}/peer-review/{putCode} | Delete a Peer Review
[**delete_qualificationv3**](DevelopmentMemberAPIV30Api.md#delete_qualificationv3) | **DELETE** /v3.0/{orcid}/qualification/{putCode} | Delete an Qualification
[**delete_research_resourcev3**](DevelopmentMemberAPIV30Api.md#delete_research_resourcev3) | **DELETE** /v3.0/{orcid}/research-resource/{putCode} | Delete an Research Resource
[**delete_researcher_urlv3**](DevelopmentMemberAPIV30Api.md#delete_researcher_urlv3) | **DELETE** /v3.0/{orcid}/researcher-urls/{putCode} | Delete one researcher url from an ORCID ID
[**delete_servicev3**](DevelopmentMemberAPIV30Api.md#delete_servicev3) | **DELETE** /v3.0/{orcid}/service/{putCode} | Delete an Service
[**delete_workv3**](DevelopmentMemberAPIV30Api.md#delete_workv3) | **DELETE** /v3.0/{orcid}/work/{putCode} | Delete a Work
[**edit_addressv3**](DevelopmentMemberAPIV30Api.md#edit_addressv3) | **PUT** /v3.0/{orcid}/address/{putCode} | Edit an address
[**edit_external_identifierv3**](DevelopmentMemberAPIV30Api.md#edit_external_identifierv3) | **PUT** /v3.0/{orcid}/external-identifiers/{putCode} | Edit external identifier
[**edit_keywordv3**](DevelopmentMemberAPIV30Api.md#edit_keywordv3) | **PUT** /v3.0/{orcid}/keywords/{putCode} | Edit keyword
[**edit_other_namev3**](DevelopmentMemberAPIV30Api.md#edit_other_namev3) | **PUT** /v3.0/{orcid}/other-names/{putCode} | Edit other name
[**edit_researcher_urlv3**](DevelopmentMemberAPIV30Api.md#edit_researcher_urlv3) | **PUT** /v3.0/{orcid}/researcher-urls/{putCode} | Edits researcher url for an ORCID ID
[**flag_as_archived_permission_notificationv3**](DevelopmentMemberAPIV30Api.md#flag_as_archived_permission_notificationv3) | **DELETE** /v3.0/{orcid}/notification-permission/{id} | Archive a notification
[**search_by_queryv3**](DevelopmentMemberAPIV30Api.md#search_by_queryv3) | **GET** /v3.0/search | Search records
[**update_distinctionv3**](DevelopmentMemberAPIV30Api.md#update_distinctionv3) | **PUT** /v3.0/{orcid}/distinction/{putCode} | Update an Distinction
[**update_educationv3**](DevelopmentMemberAPIV30Api.md#update_educationv3) | **PUT** /v3.0/{orcid}/education/{putCode} | Update an Education
[**update_employmentv3**](DevelopmentMemberAPIV30Api.md#update_employmentv3) | **PUT** /v3.0/{orcid}/employment/{putCode} | Update an Employment
[**update_fundingv3**](DevelopmentMemberAPIV30Api.md#update_fundingv3) | **PUT** /v3.0/{orcid}/funding/{putCode} | Update a Funding
[**update_group_id_recordv3**](DevelopmentMemberAPIV30Api.md#update_group_id_recordv3) | **PUT** /v3.0/group-id-record/{putCode} | Update a Group
[**update_invited_positionv3**](DevelopmentMemberAPIV30Api.md#update_invited_positionv3) | **PUT** /v3.0/{orcid}/invited-position/{putCode} | Update an InvitedPosition
[**update_membershipv3**](DevelopmentMemberAPIV30Api.md#update_membershipv3) | **PUT** /v3.0/{orcid}/membership/{putCode} | Update an Membership
[**update_peer_reviewv3**](DevelopmentMemberAPIV30Api.md#update_peer_reviewv3) | **PUT** /v3.0/{orcid}/peer-review/{putCode} | Update a Peer Review
[**update_qualificationv3**](DevelopmentMemberAPIV30Api.md#update_qualificationv3) | **PUT** /v3.0/{orcid}/qualification/{putCode} | Update an Qualification
[**update_research_resourcev3**](DevelopmentMemberAPIV30Api.md#update_research_resourcev3) | **PUT** /v3.0/{orcid}/research-resource/{putCode} | Update a Research Resource
[**update_servicev3**](DevelopmentMemberAPIV30Api.md#update_servicev3) | **PUT** /v3.0/{orcid}/service/{putCode} | Update an Service
[**update_workv3**](DevelopmentMemberAPIV30Api.md#update_workv3) | **PUT** /v3.0/{orcid}/work/{putCode} | Update a Work
[**view_activitiesv3**](DevelopmentMemberAPIV30Api.md#view_activitiesv3) | **GET** /v3.0/{orcid}/activities | Fetch all activities
[**view_addressesv3**](DevelopmentMemberAPIV30Api.md#view_addressesv3) | **GET** /v3.0/{orcid}/address | Fetch all addresses of a profile
[**view_addressv3**](DevelopmentMemberAPIV30Api.md#view_addressv3) | **GET** /v3.0/{orcid}/address/{putCode} | Fetch an address
[**view_biographyv3**](DevelopmentMemberAPIV30Api.md#view_biographyv3) | **GET** /v3.0/{orcid}/biography | Get biography details
[**view_clientv3**](DevelopmentMemberAPIV30Api.md#view_clientv3) | **GET** /v3.0/client/{client_id} | Fetch client details
[**view_distinction_summaryv3**](DevelopmentMemberAPIV30Api.md#view_distinction_summaryv3) | **GET** /v3.0/{orcid}/distinction/summary/{putCode} | Fetch an Distinction summary
[**view_distinctionsv3**](DevelopmentMemberAPIV30Api.md#view_distinctionsv3) | **GET** /v3.0/{orcid}/distinctions | Fetch all distinctions
[**view_distinctionv3**](DevelopmentMemberAPIV30Api.md#view_distinctionv3) | **GET** /v3.0/{orcid}/distinction/{putCode} | Fetch an Distinction
[**view_education_summaryv3**](DevelopmentMemberAPIV30Api.md#view_education_summaryv3) | **GET** /v3.0/{orcid}/education/summary/{putCode} | Fetch an Education summary
[**view_educationsv3**](DevelopmentMemberAPIV30Api.md#view_educationsv3) | **GET** /v3.0/{orcid}/educations | Fetch all educations
[**view_educationv3**](DevelopmentMemberAPIV30Api.md#view_educationv3) | **GET** /v3.0/{orcid}/education/{putCode} | Fetch an Education
[**view_emailsv3**](DevelopmentMemberAPIV30Api.md#view_emailsv3) | **GET** /v3.0/{orcid}/email | Fetch all emails for an ORCID ID
[**view_employment_summaryv3**](DevelopmentMemberAPIV30Api.md#view_employment_summaryv3) | **GET** /v3.0/{orcid}/employment/summary/{putCode} | Fetch an Employment Summary
[**view_employmentsv3**](DevelopmentMemberAPIV30Api.md#view_employmentsv3) | **GET** /v3.0/{orcid}/employments | Fetch all employments
[**view_employmentv3**](DevelopmentMemberAPIV30Api.md#view_employmentv3) | **GET** /v3.0/{orcid}/employment/{putCode} | Fetch an Employment
[**view_external_identifiersv3**](DevelopmentMemberAPIV30Api.md#view_external_identifiersv3) | **GET** /v3.0/{orcid}/external-identifiers | Fetch external identifiers
[**view_external_identifierv3**](DevelopmentMemberAPIV30Api.md#view_external_identifierv3) | **GET** /v3.0/{orcid}/external-identifiers/{putCode} | Fetch external identifier
[**view_funding_summaryv3**](DevelopmentMemberAPIV30Api.md#view_funding_summaryv3) | **GET** /v3.0/{orcid}/funding/summary/{putCode} | Fetch a Funding Summary
[**view_fundingsv3**](DevelopmentMemberAPIV30Api.md#view_fundingsv3) | **GET** /v3.0/{orcid}/fundings | Fetch all fundings
[**view_fundingv3**](DevelopmentMemberAPIV30Api.md#view_fundingv3) | **GET** /v3.0/{orcid}/funding/{putCode} | Fetch a Funding
[**view_group_id_recordsv3**](DevelopmentMemberAPIV30Api.md#view_group_id_recordsv3) | **GET** /v3.0/group-id-record | Fetch Groups
[**view_group_id_recordv3**](DevelopmentMemberAPIV30Api.md#view_group_id_recordv3) | **GET** /v3.0/group-id-record/{putCode} | Fetch a Group
[**view_invited_position_summaryv3**](DevelopmentMemberAPIV30Api.md#view_invited_position_summaryv3) | **GET** /v3.0/{orcid}/invited-position/summary/{putCode} | Fetch an InvitedPosition summary
[**view_invited_positionsv3**](DevelopmentMemberAPIV30Api.md#view_invited_positionsv3) | **GET** /v3.0/{orcid}/invited-positions | Fetch all invitedPositions
[**view_invited_positionv3**](DevelopmentMemberAPIV30Api.md#view_invited_positionv3) | **GET** /v3.0/{orcid}/invited-position/{putCode} | Fetch an InvitedPosition
[**view_keywordsv3**](DevelopmentMemberAPIV30Api.md#view_keywordsv3) | **GET** /v3.0/{orcid}/keywords | Fetch keywords
[**view_keywordv3**](DevelopmentMemberAPIV30Api.md#view_keywordv3) | **GET** /v3.0/{orcid}/keywords/{putCode} | Fetch keyword
[**view_membership_summaryv3**](DevelopmentMemberAPIV30Api.md#view_membership_summaryv3) | **GET** /v3.0/{orcid}/membership/summary/{putCode} | Fetch an Membership summary
[**view_membershipsv3**](DevelopmentMemberAPIV30Api.md#view_membershipsv3) | **GET** /v3.0/{orcid}/memberships | Fetch all memberships
[**view_membershipv3**](DevelopmentMemberAPIV30Api.md#view_membershipv3) | **GET** /v3.0/{orcid}/membership/{putCode} | Fetch an Membership
[**view_other_namesv3**](DevelopmentMemberAPIV30Api.md#view_other_namesv3) | **GET** /v3.0/{orcid}/other-names | Fetch Other names
[**view_other_namev3**](DevelopmentMemberAPIV30Api.md#view_other_namev3) | **GET** /v3.0/{orcid}/other-names/{putCode} | Fetch Other name
[**view_peer_review_summaryv3**](DevelopmentMemberAPIV30Api.md#view_peer_review_summaryv3) | **GET** /v3.0/{orcid}/peer-review/summary/{putCode} | Fetch a Peer Review Summary
[**view_peer_reviewsv3**](DevelopmentMemberAPIV30Api.md#view_peer_reviewsv3) | **GET** /v3.0/{orcid}/peer-reviews | Fetch all peer reviews
[**view_peer_reviewv3**](DevelopmentMemberAPIV30Api.md#view_peer_reviewv3) | **GET** /v3.0/{orcid}/peer-review/{putCode} | Fetch a Peer Review
[**view_permission_notificationv3**](DevelopmentMemberAPIV30Api.md#view_permission_notificationv3) | **GET** /v3.0/{orcid}/notification-permission/{id} | Fetch a notification by id
[**view_personal_detailsv3**](DevelopmentMemberAPIV30Api.md#view_personal_detailsv3) | **GET** /v3.0/{orcid}/personal-details | Fetch personal details for an ORCID ID
[**view_personv3**](DevelopmentMemberAPIV30Api.md#view_personv3) | **GET** /v3.0/{orcid}/person | Fetch person details
[**view_qualification_summaryv3**](DevelopmentMemberAPIV30Api.md#view_qualification_summaryv3) | **GET** /v3.0/{orcid}/qualification/summary/{putCode} | Fetch an Qualification summary
[**view_qualificationsv3**](DevelopmentMemberAPIV30Api.md#view_qualificationsv3) | **GET** /v3.0/{orcid}/qualifications | Fetch all qualifications
[**view_qualificationv3**](DevelopmentMemberAPIV30Api.md#view_qualificationv3) | **GET** /v3.0/{orcid}/qualification/{putCode} | Fetch an Qualification
[**view_recordv3**](DevelopmentMemberAPIV30Api.md#view_recordv3) | **GET** /v3.0/{orcid} | Fetch record details
[**view_research_resource_summaryv3**](DevelopmentMemberAPIV30Api.md#view_research_resource_summaryv3) | **GET** /v3.0/{orcid}/research-resource/summary/{putCode} | Fetch a Research Resource summary
[**view_research_resourcesv3**](DevelopmentMemberAPIV30Api.md#view_research_resourcesv3) | **GET** /v3.0/{orcid}/research-resources | Fetch all Research Resources
[**view_research_resourcev3**](DevelopmentMemberAPIV30Api.md#view_research_resourcev3) | **GET** /v3.0/{orcid}/research-resource/{putCode} | Fetch a Research Resource
[**view_researcher_urlsv3**](DevelopmentMemberAPIV30Api.md#view_researcher_urlsv3) | **GET** /v3.0/{orcid}/researcher-urls | Fetch all researcher urls for an ORCID ID
[**view_researcher_urlv3**](DevelopmentMemberAPIV30Api.md#view_researcher_urlv3) | **GET** /v3.0/{orcid}/researcher-urls/{putCode} | Fetch one researcher url for an ORCID ID
[**view_service_summaryv3**](DevelopmentMemberAPIV30Api.md#view_service_summaryv3) | **GET** /v3.0/{orcid}/service/summary/{putCode} | Fetch an Service summary
[**view_servicesv3**](DevelopmentMemberAPIV30Api.md#view_servicesv3) | **GET** /v3.0/{orcid}/services | Fetch all services
[**view_servicev3**](DevelopmentMemberAPIV30Api.md#view_servicev3) | **GET** /v3.0/{orcid}/service/{putCode} | Fetch an Service
[**view_specified_worksv3**](DevelopmentMemberAPIV30Api.md#view_specified_worksv3) | **GET** /v3.0/{orcid}/works/{putCodes} | Fetch specified works
[**view_status_json**](DevelopmentMemberAPIV30Api.md#view_status_json) | **GET** /v3.0/apiStatus | 
[**view_work_summaryv3**](DevelopmentMemberAPIV30Api.md#view_work_summaryv3) | **GET** /v3.0/{orcid}/work/summary/{putCode} | Fetch a Work Summary
[**view_worksv3**](DevelopmentMemberAPIV30Api.md#view_worksv3) | **GET** /v3.0/{orcid}/works | Fetch all works
[**view_workv3**](DevelopmentMemberAPIV30Api.md#view_workv3) | **GET** /v3.0/{orcid}/work/{putCode} | Fetch a Work

# **add_permission_notificationv3**
> str add_permission_notificationv3(orcid, body=body)

Add a notification

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.NotificationPermissionV30() # NotificationPermissionV30 |  (optional)

try:
    # Add a notification
    api_response = api_instance.add_permission_notificationv3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->add_permission_notificationv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**NotificationPermissionV30**](NotificationPermissionV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_addressv3**
> create_addressv3(orcid, body=body)

Add an address

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.AddressV30() # AddressV30 |  (optional)

try:
    # Add an address
    api_instance.create_addressv3(orcid, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_addressv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**AddressV30**](AddressV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_distinctionv3**
> str create_distinctionv3(orcid, body=body)

Create an Distinction

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.DistinctionV30() # DistinctionV30 |  (optional)

try:
    # Create an Distinction
    api_response = api_instance.create_distinctionv3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_distinctionv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**DistinctionV30**](DistinctionV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_educationv3**
> str create_educationv3(orcid, body=body)

Create an Education

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.EducationV30() # EducationV30 |  (optional)

try:
    # Create an Education
    api_response = api_instance.create_educationv3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_educationv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**EducationV30**](EducationV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_employmentv3**
> str create_employmentv3(orcid, body=body)

Create an Employment

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.EmploymentV30() # EmploymentV30 |  (optional)

try:
    # Create an Employment
    api_response = api_instance.create_employmentv3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_employmentv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**EmploymentV30**](EmploymentV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_external_identifierv3**
> create_external_identifierv3(orcid, body=body)

Add external identifier

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.PersonExternalIdentifierV30() # PersonExternalIdentifierV30 |  (optional)

try:
    # Add external identifier
    api_instance.create_external_identifierv3(orcid, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_external_identifierv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**PersonExternalIdentifierV30**](PersonExternalIdentifierV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_fundingv3**
> str create_fundingv3(orcid, body=body)

Create a Funding

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.FundingV30() # FundingV30 |  (optional)

try:
    # Create a Funding
    api_response = api_instance.create_fundingv3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_fundingv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**FundingV30**](FundingV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_group_id_recordv3**
> create_group_id_recordv3(body=body)

Create a Group

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
body = orcid_api_v3.GroupIdRecord() # GroupIdRecord |  (optional)

try:
    # Create a Group
    api_instance.create_group_id_recordv3(body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_group_id_recordv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**GroupIdRecord**](GroupIdRecord.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_invited_positionv3**
> str create_invited_positionv3(orcid, body=body)

Create an InvitedPosition

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.InvitedPositionV30() # InvitedPositionV30 |  (optional)

try:
    # Create an InvitedPosition
    api_response = api_instance.create_invited_positionv3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_invited_positionv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**InvitedPositionV30**](InvitedPositionV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_keywordv3**
> create_keywordv3(orcid, body=body)

Add keyword

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.KeywordV30() # KeywordV30 |  (optional)

try:
    # Add keyword
    api_instance.create_keywordv3(orcid, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_keywordv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**KeywordV30**](KeywordV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_membershipv3**
> str create_membershipv3(orcid, body=body)

Create an Membership

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.MembershipV30() # MembershipV30 |  (optional)

try:
    # Create an Membership
    api_response = api_instance.create_membershipv3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_membershipv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**MembershipV30**](MembershipV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_other_namev3**
> create_other_namev3(orcid, body=body)

Add other name

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.OtherNameV30() # OtherNameV30 |  (optional)

try:
    # Add other name
    api_instance.create_other_namev3(orcid, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_other_namev3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**OtherNameV30**](OtherNameV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_peer_reviewv3**
> str create_peer_reviewv3(orcid, body=body)

Create a Peer Review

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.PeerReviewV30() # PeerReviewV30 |  (optional)

try:
    # Create a Peer Review
    api_response = api_instance.create_peer_reviewv3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_peer_reviewv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**PeerReviewV30**](PeerReviewV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_qualificationv3**
> str create_qualificationv3(orcid, body=body)

Create an Qualification

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.QualificationV30() # QualificationV30 |  (optional)

try:
    # Create an Qualification
    api_response = api_instance.create_qualificationv3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_qualificationv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**QualificationV30**](QualificationV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_research_resourcev3**
> str create_research_resourcev3(orcid, body=body)

Create a Research Resource

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.ResearchResourceV30() # ResearchResourceV30 |  (optional)

try:
    # Create a Research Resource
    api_response = api_instance.create_research_resourcev3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_research_resourcev3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**ResearchResourceV30**](ResearchResourceV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_researcher_urlv3**
> create_researcher_urlv3(orcid, body=body)

Add a new researcher url for an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.ResearcherUrlV30() # ResearcherUrlV30 |  (optional)

try:
    # Add a new researcher url for an ORCID ID
    api_instance.create_researcher_urlv3(orcid, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_researcher_urlv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**ResearcherUrlV30**](ResearcherUrlV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_servicev3**
> str create_servicev3(orcid, body=body)

Create an Service

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.ServiceV30() # ServiceV30 |  (optional)

try:
    # Create an Service
    api_response = api_instance.create_servicev3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_servicev3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**ServiceV30**](ServiceV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_worksv3**
> str create_worksv3(orcid, body=body)

Create a listo of Work

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.WorkBulkV30() # WorkBulkV30 |  (optional)

try:
    # Create a listo of Work
    api_response = api_instance.create_worksv3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_worksv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**WorkBulkV30**](WorkBulkV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_workv3**
> str create_workv3(orcid, body=body)

Create a Work

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.WorkV30() # WorkV30 |  (optional)

try:
    # Create a Work
    api_response = api_instance.create_workv3(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->create_workv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**WorkV30**](WorkV30.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_addressv3**
> delete_addressv3(orcid, put_code)

Delete an address

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an address
    api_instance.delete_addressv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_addressv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_distinctionv3**
> delete_distinctionv3(orcid, put_code)

Delete an Distinction

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Distinction
    api_instance.delete_distinctionv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_distinctionv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_educationv3**
> delete_educationv3(orcid, put_code)

Delete an Education

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Education
    api_instance.delete_educationv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_educationv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_employmentv3**
> delete_employmentv3(orcid, put_code)

Delete an Employment

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Employment
    api_instance.delete_employmentv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_employmentv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_external_identifierv3**
> delete_external_identifierv3(orcid, put_code)

Delete external identifier

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete external identifier
    api_instance.delete_external_identifierv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_external_identifierv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_fundingv3**
> delete_fundingv3(orcid, put_code)

Delete a Funding

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete a Funding
    api_instance.delete_fundingv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_fundingv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_group_id_recordv3**
> delete_group_id_recordv3(put_code)

Delete a Group

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
put_code = 'put_code_example' # str | 

try:
    # Delete a Group
    api_instance.delete_group_id_recordv3(put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_group_id_recordv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_invited_positionv3**
> delete_invited_positionv3(orcid, put_code)

Delete an InvitedPosition

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an InvitedPosition
    api_instance.delete_invited_positionv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_invited_positionv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_keywordv3**
> delete_keywordv3(orcid, put_code)

Delete keyword

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete keyword
    api_instance.delete_keywordv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_keywordv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_membershipv3**
> delete_membershipv3(orcid, put_code)

Delete an Membership

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Membership
    api_instance.delete_membershipv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_membershipv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_other_namev3**
> delete_other_namev3(orcid, put_code)

Delete other name

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete other name
    api_instance.delete_other_namev3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_other_namev3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_peer_reviewv3**
> delete_peer_reviewv3(orcid, put_code)

Delete a Peer Review

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete a Peer Review
    api_instance.delete_peer_reviewv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_peer_reviewv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_qualificationv3**
> delete_qualificationv3(orcid, put_code)

Delete an Qualification

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Qualification
    api_instance.delete_qualificationv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_qualificationv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_research_resourcev3**
> delete_research_resourcev3(orcid, put_code)

Delete an Research Resource

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Research Resource
    api_instance.delete_research_resourcev3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_research_resourcev3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_researcher_urlv3**
> delete_researcher_urlv3(orcid, put_code)

Delete one researcher url from an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete one researcher url from an ORCID ID
    api_instance.delete_researcher_urlv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_researcher_urlv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_servicev3**
> delete_servicev3(orcid, put_code)

Delete an Service

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Service
    api_instance.delete_servicev3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_servicev3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_workv3**
> delete_workv3(orcid, put_code)

Delete a Work

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete a Work
    api_instance.delete_workv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->delete_workv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_addressv3**
> edit_addressv3(orcid, put_code, body=body)

Edit an address

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.AddressV30() # AddressV30 |  (optional)

try:
    # Edit an address
    api_instance.edit_addressv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->edit_addressv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**AddressV30**](AddressV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_external_identifierv3**
> edit_external_identifierv3(orcid, put_code, body=body)

Edit external identifier

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.PersonExternalIdentifierV30() # PersonExternalIdentifierV30 |  (optional)

try:
    # Edit external identifier
    api_instance.edit_external_identifierv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->edit_external_identifierv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**PersonExternalIdentifierV30**](PersonExternalIdentifierV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_keywordv3**
> edit_keywordv3(orcid, put_code, body=body)

Edit keyword

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.KeywordV30() # KeywordV30 |  (optional)

try:
    # Edit keyword
    api_instance.edit_keywordv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->edit_keywordv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**KeywordV30**](KeywordV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_other_namev3**
> edit_other_namev3(orcid, put_code, body=body)

Edit other name

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.OtherNameV30() # OtherNameV30 |  (optional)

try:
    # Edit other name
    api_instance.edit_other_namev3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->edit_other_namev3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**OtherNameV30**](OtherNameV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_researcher_urlv3**
> edit_researcher_urlv3(orcid, put_code, body=body)

Edits researcher url for an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.ResearcherUrlV30() # ResearcherUrlV30 |  (optional)

try:
    # Edits researcher url for an ORCID ID
    api_instance.edit_researcher_urlv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->edit_researcher_urlv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**ResearcherUrlV30**](ResearcherUrlV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **flag_as_archived_permission_notificationv3**
> Notification flag_as_archived_permission_notificationv3(orcid, id)

Archive a notification

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
id = 789 # int | 

try:
    # Archive a notification
    api_response = api_instance.flag_as_archived_permission_notificationv3(orcid, id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->flag_as_archived_permission_notificationv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **id** | **int**|  | 

### Return type

[**Notification**](Notification.md)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **search_by_queryv3**
> SearchV30 search_by_queryv3(q=q)

Search records

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
q = 'q_example' # str |  (optional)

try:
    # Search records
    api_response = api_instance.search_by_queryv3(q=q)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->search_by_queryv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q** | **str**|  | [optional] 

### Return type

[**SearchV30**](SearchV30.md)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_distinctionv3**
> update_distinctionv3(orcid, put_code, body=body)

Update an Distinction

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.DistinctionV30() # DistinctionV30 |  (optional)

try:
    # Update an Distinction
    api_instance.update_distinctionv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->update_distinctionv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**DistinctionV30**](DistinctionV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_educationv3**
> update_educationv3(orcid, put_code, body=body)

Update an Education

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.EducationV30() # EducationV30 |  (optional)

try:
    # Update an Education
    api_instance.update_educationv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->update_educationv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**EducationV30**](EducationV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_employmentv3**
> update_employmentv3(orcid, put_code, body=body)

Update an Employment

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.EmploymentV30() # EmploymentV30 |  (optional)

try:
    # Update an Employment
    api_instance.update_employmentv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->update_employmentv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**EmploymentV30**](EmploymentV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_fundingv3**
> update_fundingv3(orcid, put_code, body=body)

Update a Funding

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.FundingV30() # FundingV30 |  (optional)

try:
    # Update a Funding
    api_instance.update_fundingv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->update_fundingv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**FundingV30**](FundingV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_group_id_recordv3**
> update_group_id_recordv3(put_code, body=body)

Update a Group

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
put_code = 'put_code_example' # str | 
body = orcid_api_v3.GroupIdRecord() # GroupIdRecord |  (optional)

try:
    # Update a Group
    api_instance.update_group_id_recordv3(put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->update_group_id_recordv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **put_code** | **str**|  | 
 **body** | [**GroupIdRecord**](GroupIdRecord.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_invited_positionv3**
> update_invited_positionv3(orcid, put_code, body=body)

Update an InvitedPosition

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.InvitedPositionV30() # InvitedPositionV30 |  (optional)

try:
    # Update an InvitedPosition
    api_instance.update_invited_positionv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->update_invited_positionv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**InvitedPositionV30**](InvitedPositionV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_membershipv3**
> update_membershipv3(orcid, put_code, body=body)

Update an Membership

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.MembershipV30() # MembershipV30 |  (optional)

try:
    # Update an Membership
    api_instance.update_membershipv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->update_membershipv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**MembershipV30**](MembershipV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_peer_reviewv3**
> update_peer_reviewv3(orcid, put_code, body=body)

Update a Peer Review

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.PeerReviewV30() # PeerReviewV30 |  (optional)

try:
    # Update a Peer Review
    api_instance.update_peer_reviewv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->update_peer_reviewv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**PeerReviewV30**](PeerReviewV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_qualificationv3**
> update_qualificationv3(orcid, put_code, body=body)

Update an Qualification

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.QualificationV30() # QualificationV30 |  (optional)

try:
    # Update an Qualification
    api_instance.update_qualificationv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->update_qualificationv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**QualificationV30**](QualificationV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_research_resourcev3**
> update_research_resourcev3(orcid, put_code, body=body)

Update a Research Resource

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.ResearchResourceV30() # ResearchResourceV30 |  (optional)

try:
    # Update a Research Resource
    api_instance.update_research_resourcev3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->update_research_resourcev3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**ResearchResourceV30**](ResearchResourceV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_servicev3**
> update_servicev3(orcid, put_code, body=body)

Update an Service

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.ServiceV30() # ServiceV30 |  (optional)

try:
    # Update an Service
    api_instance.update_servicev3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->update_servicev3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**ServiceV30**](ServiceV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_workv3**
> update_workv3(orcid, put_code, body=body)

Update a Work

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.WorkV30() # WorkV30 |  (optional)

try:
    # Update a Work
    api_instance.update_workv3(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->update_workv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**WorkV30**](WorkV30.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_activitiesv3**
> ActivitiesSummaryV30 view_activitiesv3(orcid)

Fetch all activities

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all activities
    api_response = api_instance.view_activitiesv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_activitiesv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**ActivitiesSummaryV30**](ActivitiesSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_addressesv3**
> AddressesV30 view_addressesv3(orcid)

Fetch all addresses of a profile

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all addresses of a profile
    api_response = api_instance.view_addressesv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_addressesv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**AddressesV30**](AddressesV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_addressv3**
> view_addressv3(orcid, put_code)

Fetch an address

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an address
    api_instance.view_addressv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_addressv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_biographyv3**
> BiographyV30 view_biographyv3(orcid)

Get biography details

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Get biography details
    api_response = api_instance.view_biographyv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_biographyv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**BiographyV30**](BiographyV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_clientv3**
> view_clientv3(client_id)

Fetch client details

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
client_id = 'client_id_example' # str | 

try:
    # Fetch client details
    api_instance.view_clientv3(client_id)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_clientv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **client_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_distinction_summaryv3**
> DistinctionSummaryV30 view_distinction_summaryv3(orcid, put_code)

Fetch an Distinction summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Distinction summary
    api_response = api_instance.view_distinction_summaryv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_distinction_summaryv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**DistinctionSummaryV30**](DistinctionSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_distinctionsv3**
> DistinctionsSummaryV30 view_distinctionsv3(orcid)

Fetch all distinctions

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all distinctions
    api_response = api_instance.view_distinctionsv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_distinctionsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**DistinctionsSummaryV30**](DistinctionsSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_distinctionv3**
> DistinctionV30 view_distinctionv3(orcid, put_code)

Fetch an Distinction

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Distinction
    api_response = api_instance.view_distinctionv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_distinctionv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**DistinctionV30**](DistinctionV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_education_summaryv3**
> EducationSummaryV30 view_education_summaryv3(orcid, put_code)

Fetch an Education summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Education summary
    api_response = api_instance.view_education_summaryv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_education_summaryv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**EducationSummaryV30**](EducationSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_educationsv3**
> EducationsSummaryV30 view_educationsv3(orcid)

Fetch all educations

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all educations
    api_response = api_instance.view_educationsv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_educationsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**EducationsSummaryV30**](EducationsSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_educationv3**
> EducationV30 view_educationv3(orcid, put_code)

Fetch an Education

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Education
    api_response = api_instance.view_educationv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_educationv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**EducationV30**](EducationV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_emailsv3**
> view_emailsv3(orcid)

Fetch all emails for an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all emails for an ORCID ID
    api_instance.view_emailsv3(orcid)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_emailsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_employment_summaryv3**
> EmploymentSummaryV30 view_employment_summaryv3(orcid, put_code)

Fetch an Employment Summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Employment Summary
    api_response = api_instance.view_employment_summaryv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_employment_summaryv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**EmploymentSummaryV30**](EmploymentSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_employmentsv3**
> EmploymentsSummaryV30 view_employmentsv3(orcid)

Fetch all employments

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all employments
    api_response = api_instance.view_employmentsv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_employmentsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**EmploymentsSummaryV30**](EmploymentsSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_employmentv3**
> EmploymentV30 view_employmentv3(orcid, put_code)

Fetch an Employment

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Employment
    api_response = api_instance.view_employmentv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_employmentv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**EmploymentV30**](EmploymentV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_external_identifiersv3**
> view_external_identifiersv3(orcid)

Fetch external identifiers

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch external identifiers
    api_instance.view_external_identifiersv3(orcid)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_external_identifiersv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_external_identifierv3**
> view_external_identifierv3(orcid, put_code)

Fetch external identifier

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch external identifier
    api_instance.view_external_identifierv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_external_identifierv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_funding_summaryv3**
> FundingSummaryV30 view_funding_summaryv3(orcid, put_code)

Fetch a Funding Summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Funding Summary
    api_response = api_instance.view_funding_summaryv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_funding_summaryv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**FundingSummaryV30**](FundingSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_fundingsv3**
> FundingsV30 view_fundingsv3(orcid)

Fetch all fundings

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all fundings
    api_response = api_instance.view_fundingsv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_fundingsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**FundingsV30**](FundingsV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_fundingv3**
> FundingV30 view_fundingv3(orcid, put_code)

Fetch a Funding

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Funding
    api_response = api_instance.view_fundingv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_fundingv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**FundingV30**](FundingV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_group_id_recordsv3**
> GroupIdRecords view_group_id_recordsv3(page_size=page_size, page=page, name=name, group_id=group_id)

Fetch Groups

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
page_size = 'page_size_example' # str |  (optional)
page = 'page_example' # str |  (optional)
name = 'name_example' # str |  (optional)
group_id = 'group_id_example' # str |  (optional)

try:
    # Fetch Groups
    api_response = api_instance.view_group_id_recordsv3(page_size=page_size, page=page, name=name, group_id=group_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_group_id_recordsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **str**|  | [optional] 
 **page** | **str**|  | [optional] 
 **name** | **str**|  | [optional] 
 **group_id** | **str**|  | [optional] 

### Return type

[**GroupIdRecords**](GroupIdRecords.md)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_group_id_recordv3**
> GroupIdRecord view_group_id_recordv3(put_code)

Fetch a Group

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
put_code = 'put_code_example' # str | 

try:
    # Fetch a Group
    api_response = api_instance.view_group_id_recordv3(put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_group_id_recordv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **put_code** | **str**|  | 

### Return type

[**GroupIdRecord**](GroupIdRecord.md)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_invited_position_summaryv3**
> InvitedPositionSummaryV30 view_invited_position_summaryv3(orcid, put_code)

Fetch an InvitedPosition summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an InvitedPosition summary
    api_response = api_instance.view_invited_position_summaryv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_invited_position_summaryv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**InvitedPositionSummaryV30**](InvitedPositionSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_invited_positionsv3**
> InvitedPositionsV30 view_invited_positionsv3(orcid)

Fetch all invitedPositions

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all invitedPositions
    api_response = api_instance.view_invited_positionsv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_invited_positionsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**InvitedPositionsV30**](InvitedPositionsV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_invited_positionv3**
> InvitedPositionV30 view_invited_positionv3(orcid, put_code)

Fetch an InvitedPosition

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an InvitedPosition
    api_response = api_instance.view_invited_positionv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_invited_positionv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**InvitedPositionV30**](InvitedPositionV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_keywordsv3**
> view_keywordsv3(orcid)

Fetch keywords

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch keywords
    api_instance.view_keywordsv3(orcid)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_keywordsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_keywordv3**
> view_keywordv3(orcid, put_code)

Fetch keyword

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch keyword
    api_instance.view_keywordv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_keywordv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_membership_summaryv3**
> MembershipSummaryV30 view_membership_summaryv3(orcid, put_code)

Fetch an Membership summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Membership summary
    api_response = api_instance.view_membership_summaryv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_membership_summaryv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**MembershipSummaryV30**](MembershipSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_membershipsv3**
> MembershipsV30 view_membershipsv3(orcid)

Fetch all memberships

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all memberships
    api_response = api_instance.view_membershipsv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_membershipsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**MembershipsV30**](MembershipsV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_membershipv3**
> MembershipV30 view_membershipv3(orcid, put_code)

Fetch an Membership

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Membership
    api_response = api_instance.view_membershipv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_membershipv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**MembershipV30**](MembershipV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_other_namesv3**
> view_other_namesv3(orcid)

Fetch Other names

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch Other names
    api_instance.view_other_namesv3(orcid)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_other_namesv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_other_namev3**
> view_other_namev3(orcid, put_code)

Fetch Other name

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch Other name
    api_instance.view_other_namev3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_other_namev3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_peer_review_summaryv3**
> PeerReviewSummaryV30 view_peer_review_summaryv3(orcid, put_code)

Fetch a Peer Review Summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Peer Review Summary
    api_response = api_instance.view_peer_review_summaryv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_peer_review_summaryv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**PeerReviewSummaryV30**](PeerReviewSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_peer_reviewsv3**
> PeerReviewsV30 view_peer_reviewsv3(orcid)

Fetch all peer reviews

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all peer reviews
    api_response = api_instance.view_peer_reviewsv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_peer_reviewsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**PeerReviewsV30**](PeerReviewsV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_peer_reviewv3**
> PeerReviewV30 view_peer_reviewv3(orcid, put_code)

Fetch a Peer Review

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Peer Review
    api_response = api_instance.view_peer_reviewv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_peer_reviewv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**PeerReviewV30**](PeerReviewV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_permission_notificationv3**
> Notification view_permission_notificationv3(orcid, id)

Fetch a notification by id

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
id = 789 # int | 

try:
    # Fetch a notification by id
    api_response = api_instance.view_permission_notificationv3(orcid, id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_permission_notificationv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **id** | **int**|  | 

### Return type

[**Notification**](Notification.md)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_personal_detailsv3**
> PersonalDetailsV30 view_personal_detailsv3(orcid)

Fetch personal details for an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch personal details for an ORCID ID
    api_response = api_instance.view_personal_detailsv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_personal_detailsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**PersonalDetailsV30**](PersonalDetailsV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_personv3**
> view_personv3(orcid)

Fetch person details

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch person details
    api_instance.view_personv3(orcid)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_personv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_qualification_summaryv3**
> QualificationSummaryV30 view_qualification_summaryv3(orcid, put_code)

Fetch an Qualification summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Qualification summary
    api_response = api_instance.view_qualification_summaryv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_qualification_summaryv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**QualificationSummaryV30**](QualificationSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_qualificationsv3**
> QualificationsV30 view_qualificationsv3(orcid)

Fetch all qualifications

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all qualifications
    api_response = api_instance.view_qualificationsv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_qualificationsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**QualificationsV30**](QualificationsV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_qualificationv3**
> QualificationV30 view_qualificationv3(orcid, put_code)

Fetch an Qualification

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Qualification
    api_response = api_instance.view_qualificationv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_qualificationv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**QualificationV30**](QualificationV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_recordv3**
> RecordV30 view_recordv3(orcid)

Fetch record details

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch record details
    api_response = api_instance.view_recordv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_recordv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**RecordV30**](RecordV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_research_resource_summaryv3**
> ResearchResourceSummaryV30 view_research_resource_summaryv3(orcid, put_code)

Fetch a Research Resource summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Research Resource summary
    api_response = api_instance.view_research_resource_summaryv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_research_resource_summaryv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**ResearchResourceSummaryV30**](ResearchResourceSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_research_resourcesv3**
> ResearchResourcesV30 view_research_resourcesv3(orcid)

Fetch all Research Resources

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all Research Resources
    api_response = api_instance.view_research_resourcesv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_research_resourcesv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**ResearchResourcesV30**](ResearchResourcesV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_research_resourcev3**
> ResearchResourceV30 view_research_resourcev3(orcid, put_code)

Fetch a Research Resource

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Research Resource
    api_response = api_instance.view_research_resourcev3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_research_resourcev3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**ResearchResourceV30**](ResearchResourceV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_researcher_urlsv3**
> view_researcher_urlsv3(orcid)

Fetch all researcher urls for an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all researcher urls for an ORCID ID
    api_instance.view_researcher_urlsv3(orcid)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_researcher_urlsv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_researcher_urlv3**
> view_researcher_urlv3(orcid, put_code)

Fetch one researcher url for an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch one researcher url for an ORCID ID
    api_instance.view_researcher_urlv3(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_researcher_urlv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_service_summaryv3**
> ServiceSummaryV30 view_service_summaryv3(orcid, put_code)

Fetch an Service summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Service summary
    api_response = api_instance.view_service_summaryv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_service_summaryv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**ServiceSummaryV30**](ServiceSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_servicesv3**
> ServicesV30 view_servicesv3(orcid)

Fetch all services

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all services
    api_response = api_instance.view_servicesv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_servicesv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**ServicesV30**](ServicesV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_servicev3**
> ServiceV30 view_servicev3(orcid, put_code)

Fetch an Service

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Service
    api_response = api_instance.view_servicev3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_servicev3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**ServiceV30**](ServiceV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_specified_worksv3**
> WorkBulkV30 view_specified_worksv3(orcid, put_codes)

Fetch specified works

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_codes = 'put_codes_example' # str | 

try:
    # Fetch specified works
    api_response = api_instance.view_specified_worksv3(orcid, put_codes)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_specified_worksv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_codes** | **str**|  | 

### Return type

[**WorkBulkV30**](WorkBulkV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_status_json**
> view_status_json()



### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api()

try:
    api_instance.view_status_json()
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_status_json: %s\n" % e)
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_work_summaryv3**
> WorkSummaryV30 view_work_summaryv3(orcid, put_code)

Fetch a Work Summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Work Summary
    api_response = api_instance.view_work_summaryv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_work_summaryv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**WorkSummaryV30**](WorkSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_worksv3**
> WorksSummaryV30 view_worksv3(orcid)

Fetch all works

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all works
    api_response = api_instance.view_worksv3(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_worksv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**WorksSummaryV30**](WorksSummaryV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_workv3**
> WorkV30 view_workv3(orcid, put_code)

Fetch a Work

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Work
    api_response = api_instance.view_workv3(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Api->view_workv3: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**WorkV30**](WorkV30.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

