# orcid_api_v3.DevelopmentMemberAPIV30Rc1Api

All URIs are relative to *//api.orcid.org/*

Method | HTTP request | Description
------------- | ------------- | -------------
[**add_permission_notification_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#add_permission_notification_v3_rc1) | **POST** /v3.0_rc1/{orcid}/notification-permission | Add a notification
[**create_address_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_address_v3_rc1) | **POST** /v3.0_rc1/{orcid}/address | Add an address
[**create_distinction_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_distinction_v3_rc1) | **POST** /v3.0_rc1/{orcid}/distinction | Create an Distinction
[**create_education_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_education_v3_rc1) | **POST** /v3.0_rc1/{orcid}/education | Create an Education
[**create_employment_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_employment_v3_rc1) | **POST** /v3.0_rc1/{orcid}/employment | Create an Employment
[**create_external_identifier_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_external_identifier_v3_rc1) | **POST** /v3.0_rc1/{orcid}/external-identifiers | Add external identifier
[**create_funding_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_funding_v3_rc1) | **POST** /v3.0_rc1/{orcid}/funding | Create a Funding
[**create_group_id_record_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_group_id_record_v3_rc1) | **POST** /v3.0_rc1/group-id-record | Create a Group
[**create_invited_position_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_invited_position_v3_rc1) | **POST** /v3.0_rc1/{orcid}/invited-position | Create an InvitedPosition
[**create_keyword_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_keyword_v3_rc1) | **POST** /v3.0_rc1/{orcid}/keywords | Add keyword
[**create_membership_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_membership_v3_rc1) | **POST** /v3.0_rc1/{orcid}/membership | Create an Membership
[**create_other_name_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_other_name_v3_rc1) | **POST** /v3.0_rc1/{orcid}/other-names | Add other name
[**create_peer_review_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_peer_review_v3_rc1) | **POST** /v3.0_rc1/{orcid}/peer-review | Create a Peer Review
[**create_qualification_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_qualification_v3_rc1) | **POST** /v3.0_rc1/{orcid}/qualification | Create an Qualification
[**create_research_resource_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_research_resource_v3_rc1) | **POST** /v3.0_rc1/{orcid}/research-resource | Create a Research Resource
[**create_researcher_url_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_researcher_url_v3_rc1) | **POST** /v3.0_rc1/{orcid}/researcher-urls | Add a new researcher url for an ORCID ID
[**create_service_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_service_v3_rc1) | **POST** /v3.0_rc1/{orcid}/service | Create an Service
[**create_work_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_work_v3_rc1) | **POST** /v3.0_rc1/{orcid}/work | Create a Work
[**create_works_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#create_works_v3_rc1) | **POST** /v3.0_rc1/{orcid}/works | Create a listo of Work
[**delete_address_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_address_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/address/{putCode} | Delete an address
[**delete_distinction_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_distinction_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/distinction/{putCode} | Delete an Distinction
[**delete_education_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_education_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/education/{putCode} | Delete an Education
[**delete_employment_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_employment_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/employment/{putCode} | Delete an Employment
[**delete_external_identifier_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_external_identifier_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/external-identifiers/{putCode} | Delete external identifier
[**delete_funding_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_funding_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/funding/{putCode} | Delete a Funding
[**delete_group_id_record_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_group_id_record_v3_rc1) | **DELETE** /v3.0_rc1/group-id-record/{putCode} | Delete a Group
[**delete_invited_position_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_invited_position_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/invited-position/{putCode} | Delete an InvitedPosition
[**delete_keyword_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_keyword_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/keywords/{putCode} | Delete keyword
[**delete_membership_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_membership_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/membership/{putCode} | Delete an Membership
[**delete_other_name_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_other_name_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/other-names/{putCode} | Delete other name
[**delete_peer_review_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_peer_review_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/peer-review/{putCode} | Delete a Peer Review
[**delete_qualification_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_qualification_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/qualification/{putCode} | Delete an Qualification
[**delete_research_resource_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_research_resource_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/research-resource/{putCode} | Delete an Research Resource
[**delete_researcher_url_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_researcher_url_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/researcher-urls/{putCode} | Delete one researcher url from an ORCID ID
[**delete_service_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_service_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/service/{putCode} | Delete an Service
[**delete_work_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#delete_work_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/work/{putCode} | Delete a Work
[**edit_address_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#edit_address_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/address/{putCode} | Edit an address
[**edit_external_identifier_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#edit_external_identifier_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/external-identifiers/{putCode} | Edit external identifier
[**edit_keyword_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#edit_keyword_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/keywords/{putCode} | Edit keyword
[**edit_other_name_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#edit_other_name_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/other-names/{putCode} | Edit other name
[**edit_researcher_url_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#edit_researcher_url_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/researcher-urls/{putCode} | Edits researcher url for an ORCID ID
[**flag_as_archived_permission_notification_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#flag_as_archived_permission_notification_v3_rc1) | **DELETE** /v3.0_rc1/{orcid}/notification-permission/{id} | Archive a notification
[**search_by_query_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#search_by_query_v3_rc1) | **GET** /v3.0_rc1/search | Search records
[**update_distinction_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#update_distinction_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/distinction/{putCode} | Update an Distinction
[**update_education_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#update_education_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/education/{putCode} | Update an Education
[**update_employment_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#update_employment_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/employment/{putCode} | Update an Employment
[**update_funding_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#update_funding_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/funding/{putCode} | Update a Funding
[**update_group_id_record_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#update_group_id_record_v3_rc1) | **PUT** /v3.0_rc1/group-id-record/{putCode} | Update a Group
[**update_invited_position_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#update_invited_position_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/invited-position/{putCode} | Update an InvitedPosition
[**update_membership_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#update_membership_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/membership/{putCode} | Update an Membership
[**update_peer_review_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#update_peer_review_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/peer-review/{putCode} | Update a Peer Review
[**update_qualification_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#update_qualification_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/qualification/{putCode} | Update an Qualification
[**update_research_resource_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#update_research_resource_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/research-resource/{putCode} | Update a Research Resource
[**update_service_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#update_service_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/service/{putCode} | Update an Service
[**update_work_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#update_work_v3_rc1) | **PUT** /v3.0_rc1/{orcid}/work/{putCode} | Update a Work
[**view_activities_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_activities_v3_rc1) | **GET** /v3.0_rc1/{orcid}/activities | Fetch all activities
[**view_address_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_address_v3_rc1) | **GET** /v3.0_rc1/{orcid}/address/{putCode} | Fetch an address
[**view_addresses_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_addresses_v3_rc1) | **GET** /v3.0_rc1/{orcid}/address | Fetch all addresses of a profile
[**view_biography_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_biography_v3_rc1) | **GET** /v3.0_rc1/{orcid}/biography | Get biography details
[**view_client_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_client_v3_rc1) | **GET** /v3.0_rc1/client/{client_id} | Fetch client details
[**view_distinction_summary_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_distinction_summary_v3_rc1) | **GET** /v3.0_rc1/{orcid}/distinction/summary/{putCode} | Fetch an Distinction summary
[**view_distinction_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_distinction_v3_rc1) | **GET** /v3.0_rc1/{orcid}/distinction/{putCode} | Fetch an Distinction
[**view_distinctions_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_distinctions_v3_rc1) | **GET** /v3.0_rc1/{orcid}/distinctions | Fetch all distinctions
[**view_education_summary_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_education_summary_v3_rc1) | **GET** /v3.0_rc1/{orcid}/education/summary/{putCode} | Fetch an Education summary
[**view_education_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_education_v3_rc1) | **GET** /v3.0_rc1/{orcid}/education/{putCode} | Fetch an Education
[**view_educations_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_educations_v3_rc1) | **GET** /v3.0_rc1/{orcid}/educations | Fetch all educations
[**view_emails_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_emails_v3_rc1) | **GET** /v3.0_rc1/{orcid}/email | Fetch all emails for an ORCID ID
[**view_employment_summary_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_employment_summary_v3_rc1) | **GET** /v3.0_rc1/{orcid}/employment/summary/{putCode} | Fetch an Employment Summary
[**view_employment_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_employment_v3_rc1) | **GET** /v3.0_rc1/{orcid}/employment/{putCode} | Fetch an Employment
[**view_employments_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_employments_v3_rc1) | **GET** /v3.0_rc1/{orcid}/employments | Fetch all employments
[**view_external_identifier_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_external_identifier_v3_rc1) | **GET** /v3.0_rc1/{orcid}/external-identifiers/{putCode} | Fetch external identifier
[**view_external_identifiers_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_external_identifiers_v3_rc1) | **GET** /v3.0_rc1/{orcid}/external-identifiers | Fetch external identifiers
[**view_funding_summary_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_funding_summary_v3_rc1) | **GET** /v3.0_rc1/{orcid}/funding/summary/{putCode} | Fetch a Funding Summary
[**view_funding_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_funding_v3_rc1) | **GET** /v3.0_rc1/{orcid}/funding/{putCode} | Fetch a Funding
[**view_fundings_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_fundings_v3_rc1) | **GET** /v3.0_rc1/{orcid}/fundings | Fetch all fundings
[**view_group_id_record_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_group_id_record_v3_rc1) | **GET** /v3.0_rc1/group-id-record/{putCode} | Fetch a Group
[**view_group_id_records_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_group_id_records_v3_rc1) | **GET** /v3.0_rc1/group-id-record | Fetch Groups
[**view_invited_position_summary_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_invited_position_summary_v3_rc1) | **GET** /v3.0_rc1/{orcid}/invited-position/summary/{putCode} | Fetch an InvitedPosition summary
[**view_invited_position_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_invited_position_v3_rc1) | **GET** /v3.0_rc1/{orcid}/invited-position/{putCode} | Fetch an InvitedPosition
[**view_invited_positions_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_invited_positions_v3_rc1) | **GET** /v3.0_rc1/{orcid}/invited-positions | Fetch all invitedPositions
[**view_keyword_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_keyword_v3_rc1) | **GET** /v3.0_rc1/{orcid}/keywords/{putCode} | Fetch keyword
[**view_keywords_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_keywords_v3_rc1) | **GET** /v3.0_rc1/{orcid}/keywords | Fetch keywords
[**view_membership_summary_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_membership_summary_v3_rc1) | **GET** /v3.0_rc1/{orcid}/membership/summary/{putCode} | Fetch an Membership summary
[**view_membership_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_membership_v3_rc1) | **GET** /v3.0_rc1/{orcid}/membership/{putCode} | Fetch an Membership
[**view_memberships_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_memberships_v3_rc1) | **GET** /v3.0_rc1/{orcid}/memberships | Fetch all memberships
[**view_other_name_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_other_name_v3_rc1) | **GET** /v3.0_rc1/{orcid}/other-names/{putCode} | Fetch Other name
[**view_other_names_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_other_names_v3_rc1) | **GET** /v3.0_rc1/{orcid}/other-names | Fetch Other names
[**view_peer_review_summary_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_peer_review_summary_v3_rc1) | **GET** /v3.0_rc1/{orcid}/peer-review/summary/{putCode} | Fetch a Peer Review Summary
[**view_peer_review_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_peer_review_v3_rc1) | **GET** /v3.0_rc1/{orcid}/peer-review/{putCode} | Fetch a Peer Review
[**view_peer_reviews_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_peer_reviews_v3_rc1) | **GET** /v3.0_rc1/{orcid}/peer-reviews | Fetch all peer reviews
[**view_permission_notification_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_permission_notification_v3_rc1) | **GET** /v3.0_rc1/{orcid}/notification-permission/{id} | Fetch a notification by id
[**view_person_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_person_v3_rc1) | **GET** /v3.0_rc1/{orcid}/person | Fetch person details
[**view_personal_details_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_personal_details_v3_rc1) | **GET** /v3.0_rc1/{orcid}/personal-details | Fetch personal details for an ORCID ID
[**view_qualification_summary_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_qualification_summary_v3_rc1) | **GET** /v3.0_rc1/{orcid}/qualification/summary/{putCode} | Fetch an Qualification summary
[**view_qualification_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_qualification_v3_rc1) | **GET** /v3.0_rc1/{orcid}/qualification/{putCode} | Fetch an Qualification
[**view_qualifications_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_qualifications_v3_rc1) | **GET** /v3.0_rc1/{orcid}/qualifications | Fetch all qualifications
[**view_record_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_record_v3_rc1) | **GET** /v3.0_rc1/{orcid} | Fetch record details
[**view_research_resource_summary_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_research_resource_summary_v3_rc1) | **GET** /v3.0_rc1/{orcid}/research-resource/summary/{putCode} | Fetch a Research Resource summary
[**view_research_resource_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_research_resource_v3_rc1) | **GET** /v3.0_rc1/{orcid}/research-resource/{putCode} | Fetch a Research Resource
[**view_research_resources_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_research_resources_v3_rc1) | **GET** /v3.0_rc1/{orcid}/research-resources | Fetch all Research Resources
[**view_researcher_url_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_researcher_url_v3_rc1) | **GET** /v3.0_rc1/{orcid}/researcher-urls/{putCode} | Fetch one researcher url for an ORCID ID
[**view_researcher_urls_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_researcher_urls_v3_rc1) | **GET** /v3.0_rc1/{orcid}/researcher-urls | Fetch all researcher urls for an ORCID ID
[**view_service_summary_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_service_summary_v3_rc1) | **GET** /v3.0_rc1/{orcid}/service/summary/{putCode} | Fetch an Service summary
[**view_service_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_service_v3_rc1) | **GET** /v3.0_rc1/{orcid}/service/{putCode} | Fetch an Service
[**view_services_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_services_v3_rc1) | **GET** /v3.0_rc1/{orcid}/services | Fetch all services
[**view_specified_works_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_specified_works_v3_rc1) | **GET** /v3.0_rc1/{orcid}/works/{putCodes} | Fetch specified works
[**view_status_json**](DevelopmentMemberAPIV30Rc1Api.md#view_status_json) | **GET** /v3.0_rc1/apiStatus | 
[**view_work_summary_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_work_summary_v3_rc1) | **GET** /v3.0_rc1/{orcid}/work/summary/{putCode} | Fetch a Work Summary
[**view_work_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_work_v3_rc1) | **GET** /v3.0_rc1/{orcid}/work/{putCode} | Fetch a Work
[**view_works_v3_rc1**](DevelopmentMemberAPIV30Rc1Api.md#view_works_v3_rc1) | **GET** /v3.0_rc1/{orcid}/works | Fetch all works

# **add_permission_notification_v3_rc1**
> str add_permission_notification_v3_rc1(orcid, body=body)

Add a notification

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.NotificationPermissionV30Rc1() # NotificationPermissionV30Rc1 |  (optional)

try:
    # Add a notification
    api_response = api_instance.add_permission_notification_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->add_permission_notification_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**NotificationPermissionV30Rc1**](NotificationPermissionV30Rc1.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_address_v3_rc1**
> create_address_v3_rc1(orcid, body=body)

Add an address

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.AddressV30Rc1() # AddressV30Rc1 |  (optional)

try:
    # Add an address
    api_instance.create_address_v3_rc1(orcid, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_address_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**AddressV30Rc1**](AddressV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_distinction_v3_rc1**
> str create_distinction_v3_rc1(orcid, body=body)

Create an Distinction

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.DistinctionV30Rc1() # DistinctionV30Rc1 |  (optional)

try:
    # Create an Distinction
    api_response = api_instance.create_distinction_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_distinction_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**DistinctionV30Rc1**](DistinctionV30Rc1.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_education_v3_rc1**
> str create_education_v3_rc1(orcid, body=body)

Create an Education

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.EducationV30Rc1() # EducationV30Rc1 |  (optional)

try:
    # Create an Education
    api_response = api_instance.create_education_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_education_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**EducationV30Rc1**](EducationV30Rc1.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_employment_v3_rc1**
> str create_employment_v3_rc1(orcid, body=body)

Create an Employment

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.EmploymentV30Rc1() # EmploymentV30Rc1 |  (optional)

try:
    # Create an Employment
    api_response = api_instance.create_employment_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_employment_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**EmploymentV30Rc1**](EmploymentV30Rc1.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_external_identifier_v3_rc1**
> create_external_identifier_v3_rc1(orcid, body=body)

Add external identifier

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.PersonExternalIdentifierV30Rc1() # PersonExternalIdentifierV30Rc1 |  (optional)

try:
    # Add external identifier
    api_instance.create_external_identifier_v3_rc1(orcid, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_external_identifier_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**PersonExternalIdentifierV30Rc1**](PersonExternalIdentifierV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_funding_v3_rc1**
> str create_funding_v3_rc1(orcid, body=body)

Create a Funding

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.FundingV30Rc1() # FundingV30Rc1 |  (optional)

try:
    # Create a Funding
    api_response = api_instance.create_funding_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_funding_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**FundingV30Rc1**](FundingV30Rc1.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_group_id_record_v3_rc1**
> create_group_id_record_v3_rc1(body=body)

Create a Group

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
body = orcid_api_v3.GroupIdRecord() # GroupIdRecord |  (optional)

try:
    # Create a Group
    api_instance.create_group_id_record_v3_rc1(body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_group_id_record_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**GroupIdRecord**](GroupIdRecord.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_invited_position_v3_rc1**
> str create_invited_position_v3_rc1(orcid, body=body)

Create an InvitedPosition

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.InvitedPositionV30Rc1() # InvitedPositionV30Rc1 |  (optional)

try:
    # Create an InvitedPosition
    api_response = api_instance.create_invited_position_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_invited_position_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**InvitedPositionV30Rc1**](InvitedPositionV30Rc1.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_keyword_v3_rc1**
> create_keyword_v3_rc1(orcid, body=body)

Add keyword

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.KeywordV30Rc1() # KeywordV30Rc1 |  (optional)

try:
    # Add keyword
    api_instance.create_keyword_v3_rc1(orcid, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_keyword_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**KeywordV30Rc1**](KeywordV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_membership_v3_rc1**
> str create_membership_v3_rc1(orcid, body=body)

Create an Membership

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.MembershipV30Rc1() # MembershipV30Rc1 |  (optional)

try:
    # Create an Membership
    api_response = api_instance.create_membership_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_membership_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**MembershipV30Rc1**](MembershipV30Rc1.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_other_name_v3_rc1**
> create_other_name_v3_rc1(orcid, body=body)

Add other name

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.OtherNameV30Rc1() # OtherNameV30Rc1 |  (optional)

try:
    # Add other name
    api_instance.create_other_name_v3_rc1(orcid, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_other_name_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**OtherNameV30Rc1**](OtherNameV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_peer_review_v3_rc1**
> str create_peer_review_v3_rc1(orcid, body=body)

Create a Peer Review

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.PeerReviewV30Rc1() # PeerReviewV30Rc1 |  (optional)

try:
    # Create a Peer Review
    api_response = api_instance.create_peer_review_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_peer_review_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**PeerReviewV30Rc1**](PeerReviewV30Rc1.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_qualification_v3_rc1**
> str create_qualification_v3_rc1(orcid, body=body)

Create an Qualification

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.QualificationV30Rc1() # QualificationV30Rc1 |  (optional)

try:
    # Create an Qualification
    api_response = api_instance.create_qualification_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_qualification_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**QualificationV30Rc1**](QualificationV30Rc1.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_research_resource_v3_rc1**
> str create_research_resource_v3_rc1(orcid, body=body)

Create a Research Resource

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.ResearchResourceV30Rc1() # ResearchResourceV30Rc1 |  (optional)

try:
    # Create a Research Resource
    api_response = api_instance.create_research_resource_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_research_resource_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**ResearchResourceV30Rc1**](ResearchResourceV30Rc1.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_researcher_url_v3_rc1**
> create_researcher_url_v3_rc1(orcid, body=body)

Add a new researcher url for an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.ResearcherUrlV30Rc1() # ResearcherUrlV30Rc1 |  (optional)

try:
    # Add a new researcher url for an ORCID ID
    api_instance.create_researcher_url_v3_rc1(orcid, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_researcher_url_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**ResearcherUrlV30Rc1**](ResearcherUrlV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_service_v3_rc1**
> str create_service_v3_rc1(orcid, body=body)

Create an Service

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.ServiceV30Rc1() # ServiceV30Rc1 |  (optional)

try:
    # Create an Service
    api_response = api_instance.create_service_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_service_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**ServiceV30Rc1**](ServiceV30Rc1.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_work_v3_rc1**
> str create_work_v3_rc1(orcid, body=body)

Create a Work

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.WorkV30Rc1() # WorkV30Rc1 |  (optional)

try:
    # Create a Work
    api_response = api_instance.create_work_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_work_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**WorkV30Rc1**](WorkV30Rc1.md)|  | [optional] 

### Return type

**str**

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_works_v3_rc1**
> WorkBulkV30Rc1 create_works_v3_rc1(orcid, body=body)

Create a listo of Work

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
body = orcid_api_v3.WorkBulkV30Rc1() # WorkBulkV30Rc1 |  (optional)

try:
    # Create a listo of Work
    api_response = api_instance.create_works_v3_rc1(orcid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->create_works_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **body** | [**WorkBulkV30Rc1**](WorkBulkV30Rc1.md)|  | [optional] 

### Return type

[**WorkBulkV30Rc1**](WorkBulkV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_address_v3_rc1**
> delete_address_v3_rc1(orcid, put_code)

Delete an address

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an address
    api_instance.delete_address_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_address_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_distinction_v3_rc1**
> delete_distinction_v3_rc1(orcid, put_code)

Delete an Distinction

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Distinction
    api_instance.delete_distinction_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_distinction_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_education_v3_rc1**
> delete_education_v3_rc1(orcid, put_code)

Delete an Education

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Education
    api_instance.delete_education_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_education_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_employment_v3_rc1**
> delete_employment_v3_rc1(orcid, put_code)

Delete an Employment

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Employment
    api_instance.delete_employment_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_employment_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_external_identifier_v3_rc1**
> delete_external_identifier_v3_rc1(orcid, put_code)

Delete external identifier

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete external identifier
    api_instance.delete_external_identifier_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_external_identifier_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_funding_v3_rc1**
> delete_funding_v3_rc1(orcid, put_code)

Delete a Funding

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete a Funding
    api_instance.delete_funding_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_funding_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_group_id_record_v3_rc1**
> delete_group_id_record_v3_rc1(put_code)

Delete a Group

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
put_code = 'put_code_example' # str | 

try:
    # Delete a Group
    api_instance.delete_group_id_record_v3_rc1(put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_group_id_record_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_invited_position_v3_rc1**
> delete_invited_position_v3_rc1(orcid, put_code)

Delete an InvitedPosition

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an InvitedPosition
    api_instance.delete_invited_position_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_invited_position_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_keyword_v3_rc1**
> delete_keyword_v3_rc1(orcid, put_code)

Delete keyword

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete keyword
    api_instance.delete_keyword_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_keyword_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_membership_v3_rc1**
> delete_membership_v3_rc1(orcid, put_code)

Delete an Membership

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Membership
    api_instance.delete_membership_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_membership_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_other_name_v3_rc1**
> delete_other_name_v3_rc1(orcid, put_code)

Delete other name

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete other name
    api_instance.delete_other_name_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_other_name_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_peer_review_v3_rc1**
> delete_peer_review_v3_rc1(orcid, put_code)

Delete a Peer Review

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete a Peer Review
    api_instance.delete_peer_review_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_peer_review_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_qualification_v3_rc1**
> delete_qualification_v3_rc1(orcid, put_code)

Delete an Qualification

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Qualification
    api_instance.delete_qualification_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_qualification_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_research_resource_v3_rc1**
> delete_research_resource_v3_rc1(orcid, put_code)

Delete an Research Resource

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Research Resource
    api_instance.delete_research_resource_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_research_resource_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_researcher_url_v3_rc1**
> delete_researcher_url_v3_rc1(orcid, put_code)

Delete one researcher url from an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete one researcher url from an ORCID ID
    api_instance.delete_researcher_url_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_researcher_url_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_service_v3_rc1**
> delete_service_v3_rc1(orcid, put_code)

Delete an Service

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete an Service
    api_instance.delete_service_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_service_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_work_v3_rc1**
> delete_work_v3_rc1(orcid, put_code)

Delete a Work

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Delete a Work
    api_instance.delete_work_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->delete_work_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_address_v3_rc1**
> edit_address_v3_rc1(orcid, put_code, body=body)

Edit an address

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.AddressV30Rc1() # AddressV30Rc1 |  (optional)

try:
    # Edit an address
    api_instance.edit_address_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->edit_address_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**AddressV30Rc1**](AddressV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_external_identifier_v3_rc1**
> edit_external_identifier_v3_rc1(orcid, put_code, body=body)

Edit external identifier

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.PersonExternalIdentifierV30Rc1() # PersonExternalIdentifierV30Rc1 |  (optional)

try:
    # Edit external identifier
    api_instance.edit_external_identifier_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->edit_external_identifier_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**PersonExternalIdentifierV30Rc1**](PersonExternalIdentifierV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_keyword_v3_rc1**
> edit_keyword_v3_rc1(orcid, put_code, body=body)

Edit keyword

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.KeywordV30Rc1() # KeywordV30Rc1 |  (optional)

try:
    # Edit keyword
    api_instance.edit_keyword_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->edit_keyword_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**KeywordV30Rc1**](KeywordV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_other_name_v3_rc1**
> edit_other_name_v3_rc1(orcid, put_code, body=body)

Edit other name

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.OtherNameV30Rc1() # OtherNameV30Rc1 |  (optional)

try:
    # Edit other name
    api_instance.edit_other_name_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->edit_other_name_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**OtherNameV30Rc1**](OtherNameV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_researcher_url_v3_rc1**
> edit_researcher_url_v3_rc1(orcid, put_code, body=body)

Edits researcher url for an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.ResearcherUrlV30Rc1() # ResearcherUrlV30Rc1 |  (optional)

try:
    # Edits researcher url for an ORCID ID
    api_instance.edit_researcher_url_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->edit_researcher_url_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**ResearcherUrlV30Rc1**](ResearcherUrlV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **flag_as_archived_permission_notification_v3_rc1**
> Notification flag_as_archived_permission_notification_v3_rc1(orcid, id)

Archive a notification

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
id = 789 # int | 

try:
    # Archive a notification
    api_response = api_instance.flag_as_archived_permission_notification_v3_rc1(orcid, id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->flag_as_archived_permission_notification_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **id** | **int**|  | 

### Return type

[**Notification**](Notification.md)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **search_by_query_v3_rc1**
> SearchV30Rc1 search_by_query_v3_rc1(q=q)

Search records

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
q = 'q_example' # str |  (optional)

try:
    # Search records
    api_response = api_instance.search_by_query_v3_rc1(q=q)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->search_by_query_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q** | **str**|  | [optional] 

### Return type

[**SearchV30Rc1**](SearchV30Rc1.md)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_distinction_v3_rc1**
> update_distinction_v3_rc1(orcid, put_code, body=body)

Update an Distinction

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.DistinctionV30Rc1() # DistinctionV30Rc1 |  (optional)

try:
    # Update an Distinction
    api_instance.update_distinction_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->update_distinction_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**DistinctionV30Rc1**](DistinctionV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_education_v3_rc1**
> update_education_v3_rc1(orcid, put_code, body=body)

Update an Education

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.EducationV30Rc1() # EducationV30Rc1 |  (optional)

try:
    # Update an Education
    api_instance.update_education_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->update_education_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**EducationV30Rc1**](EducationV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_employment_v3_rc1**
> update_employment_v3_rc1(orcid, put_code, body=body)

Update an Employment

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.EmploymentV30Rc1() # EmploymentV30Rc1 |  (optional)

try:
    # Update an Employment
    api_instance.update_employment_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->update_employment_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**EmploymentV30Rc1**](EmploymentV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_funding_v3_rc1**
> update_funding_v3_rc1(orcid, put_code, body=body)

Update a Funding

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.FundingV30Rc1() # FundingV30Rc1 |  (optional)

try:
    # Update a Funding
    api_instance.update_funding_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->update_funding_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**FundingV30Rc1**](FundingV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_group_id_record_v3_rc1**
> update_group_id_record_v3_rc1(put_code, body=body)

Update a Group

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
put_code = 'put_code_example' # str | 
body = orcid_api_v3.GroupIdRecord() # GroupIdRecord |  (optional)

try:
    # Update a Group
    api_instance.update_group_id_record_v3_rc1(put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->update_group_id_record_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **put_code** | **str**|  | 
 **body** | [**GroupIdRecord**](GroupIdRecord.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_invited_position_v3_rc1**
> update_invited_position_v3_rc1(orcid, put_code, body=body)

Update an InvitedPosition

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.InvitedPositionV30Rc1() # InvitedPositionV30Rc1 |  (optional)

try:
    # Update an InvitedPosition
    api_instance.update_invited_position_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->update_invited_position_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**InvitedPositionV30Rc1**](InvitedPositionV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_membership_v3_rc1**
> update_membership_v3_rc1(orcid, put_code, body=body)

Update an Membership

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.MembershipV30Rc1() # MembershipV30Rc1 |  (optional)

try:
    # Update an Membership
    api_instance.update_membership_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->update_membership_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**MembershipV30Rc1**](MembershipV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_peer_review_v3_rc1**
> update_peer_review_v3_rc1(orcid, put_code, body=body)

Update a Peer Review

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.PeerReviewV30Rc1() # PeerReviewV30Rc1 |  (optional)

try:
    # Update a Peer Review
    api_instance.update_peer_review_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->update_peer_review_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**PeerReviewV30Rc1**](PeerReviewV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_qualification_v3_rc1**
> update_qualification_v3_rc1(orcid, put_code, body=body)

Update an Qualification

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.QualificationV30Rc1() # QualificationV30Rc1 |  (optional)

try:
    # Update an Qualification
    api_instance.update_qualification_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->update_qualification_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**QualificationV30Rc1**](QualificationV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_research_resource_v3_rc1**
> update_research_resource_v3_rc1(orcid, put_code, body=body)

Update a Research Resource

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.ResearchResourceV30Rc1() # ResearchResourceV30Rc1 |  (optional)

try:
    # Update a Research Resource
    api_instance.update_research_resource_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->update_research_resource_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**ResearchResourceV30Rc1**](ResearchResourceV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_service_v3_rc1**
> update_service_v3_rc1(orcid, put_code, body=body)

Update an Service

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.ServiceV30Rc1() # ServiceV30Rc1 |  (optional)

try:
    # Update an Service
    api_instance.update_service_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->update_service_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**ServiceV30Rc1**](ServiceV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_work_v3_rc1**
> update_work_v3_rc1(orcid, put_code, body=body)

Update a Work

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 
body = orcid_api_v3.WorkV30Rc1() # WorkV30Rc1 |  (optional)

try:
    # Update a Work
    api_instance.update_work_v3_rc1(orcid, put_code, body=body)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->update_work_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 
 **body** | [**WorkV30Rc1**](WorkV30Rc1.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_activities_v3_rc1**
> ActivitiesSummaryV30Rc1 view_activities_v3_rc1(orcid)

Fetch all activities

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all activities
    api_response = api_instance.view_activities_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_activities_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**ActivitiesSummaryV30Rc1**](ActivitiesSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_address_v3_rc1**
> view_address_v3_rc1(orcid, put_code)

Fetch an address

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an address
    api_instance.view_address_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_address_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_addresses_v3_rc1**
> AddressesV30Rc1 view_addresses_v3_rc1(orcid)

Fetch all addresses of a profile

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all addresses of a profile
    api_response = api_instance.view_addresses_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_addresses_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**AddressesV30Rc1**](AddressesV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_biography_v3_rc1**
> BiographyV30Rc1 view_biography_v3_rc1(orcid)

Get biography details

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Get biography details
    api_response = api_instance.view_biography_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_biography_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**BiographyV30Rc1**](BiographyV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_client_v3_rc1**
> view_client_v3_rc1(client_id)

Fetch client details

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
client_id = 'client_id_example' # str | 

try:
    # Fetch client details
    api_instance.view_client_v3_rc1(client_id)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_client_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **client_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_distinction_summary_v3_rc1**
> DistinctionSummaryV30Rc1 view_distinction_summary_v3_rc1(orcid, put_code)

Fetch an Distinction summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Distinction summary
    api_response = api_instance.view_distinction_summary_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_distinction_summary_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**DistinctionSummaryV30Rc1**](DistinctionSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_distinction_v3_rc1**
> DistinctionV30Rc1 view_distinction_v3_rc1(orcid, put_code)

Fetch an Distinction

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Distinction
    api_response = api_instance.view_distinction_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_distinction_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**DistinctionV30Rc1**](DistinctionV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_distinctions_v3_rc1**
> DistinctionsV30Rc1 view_distinctions_v3_rc1(orcid)

Fetch all distinctions

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all distinctions
    api_response = api_instance.view_distinctions_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_distinctions_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**DistinctionsV30Rc1**](DistinctionsV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_education_summary_v3_rc1**
> EducationSummaryV30Rc1 view_education_summary_v3_rc1(orcid, put_code)

Fetch an Education summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Education summary
    api_response = api_instance.view_education_summary_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_education_summary_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**EducationSummaryV30Rc1**](EducationSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_education_v3_rc1**
> EducationV30Rc1 view_education_v3_rc1(orcid, put_code)

Fetch an Education

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Education
    api_response = api_instance.view_education_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_education_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**EducationV30Rc1**](EducationV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_educations_v3_rc1**
> EducationsSummaryV30Rc1 view_educations_v3_rc1(orcid)

Fetch all educations

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all educations
    api_response = api_instance.view_educations_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_educations_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**EducationsSummaryV30Rc1**](EducationsSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_emails_v3_rc1**
> view_emails_v3_rc1(orcid)

Fetch all emails for an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all emails for an ORCID ID
    api_instance.view_emails_v3_rc1(orcid)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_emails_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_employment_summary_v3_rc1**
> EmploymentSummaryV30Rc1 view_employment_summary_v3_rc1(orcid, put_code)

Fetch an Employment Summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Employment Summary
    api_response = api_instance.view_employment_summary_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_employment_summary_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**EmploymentSummaryV30Rc1**](EmploymentSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_employment_v3_rc1**
> EmploymentV30Rc1 view_employment_v3_rc1(orcid, put_code)

Fetch an Employment

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Employment
    api_response = api_instance.view_employment_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_employment_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**EmploymentV30Rc1**](EmploymentV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_employments_v3_rc1**
> EmploymentsSummaryV30Rc1 view_employments_v3_rc1(orcid)

Fetch all employments

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all employments
    api_response = api_instance.view_employments_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_employments_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**EmploymentsSummaryV30Rc1**](EmploymentsSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_external_identifier_v3_rc1**
> view_external_identifier_v3_rc1(orcid, put_code)

Fetch external identifier

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch external identifier
    api_instance.view_external_identifier_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_external_identifier_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_external_identifiers_v3_rc1**
> view_external_identifiers_v3_rc1(orcid)

Fetch external identifiers

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch external identifiers
    api_instance.view_external_identifiers_v3_rc1(orcid)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_external_identifiers_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_funding_summary_v3_rc1**
> FundingSummaryV30Rc1 view_funding_summary_v3_rc1(orcid, put_code)

Fetch a Funding Summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Funding Summary
    api_response = api_instance.view_funding_summary_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_funding_summary_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**FundingSummaryV30Rc1**](FundingSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_funding_v3_rc1**
> FundingV30Rc1 view_funding_v3_rc1(orcid, put_code)

Fetch a Funding

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Funding
    api_response = api_instance.view_funding_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_funding_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**FundingV30Rc1**](FundingV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_fundings_v3_rc1**
> FundingsV30Rc1 view_fundings_v3_rc1(orcid)

Fetch all fundings

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all fundings
    api_response = api_instance.view_fundings_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_fundings_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**FundingsV30Rc1**](FundingsV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_group_id_record_v3_rc1**
> GroupIdRecord view_group_id_record_v3_rc1(put_code)

Fetch a Group

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
put_code = 'put_code_example' # str | 

try:
    # Fetch a Group
    api_response = api_instance.view_group_id_record_v3_rc1(put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_group_id_record_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **put_code** | **str**|  | 

### Return type

[**GroupIdRecord**](GroupIdRecord.md)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_group_id_records_v3_rc1**
> GroupIdRecords view_group_id_records_v3_rc1(page_size=page_size, page=page, name=name, group_id=group_id)

Fetch Groups

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
page_size = 'page_size_example' # str |  (optional)
page = 'page_example' # str |  (optional)
name = 'name_example' # str |  (optional)
group_id = 'group_id_example' # str |  (optional)

try:
    # Fetch Groups
    api_response = api_instance.view_group_id_records_v3_rc1(page_size=page_size, page=page, name=name, group_id=group_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_group_id_records_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **str**|  | [optional] 
 **page** | **str**|  | [optional] 
 **name** | **str**|  | [optional] 
 **group_id** | **str**|  | [optional] 

### Return type

[**GroupIdRecords**](GroupIdRecords.md)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_invited_position_summary_v3_rc1**
> InvitedPositionSummaryV30Rc1 view_invited_position_summary_v3_rc1(orcid, put_code)

Fetch an InvitedPosition summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an InvitedPosition summary
    api_response = api_instance.view_invited_position_summary_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_invited_position_summary_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**InvitedPositionSummaryV30Rc1**](InvitedPositionSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_invited_position_v3_rc1**
> InvitedPositionV30Rc1 view_invited_position_v3_rc1(orcid, put_code)

Fetch an InvitedPosition

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an InvitedPosition
    api_response = api_instance.view_invited_position_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_invited_position_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**InvitedPositionV30Rc1**](InvitedPositionV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_invited_positions_v3_rc1**
> InvitedPositionsV30Rc1 view_invited_positions_v3_rc1(orcid)

Fetch all invitedPositions

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all invitedPositions
    api_response = api_instance.view_invited_positions_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_invited_positions_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**InvitedPositionsV30Rc1**](InvitedPositionsV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_keyword_v3_rc1**
> view_keyword_v3_rc1(orcid, put_code)

Fetch keyword

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch keyword
    api_instance.view_keyword_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_keyword_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_keywords_v3_rc1**
> view_keywords_v3_rc1(orcid)

Fetch keywords

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch keywords
    api_instance.view_keywords_v3_rc1(orcid)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_keywords_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_membership_summary_v3_rc1**
> MembershipSummaryV30Rc1 view_membership_summary_v3_rc1(orcid, put_code)

Fetch an Membership summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Membership summary
    api_response = api_instance.view_membership_summary_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_membership_summary_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**MembershipSummaryV30Rc1**](MembershipSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_membership_v3_rc1**
> MembershipV30Rc1 view_membership_v3_rc1(orcid, put_code)

Fetch an Membership

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Membership
    api_response = api_instance.view_membership_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_membership_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**MembershipV30Rc1**](MembershipV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_memberships_v3_rc1**
> MembershipsV30Rc1 view_memberships_v3_rc1(orcid)

Fetch all memberships

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all memberships
    api_response = api_instance.view_memberships_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_memberships_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**MembershipsV30Rc1**](MembershipsV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_other_name_v3_rc1**
> view_other_name_v3_rc1(orcid, put_code)

Fetch Other name

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch Other name
    api_instance.view_other_name_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_other_name_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_other_names_v3_rc1**
> view_other_names_v3_rc1(orcid)

Fetch Other names

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch Other names
    api_instance.view_other_names_v3_rc1(orcid)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_other_names_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_peer_review_summary_v3_rc1**
> PeerReviewSummaryV30Rc1 view_peer_review_summary_v3_rc1(orcid, put_code)

Fetch a Peer Review Summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Peer Review Summary
    api_response = api_instance.view_peer_review_summary_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_peer_review_summary_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**PeerReviewSummaryV30Rc1**](PeerReviewSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_peer_review_v3_rc1**
> PeerReviewV30Rc1 view_peer_review_v3_rc1(orcid, put_code)

Fetch a Peer Review

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Peer Review
    api_response = api_instance.view_peer_review_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_peer_review_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**PeerReviewV30Rc1**](PeerReviewV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_peer_reviews_v3_rc1**
> PeerReviewsV30Rc1 view_peer_reviews_v3_rc1(orcid)

Fetch all peer reviews

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all peer reviews
    api_response = api_instance.view_peer_reviews_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_peer_reviews_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**PeerReviewsV30Rc1**](PeerReviewsV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_permission_notification_v3_rc1**
> Notification view_permission_notification_v3_rc1(orcid, id)

Fetch a notification by id

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_two_legs
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
id = 789 # int | 

try:
    # Fetch a notification by id
    api_response = api_instance.view_permission_notification_v3_rc1(orcid, id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_permission_notification_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **id** | **int**|  | 

### Return type

[**Notification**](Notification.md)

### Authorization

[orcid_two_legs](../README.md#orcid_two_legs)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_person_v3_rc1**
> view_person_v3_rc1(orcid)

Fetch person details

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch person details
    api_instance.view_person_v3_rc1(orcid)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_person_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_personal_details_v3_rc1**
> PersonalDetailsV30Rc1 view_personal_details_v3_rc1(orcid)

Fetch personal details for an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch personal details for an ORCID ID
    api_response = api_instance.view_personal_details_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_personal_details_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**PersonalDetailsV30Rc1**](PersonalDetailsV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_qualification_summary_v3_rc1**
> QualificationSummaryV30Rc1 view_qualification_summary_v3_rc1(orcid, put_code)

Fetch an Qualification summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Qualification summary
    api_response = api_instance.view_qualification_summary_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_qualification_summary_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**QualificationSummaryV30Rc1**](QualificationSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_qualification_v3_rc1**
> QualificationV30Rc1 view_qualification_v3_rc1(orcid, put_code)

Fetch an Qualification

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Qualification
    api_response = api_instance.view_qualification_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_qualification_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**QualificationV30Rc1**](QualificationV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_qualifications_v3_rc1**
> QualificationsV30Rc1 view_qualifications_v3_rc1(orcid)

Fetch all qualifications

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all qualifications
    api_response = api_instance.view_qualifications_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_qualifications_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**QualificationsV30Rc1**](QualificationsV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_record_v3_rc1**
> RecordV30Rc1 view_record_v3_rc1(orcid)

Fetch record details

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch record details
    api_response = api_instance.view_record_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_record_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**RecordV30Rc1**](RecordV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_research_resource_summary_v3_rc1**
> ResearchResourceSummaryV30Rc1 view_research_resource_summary_v3_rc1(orcid, put_code)

Fetch a Research Resource summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Research Resource summary
    api_response = api_instance.view_research_resource_summary_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_research_resource_summary_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**ResearchResourceSummaryV30Rc1**](ResearchResourceSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_research_resource_v3_rc1**
> ResearchResourceV30Rc1 view_research_resource_v3_rc1(orcid, put_code)

Fetch a Research Resource

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Research Resource
    api_response = api_instance.view_research_resource_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_research_resource_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**ResearchResourceV30Rc1**](ResearchResourceV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_research_resources_v3_rc1**
> ResearchResourcesV30Rc1 view_research_resources_v3_rc1(orcid)

Fetch all Research Resources

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all Research Resources
    api_response = api_instance.view_research_resources_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_research_resources_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**ResearchResourcesV30Rc1**](ResearchResourcesV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_researcher_url_v3_rc1**
> view_researcher_url_v3_rc1(orcid, put_code)

Fetch one researcher url for an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch one researcher url for an ORCID ID
    api_instance.view_researcher_url_v3_rc1(orcid, put_code)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_researcher_url_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_researcher_urls_v3_rc1**
> view_researcher_urls_v3_rc1(orcid)

Fetch all researcher urls for an ORCID ID

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all researcher urls for an ORCID ID
    api_instance.view_researcher_urls_v3_rc1(orcid)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_researcher_urls_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_service_summary_v3_rc1**
> ServiceSummaryV30Rc1 view_service_summary_v3_rc1(orcid, put_code)

Fetch an Service summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Service summary
    api_response = api_instance.view_service_summary_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_service_summary_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**ServiceSummaryV30Rc1**](ServiceSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_service_v3_rc1**
> ServiceV30Rc1 view_service_v3_rc1(orcid, put_code)

Fetch an Service

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch an Service
    api_response = api_instance.view_service_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_service_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**ServiceV30Rc1**](ServiceV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_services_v3_rc1**
> ServicesV30Rc1 view_services_v3_rc1(orcid)

Fetch all services

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all services
    api_response = api_instance.view_services_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_services_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**ServicesV30Rc1**](ServicesV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_specified_works_v3_rc1**
> WorkBulkV30Rc1 view_specified_works_v3_rc1(orcid, put_codes)

Fetch specified works

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_codes = 'put_codes_example' # str | 

try:
    # Fetch specified works
    api_response = api_instance.view_specified_works_v3_rc1(orcid, put_codes)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_specified_works_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_codes** | **str**|  | 

### Return type

[**WorkBulkV30Rc1**](WorkBulkV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_status_json**
> view_status_json()



### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api()

try:
    api_instance.view_status_json()
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_status_json: %s\n" % e)
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_work_summary_v3_rc1**
> WorkSummaryV30Rc1 view_work_summary_v3_rc1(orcid, put_code)

Fetch a Work Summary

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Work Summary
    api_response = api_instance.view_work_summary_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_work_summary_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**WorkSummaryV30Rc1**](WorkSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_work_v3_rc1**
> WorkV30Rc1 view_work_v3_rc1(orcid, put_code)

Fetch a Work

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 
put_code = 'put_code_example' # str | 

try:
    # Fetch a Work
    api_response = api_instance.view_work_v3_rc1(orcid, put_code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_work_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 
 **put_code** | **str**|  | 

### Return type

[**WorkV30Rc1**](WorkV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **view_works_v3_rc1**
> WorksSummaryV30Rc1 view_works_v3_rc1(orcid)

Fetch all works

### Example
```python
from __future__ import print_function
import time
import orcid_api_v3
from orcid_api_v3.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: orcid_auth
configuration = orcid_api_v3.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = orcid_api_v3.DevelopmentMemberAPIV30Rc1Api(orcid_api_v3.ApiClient(configuration))
orcid = 'orcid_example' # str | 

try:
    # Fetch all works
    api_response = api_instance.view_works_v3_rc1(orcid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DevelopmentMemberAPIV30Rc1Api->view_works_v3_rc1: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orcid** | **str**|  | 

### Return type

[**WorksSummaryV30Rc1**](WorksSummaryV30Rc1.md)

### Authorization

[orcid_auth](../README.md#orcid_auth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.orcid+xml; qs=5, application/orcid+xml; qs=3, application/xml, application/vnd.orcid+json; qs=4, application/orcid+json; qs=2, application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

