# mypy-boto3-nimble<a id="mypy-boto3-nimble"></a>

[![PyPI - mypy-boto3-nimble](https://img.shields.io/pypi/v/mypy-boto3-nimble.svg?color=blue)](https://pypi.org/project/mypy-boto3-nimble)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-nimble.svg?color=blue)](https://pypi.org/project/mypy-boto3-nimble)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-nimble?color=blue)](https://pypistats.org/packages/mypy-boto3-nimble)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.NimbleStudio 1.17.73](https://boto3.amazonaws.com/v1/documentation/api/1.17.73/reference/services/nimble.html#NimbleStudio)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.13.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-nimble docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_nimble/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-nimble](#mypy-boto3-nimble)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `NimbleStudio` service.

```bash
python -m pip install boto3-stubs[nimble]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[nimble]` in your environment:
  `python -m pip install 'boto3-stubs[nimble]'`

Both type checking and auto-complete should work for `NimbleStudio` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[nimble]` in your environment:
  `python -m pip install 'boto3-stubs[nimble]'`

Both type checking and auto-complete should work for `NimbleStudio` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[nimble]` in your environment:
  `python -m pip install 'boto3-stubs[nimble]'`
- Run `mypy` as usual

Type checking should work for `NimbleStudio` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[nimble]` in your environment:
  `python -m pip install 'boto3-stubs[nimble]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `NimbleStudio` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`NimbleStudioClient` provides annotations for `boto3.client("nimble")`.

```python
import boto3

from mypy_boto3_nimble import NimbleStudioClient

client: NimbleStudioClient = boto3.client("nimble")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: NimbleStudioClient = session.client("nimble")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_nimble.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_nimble import NimbleStudioClient
from mypy_boto3_nimble.paginator import (
    ListEulaAcceptancesPaginator,
    ListEulasPaginator,
    ListLaunchProfileMembersPaginator,
    ListLaunchProfilesPaginator,
    ListStreamingImagesPaginator,
    ListStreamingSessionsPaginator,
    ListStudioComponentsPaginator,
    ListStudioMembersPaginator,
    ListStudiosPaginator,
)

client: NimbleStudioClient = boto3.client("nimble")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_eula_acceptances_paginator: ListEulaAcceptancesPaginator = client.get_paginator("list_eula_acceptances")
list_eulas_paginator: ListEulasPaginator = client.get_paginator("list_eulas")
list_launch_profile_members_paginator: ListLaunchProfileMembersPaginator = client.get_paginator("list_launch_profile_members")
list_launch_profiles_paginator: ListLaunchProfilesPaginator = client.get_paginator("list_launch_profiles")
list_streaming_images_paginator: ListStreamingImagesPaginator = client.get_paginator("list_streaming_images")
list_streaming_sessions_paginator: ListStreamingSessionsPaginator = client.get_paginator("list_streaming_sessions")
list_studio_components_paginator: ListStudioComponentsPaginator = client.get_paginator("list_studio_components")
list_studio_members_paginator: ListStudioMembersPaginator = client.get_paginator("list_studio_members")
list_studios_paginator: ListStudiosPaginator = client.get_paginator("list_studios")
```

### Literals<a id="literals"></a>

`mypy_boto3_nimble.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_nimble.literals import (
    LaunchProfilePersonaType,
    LaunchProfilePlatformType,
    LaunchProfileStateType,
    LaunchProfileStatusCodeType,
    ListEulaAcceptancesPaginatorName,
    ListEulasPaginatorName,
    ListLaunchProfileMembersPaginatorName,
    ListLaunchProfilesPaginatorName,
    ListStreamingImagesPaginatorName,
    ListStreamingSessionsPaginatorName,
    ListStudioComponentsPaginatorName,
    ListStudioMembersPaginatorName,
    ListStudiosPaginatorName,
    StreamingClipboardModeType,
    StreamingImageEncryptionConfigurationKeyTypeType,
    StreamingImageStateType,
    StreamingImageStatusCodeType,
    StreamingInstanceTypeType,
    StreamingSessionStateType,
    StreamingSessionStatusCodeType,
    StreamingSessionStreamStateType,
    StreamingSessionStreamStatusCodeType,
    StudioComponentInitializationScriptRunContextType,
    StudioComponentStateType,
    StudioComponentStatusCodeType,
    StudioComponentSubtypeType,
    StudioComponentTypeType,
    StudioEncryptionConfigurationKeyTypeType,
    StudioPersonaType,
    StudioStateType,
    StudioStatusCodeType,
)

def check_value(value: LaunchProfilePersonaType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_nimble.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_nimble.type_defs import (
    AcceptEulasResponseTypeDef,
    ActiveDirectoryComputerAttributeTypeDef,
    ActiveDirectoryConfigurationTypeDef,
    ComputeFarmConfigurationTypeDef,
    CreateLaunchProfileResponseTypeDef,
    CreateStreamingImageResponseTypeDef,
    CreateStreamingSessionResponseTypeDef,
    CreateStreamingSessionStreamResponseTypeDef,
    CreateStudioComponentResponseTypeDef,
    CreateStudioResponseTypeDef,
    DeleteLaunchProfileResponseTypeDef,
    DeleteStreamingImageResponseTypeDef,
    DeleteStreamingSessionResponseTypeDef,
    DeleteStudioComponentResponseTypeDef,
    DeleteStudioResponseTypeDef,
    EulaAcceptanceTypeDef,
    EulaTypeDef,
    GetEulaResponseTypeDef,
    GetLaunchProfileDetailsResponseTypeDef,
    GetLaunchProfileInitializationResponseTypeDef,
    GetLaunchProfileMemberResponseTypeDef,
    GetLaunchProfileResponseTypeDef,
    GetStreamingImageResponseTypeDef,
    GetStreamingSessionResponseTypeDef,
    GetStreamingSessionStreamResponseTypeDef,
    GetStudioComponentResponseTypeDef,
    GetStudioMemberResponseTypeDef,
    GetStudioResponseTypeDef,
    LaunchProfileInitializationActiveDirectoryTypeDef,
    LaunchProfileInitializationScriptTypeDef,
    LaunchProfileInitializationTypeDef,
    LaunchProfileMembershipTypeDef,
    LaunchProfileTypeDef,
    LicenseServiceConfigurationTypeDef,
    ListEulaAcceptancesResponseTypeDef,
    ListEulasResponseTypeDef,
    ListLaunchProfileMembersResponseTypeDef,
    ListLaunchProfilesResponseTypeDef,
    ListStreamingImagesResponseTypeDef,
    ListStreamingSessionsResponseTypeDef,
    ListStudioComponentsResponseTypeDef,
    ListStudioMembersResponseTypeDef,
    ListStudiosResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    NewLaunchProfileMemberTypeDef,
    NewStudioMemberTypeDef,
    PaginatorConfigTypeDef,
    ScriptParameterKeyValueTypeDef,
    SharedFileSystemConfigurationTypeDef,
    StartStudioSSOConfigurationRepairResponseTypeDef,
    StreamConfigurationCreateTypeDef,
    StreamConfigurationTypeDef,
    StreamingImageEncryptionConfigurationTypeDef,
    StreamingImageTypeDef,
    StreamingSessionStreamTypeDef,
    StreamingSessionTypeDef,
    StudioComponentConfigurationTypeDef,
    StudioComponentInitializationScriptTypeDef,
    StudioComponentSummaryTypeDef,
    StudioComponentTypeDef,
    StudioEncryptionConfigurationTypeDef,
    StudioMembershipTypeDef,
    StudioTypeDef,
    UpdateLaunchProfileMemberResponseTypeDef,
    UpdateLaunchProfileResponseTypeDef,
    UpdateStreamingImageResponseTypeDef,
    UpdateStudioComponentResponseTypeDef,
    UpdateStudioResponseTypeDef,
)

def get_structure() -> AcceptEulasResponseTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-nimble` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-nimble docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_nimble/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
