# Contributing to RD-Agent

We welcome contributions and suggestions to improve RD-Agent. Whether it's solving an issue, addressing a bug, enhancing documentation, or even correcting a typo, every contribution is valuable and helps improve the project.

## Getting Started

To get started, you can explore the issues list or search for `TODO:` comments in the codebase by running the command:
```sh
grep -r "TODO:"
```

## How to Contribute

1. **Fork the Repository**: Create a fork of the repository on GitHub.
2. **Clone the Repository**: Clone your forked repository to your local machine.
   ```sh
   git clone https://github.com/your-username/RD-Agent.git
   ```
3. **Create a Branch**: Create a new branch for your changes.
   ```sh
   git checkout -b feature/your-feature-name
   ```
4. **Make Changes**: Make your changes to the codebase.
5. **Commit Changes**: Commit your changes with a descriptive commit message.
   ```sh
   git commit -m "Description of your changes"
   ```
6. **Push Changes**: Push your changes to your forked repository.
   ```sh
   git push origin feature/your-feature-name
   ```
7. **Ensure CI Passes**: Make sure your code passes the automatic CI checks on GitHub.
8. **Create a Pull Request**: Create a pull request from your forked repository to the main repository.

## Code of Conduct

Please adhere to the [Code of Conduct](CODE_OF_CONDUCT.md) in all your interactions with the project.

## Reporting Issues

If you encounter any issues or have suggestions for improvements, please open an issue on GitHub.

## Guidelines

- Ensure your code follows the project's coding standards.
- Write clear and concise commit messages.
- Update documentation as needed.
- Test your changes thoroughly before submitting a pull request.

Thank you for contributing to RD-Agent!
