import pytest
from uun_weatherstation.modules.WeatherConditions import WeatherConditions

test_data = [
    ({'did': '001D0A711E25', 'ts': 1614935912, 'conditions': [{'lsid': 319575, 'data_structure_type': 1, 'txid': 1, 'temp': 63.7, 'hum': 61.6, 'dew_point': 50.3, 'wet_bulb': 54.8, 'heat_index': 62.8, 'wind_chill': 63.3, 'thw_index': 62.4, 'thsw_index': 73.5, 'wind_speed_last': 8.0, 'wind_dir_last': 242, 'wind_speed_avg_last_1_min': 9.18, 'wind_dir_scalar_avg_last_1_min': 229, 'wind_speed_avg_last_2_min': 8.93, 'wind_dir_scalar_avg_last_2_min': 224, 'wind_speed_hi_last_2_min': 13.0, 'wind_dir_at_hi_speed_last_2_min': 240, 'wind_speed_avg_last_10_min': 7.56, 'wind_dir_scalar_avg_last_10_min': 233, 'wind_speed_hi_last_10_min': 13.0, 'wind_dir_at_hi_speed_last_10_min': 240, 'rain_size': 2, 'rain_rate_last': 0, 'rain_rate_hi': 0, 'rainfall_last_15_min': 0, 'rain_rate_hi_last_15_min': 0, 'rainfall_last_60_min': 0, 'rainfall_last_24_hr': 0, 'rain_storm': 0, 'rain_storm_start_at': None, 'solar_rad': 754, 'uv_index': 4.1, 'rx_state': 0, 'trans_battery_flag': 0, 'rainfall_daily': 0, 'rainfall_monthly': 0, 'rainfall_year': 364, 'rain_storm_last': 67, 'rain_storm_last_start_at': 1613874241, 'rain_storm_last_end_at': 1614024061}, {'lsid': 319566, 'data_structure_type': 4, 'temp_in': 70.4, 'hum_in': 53.2, 'dew_point_in': 52.6, 'heat_index_in': 68.9}, {'lsid': 319565, 'data_structure_type': 3, 'bar_sea_level': 30.212, 'bar_trend': 0.013, 'bar_absolute': 30.189}]},

    [{'did': '001D0A711E25', 'timestamp': '2021-03-05T09:18:32.000Z', 'lsid': 319575, 'type': 1, 'txid': 1, 'temp': 17.6, 'hum': 61.6, 'dewPoint': 10.2, 'wetBulb': 12.7, 'heatIndex': 17.1, 'windChill': 17.4, 'thwIndex': 16.9, 'thswIndex': 23.1, 'windSpeedLast': 12.87472, 'windDirLast': 242, 'windSpeedAvgLast1Min': 14.7737412, 'windDirScalarAvgLast1Min': 229, 'windSpeedAvgLast2Min': 14.3714062, 'windDirScalarAvgLast2Min': 224, 'windSpeedHiLast2Min': 20.92142, 'windDirAtHiSpeedLast2Min': 240, 'windSpeedAvgLast10Min': 12.1666104, 'windDirScalarAvgLast10Min': 233, 'windSpeedHiLast10Min': 20.92142, 'windDirAtHiSpeedLast10Min': 240, 'rainSize': 2, 'rainRateLast': 0, 'rainRateHi': 0, 'rainfallLast15Min': 0, 'rainRateHiLast15Min': 0, 'rainfallLast60Min': 0, 'rainfallLast24Hr': 0, 'rainStorm': 0, 'solarRad': 754, 'uvIndex': 4.1, 'rxState': 0, 'transBatteryFlag': 0, 'rainfallDaily': 0, 'rainfallMonthly': 0, 'rainfallYear': 364, 'rainStormLast': 67, 'rainStormLastStartAt': '2021-02-21T02:24:01.000Z', 'rainStormLastEndAt': '2021-02-22T20:01:01.000Z'},
    {'did': '001D0A711E25', 'timestamp': '2021-03-05T09:18:32.000Z', 'lsid': 319566, 'type': 4, 'tempIn': 21.3, 'humIn': 53.2, 'dewPointIn': 11.4, 'heatIndexIn': 20.5},
    {'did': '001D0A711E25', 'timestamp': '2021-03-05T09:18:32.000Z', 'lsid': 319565, 'type': 3, 'barSeaLevel': 76.73848, 'barTrend': 0.03302, 'barAbsolute': 76.68006}]),

    ({'did': '001D0A711E2A', 'ts': 1614892518, 'conditions': [{'lsid': 321621, 'data_structure_type': 1, 'txid': 1, 'temp': 40.8, 'hum': 93.3, 'dew_point': 39.0, 'wet_bulb': 39.9, 'heat_index': 40.8, 'wind_chill': 40.8, 'thw_index': 40.8, 'thsw_index': 38.8, 'wind_speed_last': 0.0, 'wind_dir_last': 0, 'wind_speed_avg_last_1_min': 1.0, 'wind_dir_scalar_avg_last_1_min': 80, 'wind_speed_avg_last_2_min': 0.93, 'wind_dir_scalar_avg_last_2_min': 79, 'wind_speed_hi_last_2_min': 3.0, 'wind_dir_at_hi_speed_last_2_min': 85, 'wind_speed_avg_last_10_min': 0.62, 'wind_dir_scalar_avg_last_10_min': 69, 'wind_speed_hi_last_10_min': 3.0, 'wind_dir_at_hi_speed_last_10_min': 54, 'rain_size': 2, 'rain_rate_last': 0, 'rain_rate_hi': 0, 'rainfall_last_15_min': 0, 'rain_rate_hi_last_15_min': 4, 'rainfall_last_60_min': 12, 'rainfall_last_24_hr': 22, 'rain_storm': 21, 'rain_storm_start_at': 1614880500, 'solar_rad': 0, 'uv_index': 0.0, 'rx_state': 0, 'trans_battery_flag': 0, 'rainfall_daily': 22, 'rainfall_monthly': 22, 'rainfall_year': 242, 'rain_storm_last': 17, 'rain_storm_last_start_at': 1614361260, 'rain_storm_last_end_at': 1614456061}, {'lsid': 321620, 'data_structure_type': 4, 'temp_in': 74.7, 'hum_in': 26.7, 'dew_point_in': 38.2, 'heat_index_in': 72.5}, {'lsid': 321619, 'data_structure_type': 3, 'bar_sea_level': 29.926, 'bar_trend': -0.003, 'bar_absolute': 28.286}]},

    [{'did': '001D0A711E2A', 'timestamp': '2021-03-04T21:15:18.000Z', 'lsid': 321621, 'type': 1, 'txid': 1, 'temp': 4.9, 'hum': 93.3, 'dewPoint': 3.9, 'wetBulb': 4.4, 'heatIndex': 4.9, 'windChill': 4.9, 'thwIndex': 4.9, 'thswIndex': 3.8, 'windSpeedLast': 0.0, 'windDirLast': 0, 'windSpeedAvgLast1Min': 1.60934, 'windDirScalarAvgLast1Min': 80, 'windSpeedAvgLast2Min': 1.4966862, 'windDirScalarAvgLast2Min': 79, 'windSpeedHiLast2Min': 4.82802, 'windDirAtHiSpeedLast2Min': 85, 'windSpeedAvgLast10Min': 0.9977908, 'windDirScalarAvgLast10Min': 69, 'windSpeedHiLast10Min': 4.82802, 'windDirAtHiSpeedLast10Min': 54, 'rainSize': 2, 'rainRateLast': 0, 'rainRateHi': 0, 'rainfallLast15Min': 0, 'rainRateHiLast15Min': 4, 'rainfallLast60Min': 12, 'rainfallLast24Hr': 22, 'rainStorm': 21, 'solarRad': 0, 'uvIndex': 0.0, 'rxState': 0, 'transBatteryFlag': 0, 'rainfallDaily': 22, 'rainfallMonthly': 22, 'rainfallYear': 242, 'rainStormLast': 17, 'rainStormStartAt': '2021-03-04T17:55:00.000Z', 'rainStormLastStartAt': '2021-02-26T17:41:00.000Z', 'rainStormLastEndAt': '2021-02-27T20:01:01.000Z'},
    {'did': '001D0A711E2A', 'timestamp': '2021-03-04T21:15:18.000Z', 'lsid': 321620, 'type': 4, 'tempIn': 23.7, 'humIn': 26.7, 'dewPointIn': 3.4, 'heatIndexIn': 22.5},
    {'did': '001D0A711E2A', 'timestamp': '2021-03-04T21:15:18.000Z', 'lsid': 321619, 'type': 3, 'barSeaLevel': 76.01204, 'barTrend': -0.00762, 'barAbsolute': 71.84644}]),
]

class TestDataProcessing:
    @pytest.mark.parametrize("test_input,expected_output", test_data)
    def test_process(self, test_input, expected_output):
        config = {}
        m = WeatherConditions(config, lambda x: x)
        processed_data = m._process_data(test_input)
        assert expected_output == processed_data
