from http import HTTPStatus
from typing import Any, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.api_result_response_list_tag_dto import ApiResultResponseListTagDTO
from ...types import Response


def _get_kwargs(
    logbook_id: str,
) -> dict[str, Any]:
    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": f"/v1/logbooks/{logbook_id}/tags",
    }

    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[ApiResultResponseListTagDTO]:
    if response.status_code == 200:
        response_200 = ApiResultResponseListTagDTO.from_dict(response.json())

        return response_200
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[ApiResultResponseListTagDTO]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    logbook_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
) -> Response[ApiResultResponseListTagDTO]:
    """
    Args:
        logbook_id (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[ApiResultResponseListTagDTO]
    """

    kwargs = _get_kwargs(
        logbook_id=logbook_id,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    logbook_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
) -> Optional[ApiResultResponseListTagDTO]:
    """
    Args:
        logbook_id (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        ApiResultResponseListTagDTO
    """

    return sync_detailed(
        logbook_id=logbook_id,
        client=client,
    ).parsed


async def asyncio_detailed(
    logbook_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
) -> Response[ApiResultResponseListTagDTO]:
    """
    Args:
        logbook_id (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[ApiResultResponseListTagDTO]
    """

    kwargs = _get_kwargs(
        logbook_id=logbook_id,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    logbook_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
) -> Optional[ApiResultResponseListTagDTO]:
    """
    Args:
        logbook_id (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        ApiResultResponseListTagDTO
    """

    return (
        await asyncio_detailed(
            logbook_id=logbook_id,
            client=client,
        )
    ).parsed
